/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.gui.ingredients.IGuiIngredient;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.UniqueItemStackListBuilder;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper
implements IStackHelper {
    public static final String nullItemInStack = "Found an itemStack with a null item. This is an error from another mod.";
    private final Map<UidMode, Map<ItemStack, String>> uidCache = new EnumMap<UidMode, Map<ItemStack, String>>(UidMode.class);
    private boolean uidCacheEnabled = true;

    public StackHelper() {
        for (UidMode mode : UidMode.values()) {
            this.uidCache.put(mode, new HashMap());
        }
    }

    public void enableUidCache() {
        this.uidCacheEnabled = true;
    }

    public void disableUidCache() {
        for (UidMode mode : UidMode.values()) {
            this.uidCache.get((Object)mode).clear();
        }
        this.uidCacheEnabled = false;
    }

    @Nullable
    public String getOreDictEquivalent(@Nonnull Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        ItemStack firstStack = itemStacks.iterator().next();
        if (firstStack != null) {
            for (int oreId : OreDictionary.getOreIDs((ItemStack)firstStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                List<ItemStack> ores = OreDictionary.getOres((String)oreName);
                if (!this.containsSameStacks(itemStacks, ores = this.getAllSubtypes(ores))) continue;
                return oreName;
            }
        }
        return null;
    }

    @Nonnull
    public MatchingItemsResult getMatchingItems(@Nonnull List<ItemStack> availableItemStacks, @Nonnull Map<Integer, ? extends IGuiIngredient<ItemStack>> ingredientsMap) {
        MatchingItemsResult matchingItemResult = new MatchingItemsResult();
        int recipeSlotNumber = -1;
        TreeSet<Integer> keys = new TreeSet<Integer>(ingredientsMap.keySet());
        for (Integer key : keys) {
            IGuiIngredient<ItemStack> ingredient = ingredientsMap.get(key);
            if (!ingredient.isInput()) continue;
            ++recipeSlotNumber;
            List<ItemStack> requiredStacks = ingredient.getAllIngredients();
            if (requiredStacks.isEmpty()) continue;
            ItemStack matching = this.containsStack(availableItemStacks, requiredStacks);
            if (matching == null) {
                matchingItemResult.missingItems.add(key);
                continue;
            }
            ItemStack matchingSplit = matching.func_77979_a(1);
            if (matching.field_77994_a == 0) {
                availableItemStacks.remove(matching);
            }
            matchingItemResult.matchingItems.put(recipeSlotNumber, matchingSplit);
        }
        return matchingItemResult;
    }

    @Nullable
    public Slot getSlotWithStack(@Nonnull Container container, @Nonnull Iterable<Integer> slotNumbers, @Nonnull ItemStack stack) {
        for (Integer slotNumber : slotNumbers) {
            ItemStack slotStack;
            Slot slot = container.func_75139_a(slotNumber.intValue());
            if (slot == null || !this.isEquivalent(stack, slotStack = slot.func_75211_c())) continue;
            return slot;
        }
        return null;
    }

    public boolean containsSameStacks(@Nonnull Iterable<ItemStack> stacks, @Nonnull Iterable<ItemStack> contains) {
        for (ItemStack stack : contains) {
            if (this.containsStack(stacks, stack) != null) continue;
            return false;
        }
        for (ItemStack stack : stacks) {
            if (this.containsStack(contains, stack) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack containsStack(@Nullable Iterable<ItemStack> stacks, @Nullable Iterable<ItemStack> contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (ItemStack containStack : contains) {
            ItemStack matchingStack = this.containsStack(stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public ItemStack containsStack(@Nullable Iterable<ItemStack> stacks, @Nullable ItemStack contains) {
        if (stacks == null || contains == null) {
            return null;
        }
        for (ItemStack stack : stacks) {
            if (!this.isEquivalent(contains, stack)) continue;
            return stack;
        }
        return null;
    }

    public boolean isEquivalent(@Nullable ItemStack lhs, @Nullable ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.func_77973_b() != rhs.func_77973_b()) {
            return false;
        }
        if (lhs.func_77960_j() != Short.MAX_VALUE && lhs.func_77960_j() != rhs.func_77960_j()) {
            return false;
        }
        if (lhs.func_77981_g()) {
            String keyLhs = this.getUniqueIdentifierForStack(lhs, UidMode.NORMAL);
            String keyRhs = this.getUniqueIdentifierForStack(rhs, UidMode.NORMAL);
            return Objects.equals(keyLhs, keyRhs);
        }
        return true;
    }

    @Override
    @Nonnull
    public List<ItemStack> getSubtypes(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            Log.error("Null itemStack", new NullPointerException());
            return Collections.emptyList();
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            Log.error("Null item in itemStack", new NullPointerException());
            return Collections.emptyList();
        }
        if (itemStack.func_77952_i() != Short.MAX_VALUE) {
            return Collections.singletonList(itemStack);
        }
        return this.getSubtypes(item, itemStack.field_77994_a);
    }

    @Nonnull
    public List<ItemStack> getSubtypes(@Nonnull Item item, int stackSize) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            ArrayList subItems = new ArrayList();
            try {
                item.func_150895_a(item, itemTab, subItems);
            }
            catch (LinkageError | RuntimeException e) {
                Log.warning("Caught a crash while getting sub-items of {}", item, e);
            }
            for (ItemStack subItem : subItems) {
                if (subItem == null) {
                    Log.warning("Found a null subItem of {}", item);
                    continue;
                }
                if (subItem.func_77973_b() == null) {
                    Log.warning("Found a subItem of {} with a null item", item);
                    continue;
                }
                if (subItem.field_77994_a != stackSize) {
                    ItemStack subItemCopy = subItem.func_77946_l();
                    subItemCopy.field_77994_a = stackSize;
                    itemStacks.add(subItemCopy);
                    continue;
                }
                itemStacks.add(subItem);
            }
        }
        return itemStacks;
    }

    @Override
    @Nonnull
    public List<ItemStack> getAllSubtypes(@Nullable Iterable stacks) {
        if (stacks == null) {
            Log.error("Null stacks", new NullPointerException());
            return Collections.emptyList();
        }
        ArrayList<ItemStack> allSubtypes = new ArrayList<ItemStack>();
        this.getAllSubtypes(allSubtypes, stacks);
        return allSubtypes;
    }

    private void getAllSubtypes(@Nonnull List<ItemStack> subtypesList, @Nonnull Iterable stacks) {
        for (Object obj : stacks) {
            if (obj instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)obj;
                List<ItemStack> subtypes = this.getSubtypes(itemStack);
                subtypesList.addAll(subtypes);
                continue;
            }
            if (obj instanceof Iterable) {
                this.getAllSubtypes(subtypesList, (Iterable)obj);
                continue;
            }
            if (obj == null) continue;
            Log.error("Unknown object found: {}", obj);
        }
    }

    @Override
    @Nonnull
    public List<ItemStack> toItemStackList(@Nullable Object stacks) {
        if (stacks == null) {
            return Collections.emptyList();
        }
        UniqueItemStackListBuilder itemStackListBuilder = new UniqueItemStackListBuilder();
        this.toItemStackList(itemStackListBuilder, stacks);
        return itemStackListBuilder.build();
    }

    private void toItemStackList(@Nonnull UniqueItemStackListBuilder itemStackListBuilder, @Nullable Object input) {
        if (input instanceof ItemStack) {
            ItemStack stack = (ItemStack)input;
            itemStackListBuilder.add(stack);
        } else if (input instanceof String) {
            List stacks = OreDictionary.getOres((String)((String)input));
            for (ItemStack stack : stacks) {
                itemStackListBuilder.add(stack);
            }
        } else if (input instanceof Iterable) {
            for (Object obj : (Iterable)input) {
                this.toItemStackList(itemStackListBuilder, obj);
            }
        } else if (input != null) {
            Log.error("Unknown object found: {}", input);
        }
    }

    @Nonnull
    public String getModId(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            throw new NullPointerException(nullItemInStack);
        }
        ResourceLocation itemName = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        if (itemName == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            throw new NullPointerException("Item.itemRegistry.getNameForObject returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    @Nonnull
    public String getUniqueIdentifierForStack(@Nonnull ItemStack stack) {
        return this.getUniqueIdentifierForStack(stack, UidMode.NORMAL);
    }

    @Nonnull
    public String getUniqueIdentifierForStack(@Nonnull ItemStack stack, @Nonnull UidMode mode) {
        String result;
        if (this.uidCacheEnabled && (result = this.uidCache.get((Object)mode).get(stack)) != null) {
            return result;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            throw new NullPointerException(nullItemInStack);
        }
        int metadata = stack.func_77960_j();
        if (mode == UidMode.WILDCARD || metadata == Short.MAX_VALUE) {
            ResourceLocation itemName = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            if (itemName == null) {
                String stackInfo = ErrorUtil.getItemStackInfo(stack);
                throw new NullPointerException("Item is not registered. Item.REGISTRY.getNameForObject returned null for: " + stackInfo);
            }
            return itemName.toString();
        }
        NBTTagCompound serializedNbt = stack.serializeNBT();
        StringBuilder itemKey = new StringBuilder(serializedNbt.func_74779_i("id"));
        if (mode == UidMode.FULL) {
            itemKey.append(':').append(metadata);
            NBTTagCompound nbtTagCompound = serializedNbt.func_74775_l("tag");
            if (serializedNbt.func_74764_b("ForgeCaps")) {
                if (nbtTagCompound == null) {
                    nbtTagCompound = new NBTTagCompound();
                }
                nbtTagCompound.func_74782_a("ForgeCaps", (NBTBase)serializedNbt.func_74775_l("ForgeCaps"));
            }
            if (nbtTagCompound != null && !nbtTagCompound.func_82582_d()) {
                itemKey.append(':').append(nbtTagCompound);
            }
        } else if (stack.func_77981_g()) {
            itemKey.append(':').append(metadata);
            String subtypeInfo = Internal.getHelpers().getSubtypeRegistry().getSubtypeInfo(stack);
            if (subtypeInfo != null) {
                itemKey.append(':').append(subtypeInfo);
            }
        }
        String result2 = itemKey.toString();
        if (this.uidCacheEnabled) {
            this.uidCache.get((Object)mode).put(stack, result2);
        }
        return result2;
    }

    @Nonnull
    public List<String> getUniqueIdentifiersWithWildcard(@Nonnull ItemStack itemStack) {
        String uidWild;
        String uid = this.getUniqueIdentifierForStack(itemStack, UidMode.NORMAL);
        if (uid.equals(uidWild = this.getUniqueIdentifierForStack(itemStack, UidMode.WILDCARD))) {
            return Collections.singletonList(uid);
        }
        return Arrays.asList(uid, uidWild);
    }

    public int addStack(@Nonnull Container container, @Nonnull Collection<Integer> slotIndexes, @Nonnull ItemStack stack, boolean doAdd) {
        ItemStack inventoryStack;
        Slot slot;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            slot = container.func_75139_a(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.func_75211_c()) == null || inventoryStack.func_77973_b() == null || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.field_77994_a - added;
            int maxStackSize = Math.min(slot.func_178170_b(inventoryStack), inventoryStack.func_77976_d());
            int space = maxStackSize - inventoryStack.field_77994_a;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.field_77994_a += remain;
                }
                return stack.field_77994_a;
            }
            if (doAdd) {
                inventoryStack.field_77994_a = inventoryStack.func_77976_d();
            }
            added += space;
        }
        if (added >= stack.field_77994_a) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            slot = container.func_75139_a(slotIndex.intValue());
            if (slot == null || (inventoryStack = slot.func_75211_c()) != null) continue;
            if (doAdd) {
                ItemStack stackToAdd = stack.func_77946_l();
                stackToAdd.field_77994_a = stack.field_77994_a - added;
                slot.func_75215_d(stackToAdd);
            }
            return stack.field_77994_a;
        }
        return added;
    }

    public static class MatchingItemsResult {
        @Nonnull
        public final Map<Integer, ItemStack> matchingItems = new HashMap<Integer, ItemStack>();
        @Nonnull
        public final List<Integer> missingItems = new ArrayList<Integer>();
    }

    public static enum UidMode {
        NORMAL,
        WILDCARD,
        FULL;

    }
}

