/*
 * Decompiled with CFR 0.152.
 */
package com.herobrine.mod.entities;

import com.herobrine.mod.entities.InfectedCowEntity;
import com.herobrine.mod.util.entities.EntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import org.jetbrains.annotations.NotNull;

public class InfectedMooshroomEntity
extends InfectedCowEntity
implements IShearable {
    private static final DataParameter<String> MOOSHROOM_TYPE = EntityDataManager.func_187226_a(InfectedMooshroomEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private Effect hasStewEffect;
    private int effectDuration;
    private UUID lightningUUID;

    public InfectedMooshroomEntity(EntityType<? extends InfectedMooshroomEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 3;
    }

    public InfectedMooshroomEntity(World worldIn) {
        this((EntityType<? extends InfectedMooshroomEntity>)EntityRegistry.INFECTED_MOOSHROOM_ENTITY, worldIn);
    }

    public void func_70077_a(@NotNull LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!uuid.equals(this.lightningUUID)) {
            this.setMooshroomType(this.getMooshroomType() == Type.RED ? Type.BROWN : Type.RED);
            this.lightningUUID = uuid;
            this.func_184185_a(SoundEvents.field_219658_gv, 2.0f, 1.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOOSHROOM_TYPE, (Object)Type.RED.name);
    }

    public boolean func_184645_a(@NotNull PlayerEntity player, @NotNull Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151097_aZ) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                InfectedCowEntity cowentity = (InfectedCowEntity)EntityRegistry.INFECTED_COW_ENTITY.func_200721_a(this.field_70170_p);
                assert (cowentity != null);
                cowentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
                cowentity.func_70606_j(this.func_110143_aJ());
                cowentity.field_70761_aq = this.field_70761_aq;
                if (this.func_145818_k_()) {
                    cowentity.func_200203_b(this.func_200201_e());
                    cowentity.func_174805_g(this.func_174833_aM());
                }
                if (this.func_104002_bU()) {
                    cowentity.func_110163_bv();
                }
                cowentity.func_184224_h(this.func_190530_aW());
                this.field_70170_p.func_217376_c((Entity)cowentity);
                for (int k = 0; k < 5; ++k) {
                    this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226283_e_(1.0), this.func_226281_cx_(), new ItemStack((IItemProvider)this.getMooshroomType().renderState.func_177230_c())));
                }
                itemstack.func_222118_a(1, (LivingEntity)player, p_213442_1_ -> p_213442_1_.func_213334_d(hand));
                this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getMooshroomType().name);
        if (this.hasStewEffect != null) {
            compound.func_74774_a("EffectId", (byte)Effect.func_188409_a((Effect)this.hasStewEffect));
            compound.func_74768_a("EffectDuration", this.effectDuration);
        }
    }

    public void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMooshroomType(Type.getTypeByName(compound.func_74779_i("Type")));
        if (compound.func_150297_b("EffectId", 1)) {
            this.hasStewEffect = Effect.func_188412_a((int)compound.func_74771_c("EffectId"));
        }
        if (compound.func_150297_b("EffectDuration", 3)) {
            this.effectDuration = compound.func_74762_e("EffectDuration");
        }
    }

    private void setMooshroomType(@NotNull Type typeIn) {
        this.field_70180_af.func_187227_b(MOOSHROOM_TYPE, (Object)typeIn.name);
    }

    public Type getMooshroomType() {
        return Type.getTypeByName((String)this.field_70180_af.func_187225_a(InfectedMooshroomEntity.MOOSHROOM_TYPE));
    }

    public boolean isShearable(@NotNull ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.func_70631_g_();
    }

    @NotNull
    public List<ItemStack> onSheared(@NotNull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            InfectedCowEntity cowentity = (InfectedCowEntity)EntityRegistry.INFECTED_COW_ENTITY.func_200721_a(this.field_70170_p);
            assert (cowentity != null);
            cowentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            cowentity.func_70606_j(this.func_110143_aJ());
            cowentity.field_70761_aq = this.field_70761_aq;
            if (this.func_145818_k_()) {
                cowentity.func_200203_b(this.func_200201_e());
                cowentity.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_217376_c((Entity)cowentity);
            for (int i = 0; i < 5; ++i) {
                ret.add(new ItemStack((IItemProvider)this.getMooshroomType().renderState.func_177230_c()));
            }
            this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
        }
        return ret;
    }

    public static enum Type {
        RED("red", Blocks.field_150337_Q.func_176223_P()),
        BROWN("brown", Blocks.field_150338_P.func_176223_P());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type mooshroomentity$type : Type.values()) {
                if (!mooshroomentity$type.name.equals(nameIn)) continue;
                return mooshroomentity$type;
            }
            return RED;
        }
    }
}

