/*
 * Decompiled with CFR 0.152.
 */
package com.herobrine.mod.entities;

import com.google.common.collect.Maps;
import com.herobrine.mod.entities.UnholyWaterEntity;
import com.herobrine.mod.util.entities.EntityRegistry;
import com.herobrine.mod.util.savedata.Variables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class InfectedSheepEntity
extends MonsterEntity
implements IShearable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(InfectedSheepEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Map<DyeColor, IItemProvider> WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), woolDrop -> {
        woolDrop.put(DyeColor.WHITE, Blocks.field_196556_aL);
        woolDrop.put(DyeColor.ORANGE, Blocks.field_196557_aM);
        woolDrop.put(DyeColor.MAGENTA, Blocks.field_196558_aN);
        woolDrop.put(DyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        woolDrop.put(DyeColor.YELLOW, Blocks.field_196560_aP);
        woolDrop.put(DyeColor.LIME, Blocks.field_196561_aQ);
        woolDrop.put(DyeColor.PINK, Blocks.field_196562_aR);
        woolDrop.put(DyeColor.GRAY, Blocks.field_196563_aS);
        woolDrop.put(DyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        woolDrop.put(DyeColor.CYAN, Blocks.field_196565_aU);
        woolDrop.put(DyeColor.PURPLE, Blocks.field_196566_aV);
        woolDrop.put(DyeColor.BLUE, Blocks.field_196567_aW);
        woolDrop.put(DyeColor.BROWN, Blocks.field_196568_aX);
        woolDrop.put(DyeColor.GREEN, Blocks.field_196569_aY);
        woolDrop.put(DyeColor.RED, Blocks.field_196570_aZ);
        woolDrop.put(DyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<DyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(color -> color, InfectedSheepEntity::createSheepColor)));
    private int sheepTimer;
    private EatGrassGoal eatGrassGoal;

    @NotNull
    @Contract(value="_ -> new", pure=true)
    private static float[] createSheepColor(DyeColor dyeColorIn) {
        if (dyeColorIn == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = dyeColorIn.func_193349_f();
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] getDyeRgb(DyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public InfectedSheepEntity(EntityType<? extends InfectedSheepEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 3;
    }

    public InfectedSheepEntity(World worldIn) {
        this(EntityRegistry.INFECTED_SHEEP_ENTITY, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(4, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        if (source.func_76364_f() instanceof UnholyWaterEntity) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(@NotNull Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    @NotNull
    public ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTables.field_186404_L;
            }
            case ORANGE: {
                return LootTables.field_186405_M;
            }
            case MAGENTA: {
                return LootTables.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTables.field_186407_O;
            }
            case YELLOW: {
                return LootTables.field_186408_P;
            }
            case LIME: {
                return LootTables.field_186409_Q;
            }
            case PINK: {
                return LootTables.field_186410_R;
            }
            case GRAY: {
                return LootTables.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTables.field_197738_Y;
            }
            case CYAN: {
                return LootTables.field_186413_U;
            }
            case PURPLE: {
                return LootTables.field_186414_V;
            }
            case BLUE: {
                return LootTables.field_186415_W;
            }
            case BROWN: {
                return LootTables.field_186416_X;
            }
            case GREEN: {
                return LootTables.field_186417_Y;
            }
            case RED: {
                return LootTables.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTables.field_186376_aa;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_184645_a(@NotNull PlayerEntity player, @NotNull Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151097_aZ && !this.getSheared()) {
            this.func_213612_dV();
            if (!this.field_70170_p.field_72995_K) {
                itemstack.func_222118_a(1, (LivingEntity)player, p_213613_1_ -> p_213613_1_.func_213334_d(hand));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_213612_dV() {
        if (!this.field_70170_p.field_72995_K) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ItemEntity itementity = this.func_199702_a(WOOL_BY_COLOR.get(this.getFleeceColor()), 1);
                if (itementity == null) continue;
                itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
    }

    public void func_213281_b(@NotNull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74774_a("Color", (byte)this.getFleeceColor().func_196059_a());
    }

    public void func_70037_a(@NotNull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setFleeceColor(DyeColor.func_196056_a((int)compound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public DyeColor getFleeceColor() {
        return DyeColor.func_196056_a((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(@NotNull DyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_196059_a() & 0xF)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public static DyeColor getRandomSheepColor(@NotNull Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.BLACK;
        }
        if (i < 10) {
            return DyeColor.GRAY;
        }
        if (i < 15) {
            return DyeColor.LIGHT_GRAY;
        }
        if (i < 18) {
            return DyeColor.BROWN;
        }
        return random.nextInt(500) == 0 ? DyeColor.PINK : DyeColor.WHITE;
    }

    public void func_70615_aA() {
        this.setSheared(false);
    }

    @Nullable
    public ILivingEntityData func_213386_a(@NotNull IWorld worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setFleeceColor(InfectedSheepEntity.getRandomSheepColor(worldIn.func_201674_k()));
        Variables.WorldVariables.get(this.field_70170_p).syncData(this.field_70170_p);
        if (!Variables.WorldVariables.get((World)this.field_70170_p).Spawn) {
            this.func_70106_y();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected float func_213348_b(@NotNull Pose poseIn, @NotNull EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    public boolean isShearable(@NotNull ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.getSheared();
    }

    @NotNull
    public List<ItemStack> onSheared(@NotNull ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack(WOOL_BY_COLOR.get(this.getFleeceColor())));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }
}

