/*
 * Decompiled with CFR 0.152.
 */
package com.herobrine.mod.util.savedata;

import com.herobrine.mod.HerobrineMod;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class Variables {

    public static class WorldSavedDataSyncMessage {
        public int type;
        public WorldSavedData data;

        public WorldSavedDataSyncMessage(@NotNull PacketBuffer buffer) {
            this.type = buffer.readInt();
            this.data = new WorldVariables();
            this.data.func_76184_a(Objects.requireNonNull(buffer.func_150793_b()));
        }

        public WorldSavedDataSyncMessage(int type, WorldSavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(@NotNull WorldSavedDataSyncMessage message, @NotNull PacketBuffer buffer) {
            buffer.writeInt(message.type);
            buffer.func_150786_a(message.data.func_189551_b(new CompoundNBT()));
        }

        public static void handler(WorldSavedDataSyncMessage message, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isServer()) {
                    WorldSavedDataSyncMessage.syncData(message, context.getDirection().getReceptionSide(), Objects.requireNonNull(context.getSender()).field_70170_p);
                } else {
                    assert (Minecraft.func_71410_x().field_71439_g != null);
                    WorldSavedDataSyncMessage.syncData(message, context.getDirection().getReceptionSide(), Minecraft.func_71410_x().field_71439_g.field_70170_p);
                }
            });
            context.setPacketHandled(true);
        }

        private static void syncData(WorldSavedDataSyncMessage message, @NotNull LogicalSide side, World world) {
            if (side.isServer()) {
                if (message.type == 0) {
                    HerobrineMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)message);
                    Objects.requireNonNull(world.func_73046_m()).func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215757_a(message.data);
                } else {
                    HerobrineMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.field_73011_w).func_186058_p()), (Object)message);
                    ((ServerWorld)world).func_217481_x().func_215757_a(message.data);
                }
            } else {
                WorldVariables.clientSide = (WorldVariables)message.data;
            }
        }
    }

    public static class WorldVariables
    extends WorldSavedData {
        public static final String DATA_NAME = "herobrine_worldvars";
        public boolean Spawn = false;
        private int messageID = 0;
        static WorldVariables clientSide = new WorldVariables();

        public WorldVariables() {
            super(DATA_NAME);
            this.addNetworkMessage(WorldSavedDataSyncMessage.class, WorldSavedDataSyncMessage::buffer, WorldSavedDataSyncMessage::new, WorldSavedDataSyncMessage::handler);
        }

        public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
            HerobrineMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
            ++this.messageID;
        }

        public void func_76184_a(@NotNull CompoundNBT nbt) {
            this.Spawn = nbt.func_74767_n("Spawn");
        }

        @NotNull
        public CompoundNBT func_189551_b(@NotNull CompoundNBT nbt) {
            nbt.func_74757_a("Spawn", this.Spawn);
            return nbt;
        }

        public void syncData(@NotNull World world) {
            this.func_76185_a();
            if (world.field_72995_K) {
                HerobrineMod.PACKET_HANDLER.sendToServer((Object)new WorldSavedDataSyncMessage(1, this));
            } else {
                HerobrineMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Dimension)world.field_73011_w).func_186058_p()), (Object)new WorldSavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(World world) {
            if (world instanceof ServerWorld) {
                return (WorldVariables)((ServerWorld)world).func_217481_x().func_215752_a(WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }
}

