/*
 * Decompiled with CFR 0.152.
 */
package liquidspack;

import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
@Mod(modid="liquidspack", name="Liquid's vehicles pack", version="1.0.0", dependencies="required-after:mts@[17.0.0,);", acceptedMinecraftVersions="[1.12.2,]")
public class MTSPackLoader {
    public static final String MODID = "liquidspack";
    public static final String MODNAME = "Liquid's vehicles pack";
    public static final String MODVER = "1.0.0";
    public static final String DEPS = "required-after:mts@[17.0.0,);";
    public static final String MCVERS = "[1.12.2,]";

    public MTSPackLoader() {
        try {
            String[] contentNames;
            String className = this.getClass().getSimpleName();
            String packageName = this.getClass().getPackage().getName();
            String classDir = this.getClass().getClassLoader().getResource(packageName).getPath();
            URI classURI = new URI(classDir);
            classDir = classURI.getPath();
            classDir = classDir.substring(0, classDir.indexOf(33));
            Class<?> packParserSystem = Class.forName("minecrafttransportsimulator.systems.PackParserSystem");
            Method getPackContentNamesMethod = packParserSystem.getMethod("getValidPackContentNames", new Class[0]);
            for (String contentName : contentNames = (String[])getPackContentNamesMethod.invoke(null, new Object[0])) {
                ArrayList<String> entryNames = new ArrayList<String>();
                Method addContentMethod = packParserSystem.getMethod("add" + contentName.substring(0, 1).toUpperCase() + contentName.substring(1) + "Definition", InputStreamReader.class, String.class, String.class);
                ZipFile jarFile = new ZipFile(classDir);
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".json") || !entry.getName().contains("jsondefs/" + contentName + "s")) continue;
                    entryNames.add(entry.getName());
                }
                entryNames.sort(null);
                for (String entryName : entryNames) {
                    String entryFileName = entryName.substring(entryName.lastIndexOf(47) + 1, entryName.length() - ".json".length());
                    addContentMethod.invoke(null, new InputStreamReader(jarFile.getInputStream(jarFile.getEntry(entryName)), "UTF-8"), entryFileName, MODID);
                }
                jarFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        try {
            Class<?> registry = Class.forName("minecrafttransportsimulator.dataclasses.MTSRegistry");
            Method getItemsMethod = registry.getMethod("getItemsForPack", String.class);
            List itemList = (List)getItemsMethod.invoke(null, MODID);
            for (Item item : itemList) {
                item.setRegistryName(new ResourceLocation(MODID, item.func_77658_a().replace("item.liquidspack.", "")));
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

