/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.blocks;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTileTileEntity;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTile
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    public static Minecraft mc;
    public static boolean cancelNext;
    public boolean first = true;
    @SideOnly(value=Side.CLIENT)
    public IIcon overrideIcon;
    public static TileEntityLittleTiles tempEntity;

    public BlockTile(Material material) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        if (BlockTile.loadTileEntity(world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                if (!tile.isBed(world, x, y, z, player)) continue;
                return true;
            }
        }
        return false;
    }

    public ChunkCoordinates getBedSpawnPosition(IBlockAccess world, int x, int y, int z, EntityPlayer player) {
        if (world instanceof World) {
            return new ChunkCoordinates(x, y, z);
        }
        return null;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        AxisAlignedBB bb = entity.field_70121_D;
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    TileEntity te = world.func_147438_o(x, y, z2);
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles littleTE = (TileEntityLittleTiles)te;
                        for (int i = 0; i < littleTE.tiles.size(); ++i) {
                            if (!littleTE.tiles.get(i).isLadder()) continue;
                            for (int j = 0; j < littleTE.tiles.get((int)i).boundingBoxes.size(); ++j) {
                                LittleTileBox box = littleTE.tiles.get((int)i).boundingBoxes.get(j).copy();
                                box.addOffset(new LittleTileVec(x2 * 16, y2 * 16, z2 * 16));
                                double expand = 1.0E-4;
                                if (!bb.func_72326_a(box.getBox().func_72314_b(expand, expand, expand))) continue;
                                return true;
                            }
                        }
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return LittleTilesClient.modelID;
    }

    public boolean func_149721_r() {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile(player) && BlockTile.tempEntity.loadedTile instanceof LittleTileBlock) {
            return ((LittleTileBlock)BlockTile.tempEntity.loadedTile).block.func_149737_a(player, world, x, y, z);
        }
        return super.func_149712_f(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile((EntityPlayer)BlockTile.mc.field_71439_g)) {
            try {
                return BlockTile.tempEntity.loadedTile.getSelectedBox().func_72325_c((double)x, (double)y, (double)z);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                for (int i = 0; i < tile.boundingBoxes.size(); ++i) {
                    AxisAlignedBB box = tile.boundingBoxes.get(i).getBox().func_72325_c((double)x, (double)y, (double)z);
                    if (!axis.func_72326_a(box)) continue;
                    list.add(box);
                }
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && BlockTile.tempEntity.tiles.size() == 0) {
            super.func_149749_a(world, x, y, z, block, meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                tile.randomDisplayTick(world, x, y, z, random);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile(player)) {
            try {
                if (world.field_72995_K) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(x, y, z, player, 0));
                }
                return BlockTile.tempEntity.loadedTile.onBlockActivated(world, x, y, z, player, side, moveX, moveY, moveZ);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cancelNext) {
            cancelNext = false;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List items) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        try {
            int light = 0;
            if (!this.first) {
                return 0;
            }
            if (BlockTile.loadTileEntity(world, x, y, z)) {
                for (LittleTile tile : BlockTile.tempEntity.tiles) {
                    this.first = false;
                    int tempLight = tile.getLightValue(world, x, y, z);
                    this.first = true;
                    if (tempLight <= light) continue;
                    light = tempLight;
                }
            }
            return light;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile(player)) {
            try {
                BlockTile.tempEntity.loadedTile.destroy();
                NBTTagCompound nbt = new NBTTagCompound();
                tempEntity.func_145841_b(nbt);
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(x, y, z, player, 1));
                tempEntity.updateRender();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return this.removedByPlayer(world, player, x, y, z);
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        if (BlockTile.loadTileEntity(world, x, y, z)) {
            return BlockTile.tempEntity.tiles.size() == 0;
        }
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                stacks.addAll(tile.getDrops());
            }
        }
        return stacks;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile(player)) {
            try {
                ArrayList<ItemStack> drops = BlockTile.tempEntity.loadedTile.getDrops();
                if (drops.size() > 0) {
                    return drops.get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        try {
            if (BlockTile.loadTileEntity((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d) && tempEntity.updateLoadedTile((EntityPlayer)BlockTile.mc.field_71439_g)) {
                this.overrideIcon = BlockTile.tempEntity.loadedTile.getIcon(target.field_72310_e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        try {
            if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z) && tempEntity.updateLoadedTile((EntityPlayer)BlockTile.mc.field_71439_g)) {
                AxisAlignedBB box = BlockTile.tempEntity.loadedTile.getSelectedBox();
                int b0 = 1;
                for (int i1 = 0; i1 < b0; ++i1) {
                    for (int j1 = 0; j1 < b0; ++j1) {
                        for (int k1 = 0; k1 < b0; ++k1) {
                            double d0 = (double)x + ((double)i1 + box.field_72336_d) / (double)b0;
                            double d1 = (double)y + ((double)j1 + box.field_72337_e) / (double)b0;
                            double d2 = (double)z + ((double)k1 + box.field_72334_f) / (double)b0;
                            EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, meta).func_70596_a(x, y, z);
                            fx.func_110125_a(BlockTile.tempEntity.loadedTile.getIcon(0));
                            effectRenderer.func_78873_a((EntityFX)fx);
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.overrideIcon != null) {
            IIcon temp = this.overrideIcon;
            return temp;
        }
        return Blocks.field_150348_b.func_149733_h(0);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            if (this.isSideSolid(world, x, y, z, ForgeDirection.getOrientation((int)i))) continue;
            return false;
        }
        return true;
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        float bonus = 0.0f;
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                bonus = (float)((double)bonus + tile.getEnchantPowerBonus(world, x, y, z) * tile.getPercentVolume());
            }
        }
        return bonus;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        if (BlockTile.loadTileEntity(world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                tile.onNeighborChangeOutside();
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            for (LittleTile tile : BlockTile.tempEntity.tiles) {
                tile.onNeighborChangeOutside();
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec1, Vec3 vec2) {
        if (BlockTile.loadTileEntity((IBlockAccess)world, x, y, z)) {
            try {
                MovingObjectPosition moving = null;
                for (LittleTile tile : BlockTile.tempEntity.tiles) {
                    for (int i = 0; i < tile.boundingBoxes.size(); ++i) {
                        MovingObjectPosition tempMoving = tile.boundingBoxes.get(i).getBox().func_72325_c((double)x, (double)y, (double)z).func_72327_a(vec1, vec2);
                        if (tempMoving == null || moving != null && !(moving.field_72307_f.func_72438_d(vec1) > tempMoving.field_72307_f.func_72438_d(vec1))) continue;
                        moving = tempMoving;
                    }
                }
                if (moving != null) {
                    moving.field_72311_b = x;
                    moving.field_72312_c = y;
                    moving.field_72309_d = z;
                    return moving;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLittleTiles();
    }

    public static boolean loadTileEntity(IBlockAccess world, int x, int y, int z) {
        if (world == null) {
            tempEntity = null;
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        tempEntity = tileEntity instanceof TileEntityLittleTiles ? (TileEntityLittleTiles)tileEntity : null;
        return tempEntity != null;
    }

    public static TileEntity getTileEntityInWorld(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityLittleTiles && ((TileEntityLittleTiles)tileEntity).loadedTile instanceof LittleTileTileEntity) {
            return ((LittleTileTileEntity)((TileEntityLittleTiles)tileEntity).loadedTile).tileEntity;
        }
        return tileEntity;
    }

    public static LittleTile getLittleTileInWorld(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return ((TileEntityLittleTiles)tileEntity).loadedTile;
        }
        return null;
    }

    static {
        cancelNext = false;
    }
}

