/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LittleTile {
    private static HashMap<Class<? extends LittleTile>, String> tileIDs = new HashMap();
    public static final int minPos = 0;
    public static final int maxPos = 16;
    public TileEntityLittleTiles te;
    public LittleTileVec cornerVec;
    public ArrayList<LittleTileBox> boundingBoxes = new ArrayList();
    public static final int ticksBetweenRefresh = 1200;
    public int ticks = 0;
    public boolean isStructureBlock = false;
    public LittleStructure structure;
    public LittleTileCoord coord;
    public boolean isMainBlock = false;

    public static Class<? extends LittleTile> getClassByID(String id) {
        for (Map.Entry<Class<? extends LittleTile>, String> entry : tileIDs.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getIDByClass(Class<? extends LittleTile> LittleClass) {
        return tileIDs.get(LittleClass);
    }

    public static void registerLittleTile(Class<? extends LittleTile> LittleClass, String id) {
        tileIDs.put(LittleClass, id);
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt) {
        return LittleTile.CreateandLoadTile(te, world, nbt, false, null);
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt, boolean isPacket, NetworkManager net) {
        if (nbt.func_74764_b("tileID")) {
            if (nbt.func_74764_b("block")) {
                Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                LittleTileBox box = new LittleTileBox(new LittleTileVec("i", nbt), new LittleTileVec("a", nbt));
                box.addOffset(new LittleTileVec(8, 8, 8));
                LittleTileBlock tile = new LittleTileBlock(block, meta);
                tile.boundingBoxes.add(box);
                tile.cornerVec = box.getMinVec();
                return tile;
            }
        } else {
            String id = nbt.func_74779_i("tID");
            Class<? extends LittleTile> TileClass = LittleTile.getClassByID(id);
            LittleTile tile = null;
            if (TileClass != null) {
                try {
                    tile = TileClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("Found invalid tileID=" + id);
                }
            }
            if (tile != null) {
                if (isPacket) {
                    tile.receivePacket(nbt, net);
                } else {
                    try {
                        tile.loadTile(te, nbt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
            return tile;
        }
        return null;
    }

    public String getID() {
        return LittleTile.getIDByClass(this.getClass());
    }

    public AxisAlignedBB getSelectedBox() {
        if (this.boundingBoxes.size() > 0) {
            LittleTileBox box = this.boundingBoxes.get(0).copy();
            for (int i = 1; i < this.boundingBoxes.size(); ++i) {
                box.minX = (byte)Math.min(box.minX, this.boundingBoxes.get((int)i).minX);
                box.minY = (byte)Math.min(box.minY, this.boundingBoxes.get((int)i).minY);
                box.minZ = (byte)Math.min(box.minZ, this.boundingBoxes.get((int)i).minZ);
                box.maxX = (byte)Math.max(box.maxX, this.boundingBoxes.get((int)i).maxX);
                box.maxY = (byte)Math.max(box.maxY, this.boundingBoxes.get((int)i).maxY);
                box.maxZ = (byte)Math.max(box.maxZ, this.boundingBoxes.get((int)i).maxZ);
            }
            return box.getBox();
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public double getPercentVolume() {
        double percent = 0.0;
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            percent += (double)this.boundingBoxes.get(i).getSize().getPercentVolume();
        }
        return percent;
    }

    public LittleTileSize getSize() {
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            LittleTileSize tempSize = this.boundingBoxes.get(i).getSize();
            size.sizeX = (byte)Math.max(size.sizeX, tempSize.sizeX);
            size.sizeY = (byte)Math.max(size.sizeY, tempSize.sizeY);
            size.sizeZ = (byte)Math.max(size.sizeZ, tempSize.sizeZ);
        }
        return size;
    }

    public boolean canBeCombined(LittleTile tile) {
        if (this.isStructureBlock && this.isMainBlock) {
            return false;
        }
        if (this.isStructureBlock != tile.isStructureBlock) {
            return false;
        }
        return !this.isStructureBlock || this.structure == tile.structure;
    }

    public void combineTiles(LittleTile tile) {
        if (this.isLoaded()) {
            this.structure.getTiles().remove(tile);
        }
    }

    public void updatePacket(NBTTagCompound nbt) {
        nbt.func_74768_a("bSize", this.boundingBoxes.size());
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            this.boundingBoxes.get(i).writeToNBT("bBox" + i, nbt);
        }
    }

    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
        int count = nbt.func_74762_e("bSize");
        this.boundingBoxes.clear();
        for (int i = 0; i < count; ++i) {
            this.boundingBoxes.add(new LittleTileBox("bBox" + i, nbt));
        }
        this.updateCorner();
    }

    public void saveTile(NBTTagCompound nbt) {
        this.saveTileCore(nbt);
        this.saveTileExtra(nbt);
    }

    public abstract void saveTileExtra(NBTTagCompound var1);

    public void saveTileCore(NBTTagCompound nbt) {
        nbt.func_74778_a("tID", this.getID());
        if (this.cornerVec != null) {
            this.cornerVec.writeToNBT("cVec", nbt);
        }
        nbt.func_74768_a("bSize", this.boundingBoxes.size());
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            this.boundingBoxes.get(i).writeToNBT("bBox" + i, nbt);
        }
        if (this.isStructureBlock) {
            nbt.func_74757_a("isStructure", true);
            if (this.isMainBlock) {
                nbt.func_74757_a("main", true);
                this.structure.writeToNBT(nbt);
            } else {
                this.coord.writeToNBT(nbt);
            }
        }
    }

    public void loadTile(TileEntityLittleTiles te, NBTTagCompound nbt) {
        this.te = te;
        this.loadTileCore(nbt);
        this.loadTileExtra(nbt);
    }

    public abstract void loadTileExtra(NBTTagCompound var1);

    public void loadTileCore(NBTTagCompound nbt) {
        this.cornerVec = new LittleTileVec("cVec", nbt);
        int count = nbt.func_74762_e("bSize");
        this.boundingBoxes.clear();
        for (int i = 0; i < count; ++i) {
            this.boundingBoxes.add(new LittleTileBox("bBox" + i, nbt));
        }
        this.updateCorner();
        this.isStructureBlock = nbt.func_74767_n("isStructure");
        if (this.isStructureBlock) {
            if (nbt.func_74767_n("main")) {
                this.isMainBlock = true;
                this.structure = LittleStructure.createAndLoadStructure(nbt, this);
            } else if (nbt.func_74764_b("coX")) {
                LittleTilePosition pos = new LittleTilePosition(nbt);
                this.coord = new LittleTileCoord(this.te, pos.coord, pos.position);
                System.out.println("Converting old positioning to new relative coordinates " + pos + " to " + this.coord);
            } else {
                this.coord = new LittleTileCoord(nbt);
            }
        }
    }

    public void markForUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.te.update();
        } else {
            this.te.updateRender();
        }
    }

    public abstract ForgeDirection[] getValidRotation();

    public void onPlaced(EntityPlayer player, ItemStack stack) {
        this.onNeighborChangeInside();
    }

    public void updateCorner() {
        if (this.boundingBoxes.size() > 0) {
            LittleTileBox box = this.boundingBoxes.get(0);
            this.cornerVec = new LittleTileVec(box.minX, box.minY, box.minZ);
        } else {
            this.cornerVec = new LittleTileVec(0, 0, 0);
        }
    }

    public void place() {
        this.updateCorner();
        this.te.addTile(this);
    }

    public void onDestoryed() {
    }

    public void destroy() {
        if (this.isStructureBlock) {
            if (!this.te.func_145831_w().field_72995_K && this.isLoaded()) {
                this.structure.onLittleTileDestory();
            }
        } else {
            this.te.removeTile(this);
        }
    }

    public LittleTile copy() {
        LittleTile tile = null;
        try {
            tile = (LittleTile)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid LittleTile class=" + this.getClass().getName());
            tile = null;
        }
        if (tile != null) {
            this.copyCore(tile);
            this.copyExtra(tile);
        }
        return tile;
    }

    public void assign(LittleTile tile) {
        this.copyCore(tile);
        this.copyExtra(tile);
    }

    public abstract void copyExtra(LittleTile var1);

    public void copyCore(LittleTile tile) {
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            tile.boundingBoxes.add(this.boundingBoxes.get(i).copy());
        }
        tile.cornerVec = this.cornerVec.copy();
        tile.te = this.te;
        tile.structure = this.structure;
        if (this.coord != null) {
            tile.coord = this.coord.copy();
        }
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = null;
        if (this.isStructureBlock) {
            if (this.isLoaded()) {
                stack = this.structure.getStructureDrop();
            }
        } else {
            stack = this.getDrop();
        }
        if (stack != null) {
            drops.add(stack);
        }
        return drops;
    }

    public abstract ItemStack getDrop();

    public void onNeighborChangeOutside() {
        this.onNeighborChange();
    }

    public void onNeighborChangeInside() {
        this.onNeighborChange();
    }

    public void onNeighborChange() {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean canBlockBeThreaded();

    @SideOnly(value=Side.CLIENT)
    public abstract ArrayList<CubeObject> getRenderingCubes();

    @SideOnly(value=Side.CLIENT)
    public void renderTick(double x, double y, double z) {
    }

    public abstract Block.SoundType getSound();

    public void updateEntity() {
        ++this.ticks;
        if (this.ticks > 1200) {
            this.ticks = 0;
            if (this.isStructureBlock && this.isMainBlock && this.structure.tilesToLoad != null) {
                this.structure.loadTiles();
            }
        }
    }

    public abstract IIcon getIcon(int var1);

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float moveX, float moveY, float moveZ) {
        if (this.isLoaded()) {
            return this.structure.onBlockActivated(world, this, x, y, z, player, side, moveX, moveY, moveZ);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public double getEnchantPowerBonus(World world, int x, int y, int z) {
        return 0.0;
    }

    public boolean isLadder() {
        if (this.isLoaded()) {
            return this.structure.isLadder();
        }
        return false;
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        if (this.isLoaded()) {
            return this.structure.isBed(world, x, y, z, player);
        }
        return false;
    }

    public boolean checkForStructure() {
        if (this.structure != null) {
            return true;
        }
        World world = this.te.func_145831_w();
        ChunkCoordinates absoluteCoord = this.coord.getAbsolutePosition(this.te);
        Chunk chunk = world.func_72938_d(absoluteCoord.field_71574_a, absoluteCoord.field_71573_c);
        if (!(chunk instanceof EmptyChunk)) {
            LittleTile tile;
            TileEntity tileEntity = world.func_147438_o(absoluteCoord.field_71574_a, absoluteCoord.field_71572_b, absoluteCoord.field_71573_c);
            if (tileEntity instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)tileEntity).getTile(this.coord.position)) != null && tile.isStructureBlock && tile.isMainBlock) {
                this.structure = tile.structure;
                if (this.structure != null && this.structure.getTiles() != null && !this.structure.getTiles().contains(this)) {
                    this.structure.getTiles().add(this);
                }
            }
            if (this.structure == null) {
                this.te.removeTile(this);
                this.te.update();
            }
            return this.structure != null;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.isStructureBlock && this.checkForStructure();
    }

    @Deprecated
    public static class LittleTilePosition {
        public ChunkCoordinates coord;
        public LittleTileVec position;

        public LittleTilePosition(ChunkCoordinates coord, LittleTileVec position) {
            this.coord = coord;
            this.position = position;
        }

        public LittleTilePosition(String id, NBTTagCompound nbt) {
            this.coord = new ChunkCoordinates(nbt.func_74762_e(id + "coX"), nbt.func_74762_e(id + "coY"), nbt.func_74762_e(id + "coZ"));
            this.position = new LittleTileVec(id + "po", nbt);
        }

        public LittleTilePosition(NBTTagCompound nbt) {
            this("", nbt);
        }

        public void writeToNBT(String id, NBTTagCompound nbt) {
            nbt.func_74768_a(id + "coX", this.coord.field_71574_a);
            nbt.func_74768_a(id + "coY", this.coord.field_71572_b);
            nbt.func_74768_a(id + "coZ", this.coord.field_71573_c);
            this.position.writeToNBT(id + "po", nbt);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT("", nbt);
        }

        public String toString() {
            return "coord:" + this.coord + "|position:" + this.position;
        }

        public LittleTilePosition copy() {
            return new LittleTilePosition(new ChunkCoordinates(this.coord), this.position.copy());
        }
    }
}

