/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class LittleTileBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public LittleTileBox(LittleTileVec center, LittleTileSize size) {
        LittleTileVec offset = size.calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + size.sizeX;
        this.maxY = this.minY + size.sizeY;
        this.maxZ = this.minZ + size.sizeZ;
    }

    public LittleTileBox(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "minX"), nbt.func_74771_c(name + "minY"), nbt.func_74771_c(name + "minZ"), nbt.func_74771_c(name + "maxX"), nbt.func_74771_c(name + "maxY"), nbt.func_74771_c(name + "maxZ"));
            this.writeToNBT(name, nbt);
        } else {
            this.set(nbt.func_74762_e(name + "minX"), nbt.func_74762_e(name + "minY"), nbt.func_74762_e(name + "minZ"), nbt.func_74762_e(name + "maxX"), nbt.func_74762_e(name + "maxY"), nbt.func_74762_e(name + "maxZ"));
        }
    }

    public LittleTileBox(CubeObject cube) {
        this((int)(cube.minX * 16.0), (int)(cube.minY * 16.0), (int)(cube.minZ * 16.0), (int)(cube.maxX * 16.0), (int)(cube.maxY * 16.0), (int)(cube.maxZ * 16.0));
    }

    public LittleTileBox(AxisAlignedBB box) {
        this((int)(box.field_72340_a * 16.0), (int)(box.field_72338_b * 16.0), (int)(box.field_72339_c * 16.0), (int)(box.field_72336_d * 16.0), (int)(box.field_72337_e * 16.0), (int)(box.field_72334_f * 16.0));
    }

    public LittleTileBox(LittleTileVec min, LittleTileVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleTileBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AxisAlignedBB getBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.minX / 16.0), (double)((double)this.minY / 16.0), (double)((double)this.minZ / 16.0), (double)((double)this.maxX / 16.0), (double)((double)this.maxY / 16.0), (double)((double)this.maxZ / 16.0));
    }

    public CubeObject getCube() {
        return new CubeObject((double)this.minX / 16.0, (double)this.minY / 16.0, (double)this.minZ / 16.0, (double)this.maxX / 16.0, (double)this.maxY / 16.0, (double)this.maxZ / 16.0);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74768_a(name + "minX", this.minX);
        nbt.func_74768_a(name + "minY", this.minY);
        nbt.func_74768_a(name + "minZ", this.minZ);
        nbt.func_74768_a(name + "maxX", this.maxX);
        nbt.func_74768_a(name + "maxY", this.maxY);
        nbt.func_74768_a(name + "maxZ", this.maxZ);
    }

    public Vec3 getSizeD() {
        return Vec3.func_72443_a((double)((double)((this.maxX - this.minX) * 1) / 16.0), (double)((double)((this.maxY - this.minY) * 1) / 16.0), (double)((double)((this.maxZ - this.minZ) * 1) / 16.0));
    }

    public LittleTileSize getSize() {
        return new LittleTileSize(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public LittleTileBox copy() {
        return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean needsMultipleBlocks() {
        int x = this.minX / 16;
        int y = this.minY / 16;
        int z = this.minZ / 16;
        return this.maxX - x * 16 <= 16 && this.maxY - y * 16 <= 16 && this.maxZ - z * 16 <= 16;
    }

    public LittleTileBox combineBoxes(LittleTileBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleTileBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleTileBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleTileBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    public void addOffset(LittleTileVec vec) {
        this.minX += vec.x;
        this.minY += vec.y;
        this.minZ += vec.z;
        this.maxX += vec.x;
        this.maxY += vec.y;
        this.maxZ += vec.z;
    }

    public void subOffset(LittleTileVec vec) {
        this.minX -= vec.x;
        this.minY -= vec.y;
        this.minZ -= vec.z;
        this.maxX -= vec.x;
        this.maxY -= vec.y;
        this.maxZ -= vec.z;
    }

    public void assignCube(CubeObject cube) {
        this.minX = (int)(cube.minX * 16.0);
        this.minY = (int)(cube.minY * 16.0);
        this.minZ = (int)(cube.minZ * 16.0);
        this.maxX = (int)(cube.maxX * 16.0);
        this.maxY = (int)(cube.maxY * 16.0);
        this.maxZ = (int)(cube.maxZ * 16.0);
    }

    public LittleTileVec getMinVec() {
        return new LittleTileVec(this.minX, this.minY, this.minZ);
    }

    public LittleTileVec getMaxVec() {
        return new LittleTileVec(this.maxX, this.maxY, this.maxZ);
    }

    public void rotateBoxWithCenter(Rotation direction, Vec3 center) {
        CubeObject cube = this.getCube();
        cube = CubeObject.rotateCube((CubeObject)cube, (Rotation)direction, (Vec3)center);
        this.minX = (int)(cube.minX * 16.0);
        this.minY = (int)(cube.minY * 16.0);
        this.minZ = (int)(cube.minZ * 16.0);
        this.maxX = (int)(cube.maxX * 16.0);
        this.maxY = (int)(cube.maxY * 16.0);
        this.maxZ = (int)(cube.maxZ * 16.0);
    }

    public void flipBox(ForgeDirection direction) {
        switch (direction) {
            case EAST: 
            case WEST: {
                this.minX = -this.minX;
                this.maxX = -this.maxX;
                break;
            }
            case UP: 
            case DOWN: {
                this.minY = -this.minY;
                this.maxY = -this.maxY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.minZ = -this.minZ;
                this.maxZ = -this.maxZ;
                break;
            }
        }
        this.resort();
    }

    public void flipBoxWithCenter(ForgeDirection direction, LittleTileVec center) {
        if (center == null) {
            center = new LittleTileVec(8, 8, 8);
        }
        this.subOffset(center);
        this.flipBox(direction);
        this.addOffset(center);
    }

    public void rotateBox(ForgeDirection direction) {
        CubeObject cube = this.getCube();
        cube = CubeObject.rotateCube((CubeObject)cube, (ForgeDirection)direction);
        this.assignCube(cube);
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileBox) {
            return this.minX == ((LittleTileBox)object).minX && this.minY == ((LittleTileBox)object).minY && this.minZ == ((LittleTileBox)object).minZ && this.maxX == ((LittleTileBox)object).maxX && this.maxY == ((LittleTileBox)object).maxY && this.maxZ == ((LittleTileBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleTileVec getNearstedPointTo(LittleTileVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleTileVec(x, y, z);
    }

    public LittleTileVec getNearstedPointTo(LittleTileBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleTileVec(x, y, z);
    }

    public double distanceTo(LittleTileBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleTileVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean isBoxInside(LittleTileBox box) {
        if (this.minX > box.maxX || box.minX > this.minX) {
            return false;
        }
        if (this.minY > box.maxY || box.minY > this.minY) {
            return false;
        }
        return this.minZ <= box.maxZ && box.minZ <= this.minZ;
    }

    public boolean intersectsWith(LittleTileBox box) {
        return box.maxX > this.minX && box.minX < this.maxX ? (box.maxY > this.minY && box.minY < this.maxY ? box.maxZ > this.minZ && box.minZ < this.maxZ : false) : false;
    }

    public ForgeDirection faceTo(LittleTileBox box) {
        boolean z;
        boolean x = this.minX < box.maxX && box.minX < this.maxX;
        boolean y = this.minY < box.maxY && box.minY < this.maxY;
        boolean bl = z = this.minZ < box.maxZ && box.minZ < this.maxZ;
        if (x && y && z) {
            return ForgeDirection.UNKNOWN;
        }
        if (x && y) {
            if (this.minZ > box.maxZ) {
                return ForgeDirection.NORTH;
            }
            return ForgeDirection.SOUTH;
        }
        if (x && z) {
            if (this.minY > box.maxY) {
                return ForgeDirection.DOWN;
            }
            return ForgeDirection.UP;
        }
        if (y && z) {
            if (this.minX > box.maxX) {
                return ForgeDirection.WEST;
            }
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    public boolean hasTwoSideIntersection(LittleTileBox box) {
        boolean z;
        boolean x = this.minX <= box.maxX && box.minX <= this.minX;
        boolean y = this.minY <= box.maxY && box.minY <= this.minY;
        boolean bl = z = this.minZ <= box.maxZ && box.minZ <= this.minZ;
        if (x && y && z) {
            return false;
        }
        return x && y || x && z || y && z;
    }

    public boolean isParallel(LittleTileBox box) {
        return true;
    }

    public boolean isBoxInsideBlock() {
        return this.minX >= 0 && this.maxX <= 16 && this.minY >= 0 && this.maxY <= 16 && this.minZ >= 0 && this.maxZ <= 16;
    }

    public LittleTileBox expand(ForgeDirection direction) {
        LittleTileBox result = this.copy();
        switch (direction) {
            case EAST: {
                ++result.maxX;
                break;
            }
            case WEST: {
                --result.minX;
                break;
            }
            case UP: {
                ++result.maxY;
                break;
            }
            case DOWN: {
                --result.minY;
                break;
            }
            case SOUTH: {
                ++result.maxZ;
                break;
            }
            case NORTH: {
                --result.minZ;
                break;
            }
        }
        return result;
    }

    public LittleTileBox shrink(ForgeDirection direction) {
        LittleTileBox result = this.copy();
        switch (direction) {
            case EAST: {
                --result.maxX;
                break;
            }
            case WEST: {
                ++result.minX;
                break;
            }
            case UP: {
                --result.maxY;
                break;
            }
            case DOWN: {
                ++result.minY;
                break;
            }
            case SOUTH: {
                --result.maxZ;
                break;
            }
            case NORTH: {
                ++result.minZ;
                break;
            }
        }
        return result;
    }

    public void applyDirection(ForgeDirection direction) {
        switch (direction) {
            case EAST: {
                this.minX += 16;
                this.maxX += 16;
                break;
            }
            case WEST: {
                this.minX -= 16;
                this.maxX -= 16;
                break;
            }
            case UP: {
                this.minY += 16;
                this.maxY += 16;
                break;
            }
            case DOWN: {
                this.minY -= 16;
                this.maxY -= 16;
                break;
            }
            case SOUTH: {
                this.minZ += 16;
                this.maxZ += 16;
                break;
            }
            case NORTH: {
                this.minZ -= 16;
                this.maxZ -= 16;
                break;
            }
        }
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }
}

