/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles;

import com.creativemd.creativecore.transformer.CreativeTransformer;
import com.creativemd.creativecore.transformer.Transformer;
import com.creativemd.creativecore.transformer.TransformerNames;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LittleTilesTransformer
extends CreativeTransformer {
    public LittleTilesTransformer() {
        super("littletiles");
    }

    protected void initTransformers() {
        this.addTransformer(new Transformer("net.minecraft.client.renderer.RenderGlobal"){

            public void transform(ClassNode classNode) {
                MethodNode m = this.findMethod(classNode, "loadRenderers", "()V");
                String className = this.patchClassName("net/minecraft/client/renderer/chunk/ChunkRenderDispatcher");
                boolean isNextLabel = false;
                for (AbstractInsnNode node : m.instructions) {
                    if (isNextLabel && node instanceof LabelNode) {
                        m.instructions.insert(node, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "onReloadRenderers", this.patchDESC("(Lnet/minecraft/client/renderer/RenderGlobal;)V"), false));
                        m.instructions.insert(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                        isNextLabel = false;
                    }
                    if (node instanceof TypeInsnNode && ((TypeInsnNode)node).getOpcode() == 187 && ((TypeInsnNode)node).desc.equals(className)) {
                        ((TypeInsnNode)node).desc = "com/creativemd/littletiles/client/render/LittleChunkDispatcher";
                    }
                    if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).name.equals("<init>") || !((MethodInsnNode)node).desc.equals("()V") || !((MethodInsnNode)node).owner.equals(className)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    method.owner = "com/creativemd/littletiles/client/render/LittleChunkDispatcher";
                    isNextLabel = true;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.player.EntityPlayer"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleBed", "Lcom/creativemd/littletiles/common/structure/LittleStructure;", null, null));
                MethodNode m = this.findMethod(node, "getBedOrientationInDegrees", "()F");
                if (m != null) {
                    m.instructions.clear();
                    m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/LittleBed", "getBedOrientationInDegrees", this.patchDESC("(Lnet/minecraft/entity/player/EntityPlayer;)F"), false));
                    m.instructions.add((AbstractInsnNode)new InsnNode(174));
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.client.ForgeHooksClient"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "orientBedCamera", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V");
                ListIterator iterator = m.instructions.iterator();
                boolean nextLabel = false;
                while (iterator.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (nextLabel && insn instanceof LabelNode) {
                        m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/LittleBed", "setBedDirection", this.patchDESC("(Lnet/minecraft/entity/Entity;)V"), false));
                        m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        break;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.patchDESC("org/lwjgl/opengl/GL11")) || !((MethodInsnNode)insn).name.equals(this.patchFieldName("glRotatef"))) continue;
                    nextLabel = true;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.chunk.RenderChunk"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleTiles", this.patchDESC("Ljava/util/List;"), this.patchDESC("Ljava/util/List<Lcom/creativemd/littletiles/common/tileentity/TileEntityLittleTiles;>;"), null));
                node.fields.add(new FieldNode(1, "tempLittleTiles", this.patchDESC("Ljava/util/List;"), this.patchDESC("Ljava/util/List<Lcom/creativemd/littletiles/common/tileentity/TileEntityLittleTiles;>;"), null));
                String ownerBefore = this.patchClassName("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher");
                String nameBefore = TransformerNames.patchFieldName((String)"instance", (String)ownerBefore);
                String ownerAfter = this.patchClassName("net/minecraft/client/renderer/chunk/VisGraph");
                String descAfter = this.patchDESC("()Lnet/minecraft/client/renderer/chunk/SetVisibility;");
                String nameAfter = TransformerNames.patchMethodName((String)"computeVisibility", (String)descAfter, (String)ownerAfter);
                MethodNode m = this.findMethod(node, "rebuildChunk", "(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V");
                m.localVariables.add(new LocalVariableNode("tiles", this.patchDESC("Ljava/util/List;"), this.patchDESC("Ljava/util/List<Lcom/creativemd/littletiles/common/tileentity/TileEntityLittleTiles;>;"), (LabelNode)m.instructions.getFirst(), (LabelNode)m.instructions.getLast(), 40));
                m.instructions.insert(m.instructions.getFirst(), (AbstractInsnNode)new VarInsnNode(58, 40));
                m.instructions.insert(m.instructions.getFirst(), (AbstractInsnNode)new MethodInsnNode(183, this.patchDESC("java/util/ArrayList"), "<init>", "()V", false));
                m.instructions.insert(m.instructions.getFirst(), (AbstractInsnNode)new InsnNode(89));
                m.instructions.insert(m.instructions.getFirst(), (AbstractInsnNode)new TypeInsnNode(187, this.patchDESC("java/util/ArrayList")));
                for (AbstractInsnNode insn : m.instructions) {
                    if (insn instanceof FieldInsnNode && ((FieldInsnNode)insn).owner.equals(ownerBefore) && ((FieldInsnNode)insn).name.equals(nameBefore)) {
                        m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 40));
                        int index = 17;
                        String varDesc = this.patchDESC("Lnet/minecraft/tileentity/TileEntity;");
                        for (LocalVariableNode local : m.localVariables) {
                            if (!local.desc.equals(varDesc)) continue;
                            index = local.index;
                        }
                        m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, index));
                        m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "addTileEntity", this.patchDESC("(Ljava/util/List;Lnet/minecraft/tileentity/TileEntity;)V"), false));
                        continue;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).desc.equals(descAfter) || !((MethodInsnNode)insn).owner.equals(ownerAfter) || !((MethodInsnNode)insn).name.equals(nameAfter)) continue;
                    AbstractInsnNode before = insn.getPrevious().getPrevious();
                    m.instructions.insertBefore(before, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(before, (AbstractInsnNode)new VarInsnNode(25, 40));
                    m.instructions.insertBefore(before, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "onDoneRendering", this.patchDESC("(Lnet/minecraft/client/renderer/chunk/RenderChunk;Ljava/util/List;)V"), false));
                }
            }
        });
    }
}

