/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.LightChangeEventListener;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LittleChunkDispatcher
extends ChunkRenderDispatcher {
    public static AtomicInteger currentRenderIndex = new AtomicInteger(0);
    private static Method growBuffer = ReflectionHelper.findMethod(VertexBuffer.class, null, (String[])new String[]{"growBuffer", "func_181670_b"}, (Class[])new Class[]{Integer.TYPE});
    private static Field rawIntBufferField = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"rawIntBuffer", "field_178999_b"});
    private static Field vertexCountField = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"vertexCount", "field_178997_d"});
    private static Method setLayerUseMethod = ReflectionHelper.findMethod(CompiledChunk.class, null, (String[])new String[]{"setLayerUsed", "func_178486_a"}, (Class[])new Class[]{BlockRenderLayer.class});
    private static Field setTileEntities = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"setTileEntities", "field_181056_j"});
    private static Field littleTiles = ReflectionHelper.findField(RenderChunk.class, (String[])new String[]{"littleTiles"});
    private static Minecraft mc = Minecraft.func_71410_x();

    public static void onReloadRenderers(RenderGlobal renderGlobal) {
        if (LittleChunkDispatcher.mc.field_71438_f == renderGlobal) {
            currentRenderIndex.incrementAndGet();
            LittleChunkDispatcher.mc.field_71441_e.func_72954_a((IWorldEventListener)new LightChangeEventListener());
        }
    }

    public static void addTileEntity(List<TileEntityLittleTiles> tiles, TileEntity te) {
        if (te instanceof TileEntityLittleTiles) {
            tiles.add((TileEntityLittleTiles)te);
        }
    }

    public static void onDoneRendering(RenderChunk chunk, List<TileEntityLittleTiles> tiles) {
        try {
            littleTiles.set(chunk, tiles);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static List<TileEntityLittleTiles> getLittleTE(RenderChunk chunk) {
        try {
            return (List)littleTiles.get(chunk);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ListenableFuture<Object> func_188245_a(BlockRenderLayer layer, VertexBuffer buffer, RenderChunk chunk, CompiledChunk compiled, double p_188245_5_) {
        VertexBuffer teBuffer;
        BlockLayerRenderBuffer blockLayerBuffer;
        List<TileEntityLittleTiles> tiles = LittleChunkDispatcher.getLittleTE(chunk);
        if (tiles == null) {
            tiles = new ArrayList<TileEntityLittleTiles>();
        }
        int bufferExpand = 0;
        for (TileEntityLittleTiles te : tiles) {
            if (layer == BlockRenderLayer.SOLID) {
                te.updateQuadCache(chunk);
            }
            if ((blockLayerBuffer = te.getBuffer()) == null || (teBuffer = blockLayerBuffer.getBufferByLayer(layer)) == null || layer == BlockRenderLayer.TRANSLUCENT && te.getBeenAddedToBuffer().get()) continue;
            bufferExpand += teBuffer.func_178966_f().limit();
            if (layer != BlockRenderLayer.TRANSLUCENT) continue;
            te.getBeenAddedToBuffer().set(true);
        }
        if (bufferExpand > 0) {
            if (compiled.func_178491_b(layer)) {
                try {
                    if (compiled != CompiledChunk.field_178502_a) {
                        setLayerUseMethod.invoke((Object)compiled, layer);
                    }
                    if (chunk.func_178571_g() != CompiledChunk.field_178502_a) {
                        setLayerUseMethod.invoke((Object)chunk.func_178571_g(), layer);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            if (buffer.func_178973_g() != null && !(compiled.func_178487_c() instanceof LittleVertexBufferState)) {
                for (TileEntityLittleTiles te : tiles) {
                    blockLayerBuffer = te.getBuffer();
                    if (blockLayerBuffer == null || (teBuffer = blockLayerBuffer.getBufferByLayer(layer)) == null) continue;
                    int size = teBuffer.func_178973_g().func_181719_f() * teBuffer.func_178989_h();
                    try {
                        IntBuffer rawIntBuffer = (IntBuffer)rawIntBufferField.get(teBuffer);
                        rawIntBuffer.rewind();
                        rawIntBuffer.limit(size);
                        int[] data = new int[size];
                        rawIntBuffer.get(data);
                        growBuffer.invoke((Object)buffer, data.length * 4);
                        IntBuffer chunkIntBuffer = (IntBuffer)rawIntBufferField.get(buffer);
                        chunkIntBuffer.position(buffer.func_178973_g().func_181719_f() * buffer.func_178989_h());
                        chunkIntBuffer.put(data);
                        vertexCountField.setInt(buffer, vertexCountField.getInt(buffer) + data.length / buffer.func_178973_g().func_181719_f());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (layer == BlockRenderLayer.TRANSLUCENT) {
                    Entity entity = mc.func_175606_aa();
                    float x = (float)entity.field_70165_t;
                    float y = (float)entity.field_70163_u + entity.func_70047_e();
                    float z = (float)entity.field_70161_v;
                    buffer.func_181674_a(x, y, z);
                    compiled.func_178494_a((VertexBuffer.State)new LittleVertexBufferState(buffer, buffer.func_181672_a()));
                }
                buffer.func_178966_f().position(0);
                buffer.func_178966_f().limit(buffer.func_178973_g().func_181719_f() * buffer.func_178989_h() * 4);
            }
        }
        return super.func_188245_a(layer, buffer, chunk, compiled, p_188245_5_);
    }

    public static class LittleVertexBufferState
    extends VertexBuffer.State {
        public LittleVertexBufferState(VertexBuffer buffer, VertexBuffer.State state) {
            VertexBuffer vertexBuffer = buffer;
            vertexBuffer.getClass();
            super(vertexBuffer, state.func_179013_a(), state.func_179016_d());
        }
    }
}

