/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class RenderUploader {
    private static ConcurrentHashMap<BlockPos, ChunkQueue> chunksToUpdate = new ConcurrentHashMap();
    private static Field viewFrustumField;
    private static Field vertexCountField;
    private static Field bufferIdField;
    private static Minecraft mc;
    private static Field arbVboField;
    private static Field countChunksXField;
    private static Field countChunksYField;
    private static Field countChunksZField;

    public static ViewFrustum getViewFrustum() {
        if (viewFrustumField == null) {
            viewFrustumField = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"viewFrustum", "field_175008_n"});
        }
        try {
            return (ViewFrustum)viewFrustumField.get(RenderUploader.mc.field_71438_f);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBlockForUpdate(TileEntityLittleTiles te, BlockPos chunkPos, boolean done) {
        ConcurrentHashMap<BlockPos, ChunkQueue> concurrentHashMap = chunksToUpdate;
        synchronized (concurrentHashMap) {
            ChunkQueue queue = chunksToUpdate.get(chunkPos);
            if (queue == null) {
                queue = new ChunkQueue();
                queue.shouldPushUpdate.set(done);
                chunksToUpdate.put(chunkPos, queue);
            } else if (!queue.shouldPushUpdate.get()) {
                queue.shouldPushUpdate.set(false);
            }
            ConcurrentLinkedQueue<TileEntityLittleTiles> concurrentLinkedQueue = queue.blocks;
            synchronized (concurrentLinkedQueue) {
                if (!queue.blocks.contains((Object)te)) {
                    queue.blocks.add(te);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishChunkUpdate(BlockPos pos) {
        ConcurrentHashMap<BlockPos, ChunkQueue> concurrentHashMap = chunksToUpdate;
        synchronized (concurrentHashMap) {
            ChunkQueue queue = chunksToUpdate.get(pos);
            if (queue != null) {
                queue.shouldPushUpdate.set(true);
            }
        }
    }

    public static void updateRenderData(RenderChunk chunk, Collection<TileEntityLittleTiles> tiles, VertexFormat format) {
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            BlockRenderLayer layer = BlockRenderLayer.values()[i];
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            int bufferSize = 0;
            for (TileEntityLittleTiles te : tiles) {
                VertexBuffer tempBuffer = te.getBuffer().getBufferByLayer(layer);
                if (tempBuffer == null) continue;
                buffers.add(tempBuffer.func_178966_f());
                bufferSize += tempBuffer.func_178966_f().limit();
            }
            if (buffers.isEmpty()) continue;
            net.minecraft.client.renderer.vertex.VertexBuffer layerBuffer = chunk.func_178565_b(i);
            int bufferId = -1;
            try {
                bufferId = bufferIdField.getInt(layerBuffer);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            int vertexCount = 0;
            try {
                vertexCount = vertexCountField.getInt(layerBuffer);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            layerBuffer.func_177359_a();
            ByteBuffer vanillaBuffer = RenderUploader.glMapBufferRange(OpenGlHelper.field_176089_P, vertexCount * format.func_177338_f(), 1, null);
            ByteBuffer overridenBuffer = null;
            if (vanillaBuffer != null) {
                overridenBuffer = ByteBuffer.allocateDirect(vanillaBuffer.limit() + bufferSize);
                overridenBuffer.put(vanillaBuffer);
                for (int j = 0; j < buffers.size(); ++j) {
                    ((ByteBuffer)buffers.get(j)).position(0);
                    overridenBuffer.put((ByteBuffer)buffers.get(j));
                }
            }
            layerBuffer.func_177361_b();
            if (vanillaBuffer == null) continue;
            vanillaBuffer = null;
            layerBuffer.func_177362_c();
            try {
                bufferIdField.setInt(layerBuffer, OpenGlHelper.func_176073_e());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            overridenBuffer.position(0);
            layerBuffer.func_181722_a(overridenBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.phase == TickEvent.Phase.END) {
            WorldClient world = RenderUploader.mc.field_71441_e;
            VertexFormat format = LittleTilesClient.getBlockVertexFormat();
            if (world != null) {
                ConcurrentHashMap<BlockPos, ChunkQueue> concurrentHashMap = chunksToUpdate;
                synchronized (concurrentHashMap) {
                    if (!chunksToUpdate.isEmpty()) {
                        ArrayList<BlockPos> deleted = new ArrayList<BlockPos>();
                        for (Map.Entry<BlockPos, ChunkQueue> element : chunksToUpdate.entrySet()) {
                            if (!element.getValue().shouldPushUpdate.get()) continue;
                            ConcurrentLinkedQueue<TileEntityLittleTiles> concurrentLinkedQueue = element.getValue().blocks;
                            synchronized (concurrentLinkedQueue) {
                                RenderUploader.updateRenderData(RenderUploader.getRenderChunkByChunkPosition(RenderUploader.getViewFrustum(), element.getKey()), element.getValue().blocks, format);
                                deleted.add(element.getKey());
                            }
                        }
                        if (!deleted.isEmpty()) {
                            for (int i = 0; i < deleted.size(); ++i) {
                                chunksToUpdate.remove(deleted.get(i));
                            }
                        }
                    }
                }
            } else if (world == null) {
                chunksToUpdate.clear();
            }
        }
    }

    public static ByteBuffer glMapBufferRange(int target, long length, int access, ByteBuffer old_buffer) {
        try {
            if (arbVboField.getBoolean(null)) {
                return ARBVertexBufferObject.glMapBufferARB((int)target, (int)access, (long)length, (ByteBuffer)old_buffer);
            }
            return GL30.glMapBufferRange((int)target, (long)0L, (long)length, (int)access, (ByteBuffer)old_buffer);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BlockPos getRenderChunkPos(BlockPos pos) {
        int i = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        int j = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
        int k = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
        return new BlockPos(i, j, k);
    }

    public static RenderChunk getRenderChunkByChunkPosition(ViewFrustum frustum, BlockPos chunkPos) {
        int i = chunkPos.func_177958_n();
        int j = chunkPos.func_177956_o();
        int k = chunkPos.func_177952_p();
        int countChunksX = 0;
        try {
            countChunksX = countChunksXField.getInt(frustum);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        int countChunksY = 0;
        try {
            countChunksY = countChunksYField.getInt(frustum);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        int countChunksZ = 0;
        try {
            countChunksZ = countChunksZField.getInt(frustum);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (j >= 0 && j < countChunksY) {
            if ((i %= countChunksX) < 0) {
                i += countChunksX;
            }
            if ((k %= countChunksZ) < 0) {
                k += countChunksZ;
            }
            int l = (k * countChunksY + j) * countChunksX + i;
            return frustum.field_178164_f[l];
        }
        return null;
    }

    static {
        vertexCountField = ReflectionHelper.findField(net.minecraft.client.renderer.vertex.VertexBuffer.class, (String[])new String[]{"count", "field_177364_c"});
        bufferIdField = ReflectionHelper.findField(net.minecraft.client.renderer.vertex.VertexBuffer.class, (String[])new String[]{"glBufferId", "field_177365_a"});
        mc = Minecraft.func_71410_x();
        arbVboField = ReflectionHelper.findField(OpenGlHelper.class, (String[])new String[]{"arbVbo", "field_176090_Y"});
        countChunksXField = ReflectionHelper.findField(ViewFrustum.class, (String[])new String[]{"countChunksX", "field_178165_d"});
        countChunksYField = ReflectionHelper.findField(ViewFrustum.class, (String[])new String[]{"countChunksY", "field_178168_c"});
        countChunksZField = ReflectionHelper.findField(ViewFrustum.class, (String[])new String[]{"countChunksZ", "field_178166_e"});
    }

    public static class ChunkQueue {
        public ConcurrentLinkedQueue<TileEntityLittleTiles> blocks = new ConcurrentLinkedQueue();
        public AtomicBoolean shouldPushUpdate = new AtomicBoolean(false);
    }
}

