/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.entity;

import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.entity.TERenderData;
import com.creativemd.littletiles.client.render.optifine.OptifineVertexBuffer;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;
import shadersmod.client.ShadersRender;

public class RenderAnimation
extends Render<EntityAnimation> {
    public static final VertexBufferUploader uploader = new VertexBufferUploader();

    public RenderAnimation(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityAnimation entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        if (entity.renderData == null) {
            entity.createClient();
        }
        if (entity.renderQueue == null) {
            return;
        }
        ArrayList<TileEntityLittleTiles> TEtoRemove = new ArrayList<TileEntityLittleTiles>();
        for (TileEntityLittleTiles te : entity.renderQueue) {
            BlockLayerRenderBuffer layers;
            if (te.rendering.get() || (layers = te.getBuffer()) == null) continue;
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                BlockRenderLayer layer = BlockRenderLayer.values()[i];
                VertexBuffer tempBuffer = layers.getBufferByLayer(layer);
                if (tempBuffer == null) continue;
                net.minecraft.client.renderer.vertex.VertexBuffer bufferToCreate = new net.minecraft.client.renderer.vertex.VertexBuffer(LittleTilesClient.getBlockVertexFormat());
                uploader.func_178178_a(bufferToCreate);
                uploader.func_181679_a(tempBuffer);
                entity.renderData.add((Object)layer, (Object)new TERenderData(bufferToCreate, EntityAnimation.getRenderChunkPos(te.func_174877_v()), te.func_174877_v()));
            }
            TEtoRemove.add(te);
        }
        entity.renderQueue.removeAll(TEtoRemove);
        Vec3d rotation = entity.getRotVector(partialTicks);
        this.func_110776_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
        for (BlockRenderLayer layer : entity.renderData.getKeys()) {
            if (FMLClientHandler.instance().hasOptifine() && OptifineVertexBuffer.isShaders()) {
                ShadersRender.preRenderChunkLayer((BlockRenderLayer)layer);
            }
            ArrayList blocksToRender = entity.renderData.getValues((Object)layer);
            for (int i = 0; i < blocksToRender.size(); ++i) {
                TERenderData data = (TERenderData)blocksToRender.get(i);
                GlStateManager.func_179094_E();
                double posX = (data.chunkPos.func_177958_n() - entity.getAxisChunkPos().func_177958_n()) * 16 - entity.getInsideChunkPos().func_177958_n();
                double posY = (data.chunkPos.func_177956_o() - entity.getAxisChunkPos().func_177956_o()) * 16 - entity.getInsideChunkPos().func_177956_o();
                double posZ = (data.chunkPos.func_177952_p() - entity.getAxisChunkPos().func_177952_p()) * 16 - entity.getInsideChunkPos().func_177952_p();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179137_b((double)(entity.getInsideBlockAxis().getPosX() + LittleTile.gridMCLength / 2.0), (double)(entity.getInsideBlockAxis().getPosY() + LittleTile.gridMCLength / 2.0), (double)(entity.getInsideBlockAxis().getPosZ() + LittleTile.gridMCLength / 2.0));
                GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
                GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
                GlStateManager.func_179137_b((double)(-entity.getInsideBlockAxis().getPosX() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosY() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosZ() - LittleTile.gridMCLength / 2.0));
                if (layer == BlockRenderLayer.TRANSLUCENT) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179118_c();
                } else {
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179141_d();
                }
                data.buffer.func_177359_a();
                if (FMLClientHandler.instance().hasOptifine() && OptifineVertexBuffer.isShaders()) {
                    ShadersRender.setupArrayPointersVbo();
                } else {
                    GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
                    GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
                    GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                    GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                }
                data.buffer.func_177358_a(7);
                data.buffer.func_177361_b();
                GlStateManager.func_179121_F();
            }
            if (!FMLClientHandler.instance().hasOptifine() || !OptifineVertexBuffer.isShaders()) continue;
            ShadersRender.postRenderChunkLayer((BlockRenderLayer)layer);
        }
        for (VertexFormatElement vertexformatelement : LittleTilesClient.getBlockVertexFormat().func_177343_g()) {
            VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
            int i1 = vertexformatelement.func_177369_e();
            switch (vertexformatelement$enumusage) {
                case POSITION: {
                    GlStateManager.func_187429_p((int)32884);
                    break;
                }
                case UV: {
                    OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + i1));
                    GlStateManager.func_187429_p((int)32888);
                    OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                    break;
                }
                case COLOR: {
                    GlStateManager.func_187429_p((int)32886);
                    GlStateManager.func_179117_G();
                }
            }
        }
        GlStateManager.func_179091_B();
        if (!entity.isWaitingForRender()) {
            for (TileEntityLittleTiles te : entity.blocks) {
                if (!te.shouldRenderInPass(0)) continue;
                GlStateManager.func_179094_E();
                BlockPos blockpos = te.func_174877_v();
                BlockPos newpos = te.func_174877_v().func_177973_b((Vec3i)entity.getAxisPos());
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179137_b((double)(entity.getInsideBlockAxis().getPosX() + LittleTile.gridMCLength / 2.0), (double)(entity.getInsideBlockAxis().getPosY() + LittleTile.gridMCLength / 2.0), (double)(entity.getInsideBlockAxis().getPosZ() + LittleTile.gridMCLength / 2.0));
                GL11.glRotated((double)rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
                GlStateManager.func_179137_b((double)(-((double)blockpos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b) + (double)newpos.func_177958_n()), (double)(-((double)blockpos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c) + (double)newpos.func_177956_o()), (double)(-((double)blockpos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d) + (double)newpos.func_177952_p()));
                GlStateManager.func_179137_b((double)(-entity.getInsideBlockAxis().getPosX() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosY() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosZ() - LittleTile.gridMCLength / 2.0));
                TileEntityRendererDispatcher.field_147556_a.func_180546_a((TileEntity)te, partialTicks, -1);
                GlStateManager.func_179137_b((double)(-entity.getInsideBlockAxis().getPosX() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosY() - LittleTile.gridMCLength / 2.0), (double)(-entity.getInsideBlockAxis().getPosZ() - LittleTile.gridMCLength / 2.0));
                GlStateManager.func_179121_F();
            }
        }
        RenderHelper.func_74519_b();
    }

    protected ResourceLocation getEntityTexture(EntityAnimation entity) {
        return TextureMap.field_110575_b;
    }
}

