/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api.blocks;

import com.creativemd.littletiles.common.utils.LittleTileBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public abstract class SpecialBlockHandler {
    private static int layers = 0;
    public static HashMap<BlockSelector, SpecialBlockHandler> specialHandlers = new HashMap();

    public static SpecialBlockHandler getSpecialBlockHandler(Block block, int meta) {
        SpecialBlockHandler[] specialLayers = new SpecialBlockHandler[layers];
        for (Map.Entry<BlockSelector, SpecialBlockHandler> entry : specialHandlers.entrySet()) {
            if (!entry.getKey().isBlock(block, meta)) continue;
            if (entry.getKey().getLayer() < layers) {
                specialLayers[entry.getKey().getLayer()] = entry.getValue();
                continue;
            }
            return entry.getValue();
        }
        for (int i = specialLayers.length - 1; i >= 0; --i) {
            if (specialLayers[i] == null) continue;
            return specialLayers[i];
        }
        return null;
    }

    public static void registerSpecialHandler(Class<? extends Block> clazz, SpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler(new BlockSelectorClass(clazz), handler);
    }

    public static void registerSpecialHandler(Block block, int meta, SpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler(new BlockSelectorAdvanced(block, meta), handler);
    }

    public static void registerSpecialHandler(Block block, SpecialBlockHandler handler) {
        SpecialBlockHandler.registerSpecialHandler(new BlockSelectorBasic(block), handler);
    }

    public static void registerSpecialHandler(BlockSelector selector, SpecialBlockHandler handler) {
        layers = Math.max(layers, selector.getLayer());
        specialHandlers.put(selector, handler);
    }

    public boolean onBlockActivated(LittleTileBlock tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onTileExplodes(LittleTileBlock tile, Explosion explosion) {
    }

    public void randomDisplayTick(LittleTileBlock tile, IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public static class BlockSelectorAdvanced
    extends BlockSelectorBasic {
        public final int meta;

        public BlockSelectorAdvanced(Block block, int meta) {
            super(block);
            this.meta = meta;
        }

        @Override
        public boolean isBlock(Block block, int meta) {
            return super.isBlock(block, meta) && this.meta == meta;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof BlockSelectorAdvanced) {
                return super.equals(object) && ((BlockSelectorAdvanced)object).meta == this.meta;
            }
            return false;
        }

        @Override
        public int getLayer() {
            return 3;
        }
    }

    public static class BlockSelectorBasic
    extends BlockSelector {
        public final Block block;

        public BlockSelectorBasic(Block block) {
            this.block = block;
        }

        @Override
        public boolean isBlock(Block block, int meta) {
            return this.block == block;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof BlockSelectorBasic) {
                return ((BlockSelectorBasic)object).block == this.block;
            }
            return false;
        }

        @Override
        public int getLayer() {
            return 2;
        }
    }

    public static class BlockSelectorClass
    extends BlockSelector {
        public final Class<? extends Block> clazz;

        public BlockSelectorClass(Class<? extends Block> clazz) {
            this.clazz = clazz;
        }

        @Override
        public boolean isBlock(Block block, int meta) {
            return this.clazz.isInstance(block);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof BlockSelectorClass) {
                return ((BlockSelectorClass)object).clazz == this.clazz;
            }
            return false;
        }

        @Override
        public int getLayer() {
            return 1;
        }
    }

    public static abstract class BlockSelector {
        public abstract boolean isBlock(Block var1, int var2);

        public abstract boolean equals(Object var1);

        public abstract int getLayer();
    }
}

