/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.creativecore.common.world.WorldFake;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.client.render.entity.TERenderData;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimation
extends Entity {
    private static final DataParameter<Integer> ENTITY_PROGRESS = EntityDataManager.func_187226_a(EntityAnimation.class, (DataSerializer)DataSerializers.field_187192_b);
    public LittleDoorBase structure;
    public ArrayList<PlacePreviewTile> previews;
    public ArrayList<TileEntityLittleTiles> blocks;
    @SideOnly(value=Side.CLIENT)
    public HashMapList<BlockRenderLayer, TERenderData> renderData;
    @SideOnly(value=Side.CLIENT)
    public ArrayList<TileEntityLittleTiles> renderQueue;
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB renderBoundingBox;
    @SideOnly(value=Side.CLIENT)
    protected ArrayList<TileEntityLittleTiles> waitingForRender;
    @SideOnly(value=Side.CLIENT)
    protected int ticksToWait;
    public EntityPlayer activator;
    private LittleTileVec axis;
    private LittleTileVec inBlockAxis;
    private BlockPos baseOffset;
    private BlockPos chunkOffset;
    private BlockPos inChunkOffset;
    public double prevWorldRotX = 0.0;
    public double prevWorldRotY = 0.0;
    public double prevWorldRotZ = 0.0;
    public double worldRotX = 0.0;
    public double worldRotY = 0.0;
    public double worldRotZ = 0.0;
    private int progress;
    public int duration;
    public boolean approved = true;
    public DoorTransformation transformation;
    public BlockPos startOffset;
    private int lastSendProgress = -1;

    @SideOnly(value=Side.CLIENT)
    public boolean isWaitingForRender() {
        return this.waitingForRender != null;
    }

    public void removeWaitingTe(TileEntityLittleTiles te) {
        this.waitingForRender.remove((Object)te);
        this.renderData.removeValue((Object)new TERenderData(null, null, te.func_174877_v()));
    }

    public void setAxisVec(LittleTileVec axis) {
        this.axis = axis;
        this.baseOffset = axis.getBlockPos();
        this.inBlockAxis = axis.copy();
        this.inBlockAxis.subVec(new LittleTileVec((Vec3i)this.baseOffset));
        this.chunkOffset = EntityAnimation.getRenderChunkPos(this.baseOffset);
        int chunkX = EntityAnimation.bucketInt(this.baseOffset.func_177958_n(), 16);
        int chunkY = EntityAnimation.bucketInt(this.baseOffset.func_177956_o(), 16);
        int chunkZ = EntityAnimation.bucketInt(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
    }

    public static int bucketInt(int p_76137_0_, int p_76137_1_) {
        return p_76137_0_ < 0 ? -((-p_76137_0_ - 1) / p_76137_1_) - 1 : p_76137_0_ / p_76137_1_;
    }

    public LittleTileVec getAxis() {
        return this.axis;
    }

    public LittleTileVec getInsideBlockAxis() {
        return this.inBlockAxis;
    }

    public BlockPos getAxisPos() {
        return this.baseOffset;
    }

    public BlockPos getAxisChunkPos() {
        return this.chunkOffset;
    }

    public BlockPos getInsideChunkPos() {
        return this.inChunkOffset;
    }

    public Vec3d getRotVector(float partialTicks) {
        return new Vec3d(this.prevWorldRotX + (this.worldRotX - this.prevWorldRotX) * (double)partialTicks, this.prevWorldRotY + (this.worldRotY - this.prevWorldRotY) * (double)partialTicks, this.prevWorldRotZ + (this.worldRotZ - this.prevWorldRotZ) * (double)partialTicks);
    }

    public EntityAnimation(World worldIn) {
        super(worldIn);
    }

    public static BlockPos getRenderChunkPos(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n() >> 4, blockPos.func_177956_o() >> 4, blockPos.func_177952_p() >> 4);
    }

    public EntityAnimation(World world, BlockPos pos, LittleDoorBase structure, ArrayList<TileEntityLittleTiles> blocks, ArrayList<PlacePreviewTile> previews, LittleTileVec axis, DoorTransformation transformation, UUID uuid, EntityPlayer activator) {
        this(world);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.activator = activator;
        this.structure = structure;
        this.blocks = blocks;
        this.previews = previews;
        this.field_96093_i = uuid;
        this.field_189513_ar = this.field_96093_i.toString();
        this.setAxisVec(axis);
        this.startOffset = pos.func_177973_b((Vec3i)this.baseOffset);
        this.transformation = transformation;
        this.duration = structure.duration;
        this.setTransformationStartOffset();
        if (world.field_72995_K) {
            this.createClient();
        }
    }

    public void setTransformationStartOffset() {
        this.transformation.performTransformation(this, 0.0);
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void updateRenderBoundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (TileEntityLittleTiles te : this.blocks) {
            te.rendering = new AtomicBoolean(false);
            te.setLoaded();
            RenderingThread.addCoordToUpdate(te, 0.0, false);
            minX = Math.min(minX, te.func_174877_v().func_177958_n());
            minY = Math.min(minY, te.func_174877_v().func_177956_o());
            minZ = Math.min(minZ, te.func_174877_v().func_177952_p());
            maxX = Math.max(maxX, te.func_174877_v().func_177958_n());
            maxY = Math.max(maxY, te.func_174877_v().func_177956_o());
            maxZ = Math.max(maxZ, te.func_174877_v().func_177952_p());
        }
        this.renderBoundingBox = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)).func_186670_a(this.startOffset);
    }

    @SideOnly(value=Side.CLIENT)
    public void createClient() {
        if (this.blocks != null) {
            this.renderData = new HashMapList();
            this.renderQueue = new ArrayList<TileEntityLittleTiles>(this.blocks);
            this.updateRenderBoundingBox();
        }
        this.approved = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70107_b(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K) {
            super.func_70107_b(x, y, z);
            return;
        }
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        float f = this.field_70130_N / 2.0f;
        float f1 = this.field_70131_O;
        this.func_174826_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.blocks == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        if (this.transformation == null) {
            return;
        }
        this.transformation.performTransformation(this, (double)this.progress / (double)this.duration);
        if (this.field_70170_p.field_72995_K && (this.prevWorldRotX != this.worldRotX || this.prevWorldRotY != this.worldRotY || this.field_70166_s != this.worldRotZ)) {
            Matrix3d rotationX = new Matrix3d();
            rotationX.rotX(Math.toRadians(this.worldRotX));
            Matrix3d rotationY = new Matrix3d();
            rotationY.rotY(Math.toRadians(this.worldRotY));
            Matrix3d rotationZ = new Matrix3d();
            rotationZ.rotZ(Math.toRadians(this.worldRotZ));
            ArrayList<Vector3d> boxPoints = new ArrayList<Vector3d>();
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72340_a, this.renderBoundingBox.field_72338_b, this.renderBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72336_d, this.renderBoundingBox.field_72338_b, this.renderBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72340_a, this.renderBoundingBox.field_72337_e, this.renderBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72340_a, this.renderBoundingBox.field_72338_b, this.renderBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72336_d, this.renderBoundingBox.field_72337_e, this.renderBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72336_d, this.renderBoundingBox.field_72338_b, this.renderBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72340_a, this.renderBoundingBox.field_72337_e, this.renderBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.renderBoundingBox.field_72336_d, this.renderBoundingBox.field_72337_e, this.renderBoundingBox.field_72334_f));
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            Vector3d origin = new Vector3d(this.axis.getPosX() + LittleTile.gridMCLength / 2.0, this.axis.getPosY() + LittleTile.gridMCLength / 2.0, this.axis.getPosZ() + LittleTile.gridMCLength / 2.0);
            for (int i = 0; i < boxPoints.size(); ++i) {
                Vector3d vec = (Vector3d)boxPoints.get(i);
                vec.sub((Tuple3d)origin);
                rotationX.transform((Tuple3d)vec);
                rotationY.transform((Tuple3d)vec);
                rotationZ.transform((Tuple3d)vec);
                vec.add((Tuple3d)origin);
                minX = Math.min(minX, vec.x);
                minY = Math.min(minY, vec.y);
                minZ = Math.min(minZ, vec.z);
                maxX = Math.max(maxX, vec.x);
                maxY = Math.max(maxY, vec.y);
                maxZ = Math.max(maxZ, vec.z);
            }
            BlockPos realStart = this.baseOffset.func_177971_a((Vec3i)this.startOffset);
            double offsetX = this.field_70165_t - (double)realStart.func_177958_n();
            double offsetY = this.field_70163_u - (double)realStart.func_177956_o();
            double offsetZ = this.field_70161_v - (double)realStart.func_177952_p();
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ).func_72317_d(offsetX, offsetY, offsetZ));
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (i == 0) {
                WorldFake fakeWorld = (WorldFake)this.blocks.get(i).func_145831_w();
                fakeWorld.offsetX = this.field_70165_t - (double)(this.getAxisPos().func_177958_n() - this.startOffset.func_177958_n());
                fakeWorld.offsetY = this.field_70163_u - (double)(this.getAxisPos().func_177956_o() - this.startOffset.func_177956_o());
                fakeWorld.offsetZ = this.field_70161_v - (double)(this.getAxisPos().func_177952_p() - this.startOffset.func_177952_p());
                if (fakeWorld.axis == null) {
                    Vec3d vec = this.getAxis().getVec();
                    fakeWorld.axis = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                fakeWorld.rotX = this.worldRotX;
                fakeWorld.rotY = this.worldRotY;
                fakeWorld.rotZ = this.worldRotZ;
            }
            this.blocks.get(i).func_73660_a();
        }
        if (this.field_70170_p.field_72995_K && this.isWaitingForRender()) {
            --this.ticksToWait;
            this.field_70128_L = this.waitingForRender.size() == 0 || this.ticksToWait < 0;
        } else if (this.progress >= this.duration) {
            LittleDoorBase structure = this.structure.copyToPlaceDoor();
            if (this.field_70170_p.field_72995_K) {
                structure.isWaitingForApprove = true;
            }
            if (!this.field_70170_p.field_72995_K || this.approved) {
                if (ItemBlockTiles.placeTiles(this.field_70170_p, null, this.previews, structure, this.baseOffset, null, null, false, EnumFacing.EAST)) {
                    if (this.field_70170_p.field_72995_K) {
                        this.waitingForRender = new ArrayList();
                        ArrayList coordsToCheck = new ArrayList(ItemBlockTiles.getSplittedTiles(this.previews, this.baseOffset).getKeys());
                        for (int i = 0; i < coordsToCheck.size(); ++i) {
                            TileEntity te = this.field_70170_p.func_175625_s((BlockPos)coordsToCheck.get(i));
                            if (!(te instanceof TileEntityLittleTiles)) continue;
                            ((TileEntityLittleTiles)te).waitingAnimation = this;
                            this.waitingForRender.add((TileEntityLittleTiles)te);
                        }
                        this.ticksToWait = this.waitingForRender.size() * 10;
                        this.field_70128_L = false;
                        return;
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)this.field_70170_p, (ItemStack)this.structure.getStructureDrop(), (BlockPos)this.baseOffset);
                }
            }
            this.field_70128_L = true;
        } else {
            this.setProgress(this.progress + 1);
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (!(this.field_70170_p.field_72995_K || this.lastSendProgress != -1 && progress - this.lastSendProgress <= 10 && progress != this.duration)) {
            this.field_70180_af.func_187227_b(ENTITY_PROGRESS, (Object)progress);
            this.lastSendProgress = progress;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ENTITY_PROGRESS, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && ENTITY_PROGRESS.equals(key) && !this.isWaitingForRender()) {
            this.progress = (Integer)this.field_70180_af.func_187225_a(ENTITY_PROGRESS);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.duration = compound.func_74762_e("duration");
        this.setProgress(compound.func_74762_e("progress"));
        this.transformation = DoorTransformation.loadFromNBT(compound.func_74775_l("transform"));
        this.startOffset = new BlockPos(compound.func_74762_e("strOffX"), compound.func_74762_e("strOffY"), compound.func_74762_e("strOffZ"));
        this.setAxisVec(new LittleTileVec("axis", compound));
        WorldFake worldFake = WorldFake.createFakeWorld((World)this.field_70170_p);
        NBTTagList list = compound.func_150295_c("tileEntity", (int)compound.func_74732_a());
        this.blocks = new ArrayList();
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        this.structure = null;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            TileEntityLittleTiles te = (TileEntityLittleTiles)TileEntity.func_190200_a((World)worldFake, (NBTTagCompound)nbt);
            te.func_145834_a((World)worldFake);
            this.blocks.add(te);
            for (LittleTile tile : te.getTiles()) {
                if (tile.isMainBlock) {
                    this.structure = (LittleDoorBase)tile.structure;
                }
                tiles.add(tile);
            }
            worldFake.func_175656_a(te.func_174877_v(), LittleTiles.blockTile.func_176223_P());
            worldFake.func_175690_a(te.func_174877_v(), (TileEntity)te);
        }
        ArrayList<PlacePreviewTile> defaultpreviews = new ArrayList<PlacePreviewTile>();
        LittleTileVec axisPoint = this.structure.getAxisVec();
        LittleTileVec invaxis = axisPoint.copy();
        invaxis.invert();
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTile tileOfList = (LittleTile)tiles.get(i);
            NBTTagCompound nbt = new NBTTagCompound();
            LittleTilePreview preview = tileOfList.getPreviewTile();
            preview.box.addOffset(new LittleTileVec((Vec3i)tileOfList.te.func_174877_v()));
            preview.box.addOffset(invaxis);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, new LittleTileVec(0, 0, 0)));
        }
        defaultpreviews.addAll(this.structure.getAdditionalPreviews());
        LittleTileVec internalOffset = new LittleTileVec(axisPoint.x - this.baseOffset.func_177958_n() * LittleTile.gridSize, axisPoint.y - this.baseOffset.func_177956_o() * LittleTile.gridSize, axisPoint.z - this.baseOffset.func_177952_p() * LittleTile.gridSize);
        this.previews = new ArrayList();
        for (int i = 0; i < defaultpreviews.size(); ++i) {
            PlacePreviewTile box = (PlacePreviewTile)defaultpreviews.get(i);
            box.box.addOffset(internalOffset);
            this.previews.add(box);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("duration", this.duration);
        compound.func_74768_a("progress", this.progress);
        compound.func_74782_a("transform", (NBTBase)this.transformation.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("strOffX", this.startOffset.func_177958_n());
        compound.func_74768_a("strOffY", this.startOffset.func_177956_o());
        compound.func_74768_a("strOffZ", this.startOffset.func_177952_p());
        this.axis.writeToNBT("axis", compound);
        NBTTagList list = new NBTTagList();
        for (TileEntityLittleTiles te : this.blocks) {
            list.func_74742_a((NBTBase)te.func_189515_b(new NBTTagCompound()));
        }
        compound.func_74782_a("tileEntity", (NBTBase)list);
        this.setTransformationStartOffset();
    }

    public EntityAnimation copy() {
        EntityAnimation animation = new EntityAnimation(this.field_70170_p);
        animation.func_184221_a(this.func_110124_au());
        animation.setAxisVec(this.getAxis());
        animation.structure = this.structure;
        animation.previews = this.previews;
        animation.blocks = this.blocks;
        if (this.field_70170_p.field_72995_K) {
            animation.renderData = this.renderData;
            animation.renderQueue = this.renderQueue;
            animation.renderBoundingBox = this.renderBoundingBox;
        }
        animation.prevWorldRotX = this.prevWorldRotX;
        animation.prevWorldRotY = this.prevWorldRotY;
        animation.prevWorldRotZ = this.prevWorldRotZ;
        animation.worldRotX = this.worldRotX;
        animation.worldRotY = this.worldRotY;
        animation.worldRotZ = this.worldRotZ;
        animation.progress = this.progress;
        animation.duration = this.duration;
        animation.approved = this.approved;
        animation.transformation = this.transformation;
        animation.startOffset = this.startOffset;
        animation.lastSendProgress = this.lastSendProgress;
        return animation;
    }
}

