/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.events;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemUtilityKnife;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleEntityRequestPacket;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleEvent {
    @SubscribeEvent
    public void trackEntity(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityAnimation && ((EntityAnimation)event.getTarget()).activator != event.getEntityPlayer()) {
            EntityAnimation animation = (EntityAnimation)event.getTarget();
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(animation.func_110124_au(), animation.func_189511_e(new NBTTagCompound()), true), (EntityPlayerMP)((EntityPlayerMP)event.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void speedEvent(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        float hardness = event.getState().func_185887_b(world, event.getPos());
        ItemStack stack = player.func_184614_ca();
        if (SubContainerHammer.isBlockValid(event.getState().func_177230_c()) && stack != null && stack.func_77973_b() instanceof ItemUtilityKnife) {
            float modifier = 2.0f;
            if (!ForgeHooks.canHarvestBlock((Block)event.getState().func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)event.getPos())) {
                modifier *= 3.3333333f;
            }
            event.setNewSpeed(event.getOriginalSpeed() * hardness * modifier);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockTile.TEResult te;
        ItemStack stack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (stack != null && stack.func_77973_b() == Items.field_151114_aO && event.getEntityPlayer().func_70093_af() && (te = BlockTile.loadTeAndTile((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos(), event.getEntityPlayer())).isComplete()) {
            if (event.getHand() == EnumHand.MAIN_HAND && event.getWorld().field_72995_K) {
                if (te.tile.glowing) {
                    event.getEntityPlayer().func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
                } else {
                    event.getEntityPlayer().func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
                }
                te.tile.glowing = !te.tile.glowing;
                te.te.updateLighting();
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(event.getPos(), event.getEntityPlayer(), 5));
            }
            event.setCanceled(true);
        }
        if (PlacementHelper.isLittleBlock(stack)) {
            if (event.getHand() == EnumHand.MAIN_HAND && event.getWorld().field_72995_K) {
                this.onRightInteractClient(event.getEntityPlayer(), event.getHand(), event.getWorld(), stack, event.getPos(), event.getFace());
            }
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRightInteractClient(EntityPlayer player, EnumHand hand, World world, ItemStack stack, BlockPos pos, EnumFacing facing) {
        RayTraceResult moving = Minecraft.func_71410_x().field_71476_x;
        ((ItemBlockTiles)Item.func_150898_a((Block)LittleTiles.blockTile)).func_180614_a(stack, player, world, pos, hand, facing, (float)moving.field_72307_f.field_72450_a, (float)moving.field_72307_f.field_72448_b, (float)moving.field_72307_f.field_72449_c);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityPlayer player = event.getPlayer();
            World world = event.getPlayer().func_130014_f_();
            BlockPos pos = event.getTarget().func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (SubContainerHammer.isBlockValid(state.func_177230_c()) && stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                LittleTileBox box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(world, pos, state, player, event.getTarget());
                box.addOffset(new LittleTileVec((Vec3i)pos));
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                RenderGlobal.func_189697_a((AxisAlignedBB)box.getBox().func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void isSleepingLocationAllowed(SleepingLocationCheckEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed && ((LittleBed)bed).sleepingPlayer == event.getEntityPlayer()) {
                event.setResult(Event.Result.ALLOW);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.player);
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).sleepingPlayer = null;
            }
            LittleBed.littleBed.set(event.player, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).sleepingPlayer = null;
            }
            LittleBed.littleBed.set(event.getEntityPlayer(), null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        TileEntityLittleTiles te;
        if (event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() instanceof BlockTile && (te = BlockTile.loadTe((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos())) != null) {
            for (LittleTile tile : te.getTiles()) {
                if (!(tile.structure instanceof LittleBed) || !((LittleBed)tile.structure).hasBeenActivated) continue;
                ((LittleBed)tile.structure).trySleep(event.getEntityPlayer(), tile.structure.getHighestCenterPoint());
                event.setResult(EntityPlayer.SleepResult.OK);
                ((LittleBed)tile.structure).hasBeenActivated = false;
                return;
            }
        }
    }
}

