/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.creativecore.gui.controls.container.SlotControl;
import com.creativemd.creativecore.gui.event.container.SlotChangeEvent;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.gui.controls.SlotControlBlockEntry;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerTileContainer
extends SubContainer {
    public ItemStack stack;
    public int index;

    public SubContainerTileContainer(EntityPlayer player, ItemStack stack, int index) {
        super(player);
        this.stack = stack;
        this.index = index;
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        if (event.source instanceof SlotControlBlockEntry) {
            SlotControlBlockEntry control = (SlotControlBlockEntry)event.source;
            Slot slot = ((SlotControl)event.source).slot;
            ItemStack input = slot.func_75211_c();
            Block block = null;
            int meta = 0;
            if (input != null) {
                block = Block.func_149634_a((Item)input.func_77973_b());
                meta = input.func_77952_i();
            }
            if (control.entry != null) {
                block = control.entry.block;
                meta = control.entry.meta;
            }
            if (!(block instanceof BlockAir) && SubContainerHammer.isBlockValid(block) || PlacementHelper.isLittleBlock(input) || input.func_77973_b() instanceof ItemTileContainer) {
                if (control.entry == null) {
                    if (input != null) {
                        if (input.func_77973_b() instanceof ItemTileContainer) {
                            if (this.stack != input) {
                                ArrayList<ItemTileContainer.BlockEntry> map = ItemTileContainer.loadMap(input);
                                for (int i = 0; i < map.size(); ++i) {
                                    ItemTileContainer.addBlock(this.stack, map.get((int)i).block, map.get((int)i).meta, map.get((int)i).value);
                                }
                                ItemTileContainer.saveMap(input, new ArrayList<ItemTileContainer.BlockEntry>());
                            }
                            slot.func_75215_d(null);
                            if (this.player.field_71071_by.func_70441_a(input)) {
                                this.player.func_71019_a(input, false);
                            }
                        } else if (PlacementHelper.isLittleBlock(input)) {
                            ArrayList<LittleTilePreview> previews = PlacementHelper.getLittleInterface(input).getLittlePreview(input);
                            for (int i = 0; i < previews.size(); ++i) {
                                if (previews.get(i).isOrdinaryTile()) {
                                    ItemTileContainer.addBlock(this.stack, previews.get(i).getPreviewBlock(), previews.get(i).getPreviewBlockMeta(), previews.get((int)i).size.getPercentVolume() * (double)input.field_77994_a);
                                    continue;
                                }
                                ItemStack unmergeable = ItemBlockTiles.getStackFromPreview(previews.get(i));
                                if (!this.player.field_71071_by.func_70441_a(unmergeable)) continue;
                                this.player.func_71019_a(unmergeable, false);
                            }
                            slot.func_75215_d(null);
                        } else {
                            ItemTileContainer.addBlock(this.stack, block, meta, (double)input.field_77994_a);
                            slot.func_75215_d(null);
                        }
                    }
                } else {
                    int stackSize;
                    int n = stackSize = input != null ? input.field_77994_a : 0;
                    if (control.entry.value < 1.0) {
                        int countBefore = (int)(control.entry.value / LittleTile.minimumTileSize);
                        if (countBefore > stackSize) {
                            ItemTileContainer.drainBlock(this.stack, control.entry.block, control.entry.meta, (double)(countBefore - stackSize) * LittleTile.minimumTileSize);
                        } else if (countBefore < stackSize) {
                            ItemTileContainer.addBlock(this.stack, control.entry.block, control.entry.meta, (double)(stackSize - countBefore) * LittleTile.minimumTileSize);
                        }
                    } else {
                        int countBefore = (int)control.entry.value;
                        if (countBefore > stackSize) {
                            ItemTileContainer.drainBlock(this.stack, control.entry.block, control.entry.meta, (double)(countBefore - stackSize));
                        } else if (countBefore < stackSize) {
                            ItemTileContainer.addBlock(this.stack, control.entry.block, control.entry.meta, (double)(stackSize - countBefore));
                        }
                    }
                }
            }
            this.reloadControls();
        }
    }

    public void reloadControls() {
        this.controls.clear();
        this.createControls();
        this.refreshControls();
        NBTTagCompound nbt = this.stack.func_77978_p().func_74737_b();
        nbt.func_74757_a("reload", true);
        this.sendNBTToGui(nbt);
    }

    public void createControls() {
        int index = 0;
        ArrayList<ItemTileContainer.BlockEntry> map = ItemTileContainer.loadMap(this.stack);
        InventoryBasic basic = new InventoryBasic("item", false, map.size() + 1){

            public int func_70297_j_() {
                return 4098;
            }
        };
        int cols = 2;
        for (ItemTileContainer.BlockEntry entry : map) {
            if (entry.block instanceof BlockAir || entry.block == null) continue;
            ItemStack stack = entry.getItemStack();
            if (entry.value >= 1.0) {
                stack.field_77994_a = (int)entry.value;
            } else {
                stack = entry.getTileItemStack();
            }
            basic.func_70299_a(index, stack);
            this.controls.add(new SlotControlBlockEntry(new Slot((IInventory)basic, index, 8 + index % cols * 110, 8 + index / cols * 24){

                public boolean func_75214_a(ItemStack stack) {
                    return SubContainerHammer.isBlockValid(Block.func_149634_a((Item)stack.func_77973_b())) || PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemTileContainer;
                }
            }, entry));
            ++index;
        }
        basic.func_70299_a(index, null);
        SlotControlBlockEntry control = new SlotControlBlockEntry(new Slot((IInventory)basic, index, 8 + index % cols * 110, 8 + index / cols * 24), null);
        control.name = "item-last" + index;
        this.controls.add(control);
        this.addPlayerSlotsToContainer(this.player, 50, 170, this.index);
    }

    public void onClosed() {
        this.player.field_71071_by.field_70462_a[this.player.field_71071_by.field_70461_c] = this.stack;
    }

    public void onPacketReceive(NBTTagCompound nbt) {
    }
}

