/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerWrench
extends SubContainer {
    public InventoryBasic basic = new InventoryBasic("default", false, 2);

    public SubContainerWrench(EntityPlayer player) {
        super(player);
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.basic, 0, 5, 5));
        this.addSlotToContainer(new Slot((IInventory)this.basic, 1, 35, 5));
        this.addPlayerSlotsToContainer(this.player);
    }

    public static boolean drainIngridients(ArrayList<ItemTileContainer.BlockEntry> ingredients, ItemStack stack, boolean drain, ArrayList<ItemTileContainer.BlockEntry> remaining, boolean useStructures) {
        ArrayList<ItemTileContainer.BlockEntry> content = SubContainerWrench.getContentofStack(stack, useStructures);
        for (int i = 0; i < content.size(); ++i) {
            ItemTileContainer.BlockEntry entry;
            int index;
            if (ingredients.isEmpty() || (index = ingredients.indexOf(entry = content.get(i))) == -1) continue;
            ItemTileContainer.BlockEntry ingredient = ingredients.get(index);
            int takenStackSize = (int)Math.min((double)stack.field_77994_a, Math.ceil(ingredient.value / entry.value));
            if (takenStackSize > 0) {
                double takenVolume = Math.min(ingredient.value, entry.value * (double)takenStackSize);
                ingredient.value -= takenVolume;
                if (drain) {
                    if (!(stack.func_77973_b() instanceof ItemTileContainer)) {
                        stack.field_77994_a -= takenStackSize;
                    } else {
                        ItemTileContainer.drainBlock(stack, entry.block, entry.meta, entry.value * (double)takenStackSize);
                    }
                    if (takenVolume < entry.value * (double)takenStackSize) {
                        entry.value = entry.value * (double)takenStackSize - takenVolume;
                        remaining.add(entry);
                    }
                }
            }
            if (!(ingredient.value <= 0.0)) continue;
            ingredients.remove(ingredient);
        }
        return ingredients.isEmpty();
    }

    public static boolean drainIngridients(ArrayList<ItemTileContainer.BlockEntry> ingredients, IInventory inventory, boolean drain, ArrayList<ItemTileContainer.BlockEntry> remaining, boolean useStructures) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            boolean result = SubContainerWrench.drainIngridients(ingredients, stack, drain, remaining, useStructures);
            if (stack.field_77994_a <= 0) {
                inventory.func_70299_a(i, null);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<ItemTileContainer.BlockEntry> getRequiredIngredients(ArrayList<LittleTilePreview> previews) {
        ArrayList<ItemTileContainer.BlockEntry> ingredients = new ArrayList<ItemTileContainer.BlockEntry>();
        for (int i = 0; i < previews.size(); ++i) {
            ItemTileContainer.BlockEntry entry = previews.get(i).getBlockEntry();
            int index = ingredients.indexOf(entry);
            if (index != -1) {
                ingredients.get((int)index).value += entry.value;
                continue;
            }
            ingredients.add(entry);
        }
        return ingredients;
    }

    public static ArrayList<ItemTileContainer.BlockEntry> getContentofStack(ItemStack stack, boolean useStructures) {
        ArrayList<ItemTileContainer.BlockEntry> entries = new ArrayList<ItemTileContainer.BlockEntry>();
        if (stack != null) {
            ArrayList<LittleTilePreview> tiles;
            ILittleTile tile;
            if (useStructures && (tile = PlacementHelper.getLittleInterface(stack)) != null && (tiles = tile.getLittlePreview(stack)) != null) {
                for (int i = 0; i < tiles.size(); ++i) {
                    Block block2 = tiles.get(i).getPreviewBlock();
                    if (block2 == null || block2 instanceof BlockAir) continue;
                    entries.add(tiles.get(i).getBlockEntry());
                }
                return entries;
            }
            if (stack.func_77973_b() instanceof ItemTileContainer) {
                entries.addAll(ItemTileContainer.loadMap(stack));
            } else {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block != null && !(block instanceof BlockAir) && SubContainerHammer.isBlockValid(block)) {
                    entries.add(new ItemTileContainer.BlockEntry(block, stack.func_77952_i(), 1.0));
                }
            }
        }
        return entries;
    }

    public void onClosed() {
        for (int i = 0; i < this.basic.func_70302_i_(); ++i) {
            if (this.basic.func_70301_a(i) == null) continue;
            this.player.func_71019_a(this.basic.func_70301_a(i), false);
        }
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        ItemStack stack1 = this.basic.func_70301_a(0);
        ItemStack stack2 = this.basic.func_70301_a(1);
        if (stack1 != null) {
            if (stack1.func_77973_b() instanceof ItemRecipe) {
                if (stack1.func_77978_p() != null && !stack1.func_77978_p().func_74764_b("x")) {
                    ArrayList<LittleTilePreview> tiles = ItemRecipe.getPreview(stack1);
                    ArrayList<ItemTileContainer.BlockEntry> required = SubContainerWrench.getRequiredIngredients(tiles);
                    ArrayList<ItemTileContainer.BlockEntry> remaining = new ArrayList<ItemTileContainer.BlockEntry>();
                    boolean success = true;
                    if (!this.player.func_184812_l_()) {
                        boolean bl = success = SubContainerWrench.drainIngridients(required, stack2, false, remaining, true) || SubContainerWrench.drainIngridients(required, (IInventory)this.getPlayer().field_71071_by, false, remaining, false);
                    }
                    if (stack2 != null && stack2.field_77994_a <= 0) {
                        this.basic.func_70299_a(1, null);
                    }
                    if (remaining.size() > 0 && !ItemTileContainer.canStoreRemains(this.getPlayer())) {
                        success = false;
                    }
                    if (success) {
                        if (!this.player.func_184812_l_() && (SubContainerWrench.drainIngridients(required = SubContainerWrench.getRequiredIngredients(tiles), stack2, true, remaining = new ArrayList(), true) || SubContainerWrench.drainIngridients(required, (IInventory)this.getPlayer().field_71071_by, true, remaining, false))) {
                            for (int i = 0; i < remaining.size(); ++i) {
                                ItemTileContainer.addBlock(this.player, remaining.get((int)i).block, remaining.get((int)i).meta, remaining.get((int)i).value);
                            }
                        }
                        ItemStack stack = new ItemStack(LittleTiles.multiTiles);
                        stack.func_77982_d(stack1.func_77978_p().func_74737_b());
                        if (!this.player.field_71071_by.func_70441_a(stack)) {
                            WorldUtils.dropItem((EntityPlayer)this.player, (ItemStack)stack);
                        }
                    }
                }
            } else if (ChiselsAndBitsManager.isChiselsAndBitsStructure(stack1)) {
                ArrayList<LittleTilePreview> previews = ChiselsAndBitsManager.getPreviews(stack1);
                if (previews != null && !previews.isEmpty() && stack2 == null) {
                    stack2 = new ItemStack(LittleTiles.multiTiles);
                    ItemRecipe.savePreviewTiles(previews, stack2);
                    this.basic.func_70299_a(0, null);
                    this.basic.func_70299_a(1, stack2);
                }
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack1);
                if (tile != null && stack2 != null && stack2.func_77973_b() instanceof ItemRecipe) {
                    stack2.func_77982_d(stack1.func_77978_p().func_74737_b());
                }
            }
        }
    }
}

