/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.gui.event.ControlEvent;
import com.creativemd.creativecore.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlockColored;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.Color;

public class SubGuiHammer
extends SubGui {
    public boolean isColored = false;
    public int sizeX = 1;
    public int sizeY = 1;
    public int sizeZ = 1;

    public SubGuiHammer() {
        super(200, 200);
    }

    public void createControls() {
        this.controls.add(new GuiSteppedSlider("sizeX", 35, 10, 50, 14, this.sizeX, 1, LittleTile.gridSize));
        this.controls.add(new GuiSteppedSlider("sizeY", 35, 30, 50, 14, this.sizeY, 1, LittleTile.gridSize));
        this.controls.add(new GuiSteppedSlider("sizeZ", 35, 50, 50, 14, this.sizeZ, 1, LittleTile.gridSize));
        this.controls.add(new GuiButton("HAMMER IT", 100, 10){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("sizeX", SubGuiHammer.this.sizeX);
                nbt.func_74768_a("sizeY", SubGuiHammer.this.sizeY);
                nbt.func_74768_a("sizeZ", SubGuiHammer.this.sizeZ);
                GuiColorPicker picker = (GuiColorPicker)SubGuiHammer.this.get("picker");
                int color = ColorUtils.RGBAToInt((Color)picker.color);
                if (color != -1 && color != ColorUtils.WHITE) {
                    nbt.func_74768_a("color", color);
                }
                SubGuiHammer.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiColorPicker("picker", 5, 75, new Color(255, 255, 255)));
        GuiAvatarLabel label = new GuiAvatarLabel("", 100, 32, 0, null);
        label.name = "avatar";
        label.height = 60;
        this.controls.add(label);
        this.updateLabel();
    }

    public void updateLabel() {
        GuiAvatarLabel label = (GuiAvatarLabel)this.get("avatar");
        LittleTileSize size = new LittleTileSize(this.sizeX, this.sizeY, this.sizeZ);
        ItemStack dropstack = new ItemStack((Block)LittleTiles.blockTile);
        dropstack.func_77982_d(new NBTTagCompound());
        size.writeToNBT("size", dropstack.func_77978_p());
        Block block = null;
        ItemStack slotStack = ((Slot)this.container.getSlots().get(0)).func_75211_c();
        int meta = 0;
        if (slotStack != null) {
            block = Block.func_149634_a((Item)slotStack.func_77973_b());
            meta = slotStack.func_77952_i();
            if (block == LittleTiles.blockTile) {
                ArrayList<LittleTilePreview> previews = ((ILittleTile)slotStack.func_77973_b()).getLittlePreview(slotStack);
                if (previews.size() > 0) {
                    block = previews.get(0).getPreviewBlock();
                    meta = previews.get(0).getPreviewBlockMeta();
                } else {
                    block = null;
                }
            }
        }
        if (block instanceof BlockAir || block == null) {
            block = Blocks.field_150348_b;
        }
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        new LittleTileBlockColored(block, meta, ColorUtils.colorToVec((Color)picker.color)).saveTileExtra(dropstack.func_77978_p());
        label.avatar = new AvatarItemStack(dropstack);
    }

    @CustomEventSubscribe
    public void onSlotChange(SlotChangeEvent event) {
        ArrayList<LittleTilePreview> previews;
        Block block;
        ItemStack slotStack = ((Slot)this.container.getSlots().get(0)).func_75211_c();
        if (slotStack != null && (block = Block.func_149634_a((Item)slotStack.func_77973_b())) == LittleTiles.blockTile && (previews = ((ILittleTile)slotStack.func_77973_b()).getLittlePreview(slotStack)).size() > 0) {
            int colorInt = previews.get(0).getColor();
            Vec3i color = ColorUtils.IntToRGB((int)colorInt);
            if (colorInt == -1) {
                color = new Vec3i(255, 255, 255);
            }
            ((GuiSteppedSlider)this.get((String)"colorX")).value = color.func_177958_n();
            ((GuiSteppedSlider)this.get((String)"colorY")).value = color.func_177956_o();
            ((GuiSteppedSlider)this.get((String)"colorZ")).value = color.func_177952_p();
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this.get("colorZ")));
        }
        this.updateLabel();
    }

    @CustomEventSubscribe
    public void onChange(GuiControlChangedEvent event) {
        this.sizeX = (int)((GuiSteppedSlider)this.get((String)"sizeX")).value;
        this.sizeY = (int)((GuiSteppedSlider)this.get((String)"sizeY")).value;
        this.sizeZ = (int)((GuiSteppedSlider)this.get((String)"sizeZ")).value;
        this.updateLabel();
    }
}

