/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiColorPlate;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.common.particles.LittleParticleSettingType;
import com.creativemd.littletiles.common.particles.LittleParticleType;
import com.creativemd.littletiles.common.tileentity.TileEntityParticle;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.Color;

public class SubGuiParticle
extends SubGui {
    public TileEntityParticle particle;

    public SubGuiParticle(TileEntityParticle particle) {
        this.particle = particle;
    }

    public void createControls() {
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < LittleParticleType.values().length; ++i) {
            types.add(LittleParticleType.values()[i].name());
        }
        final GuiComboBox comboBox = new GuiComboBox("list", 17, 0, 136, types);
        comboBox.select(this.particle.particle);
        this.controls.add(comboBox);
        this.controls.add(new GuiButton("<<", 0, 0){

            public void onClicked(int x, int y, int button) {
                int index = comboBox.index - 1;
                if (index < 0) {
                    index = comboBox.lines.size() - 1;
                }
                comboBox.select((String)comboBox.lines.get(index));
            }
        });
        this.controls.add(new GuiButton(">>", 160, 0){

            public void onClicked(int x, int y, int button) {
                int index = comboBox.index + 1;
                if (index >= comboBox.lines.size()) {
                    index = 0;
                }
                comboBox.select((String)comboBox.lines.get(index));
            }
        });
        this.controls.add(new GuiLabel("labelSpeed", "Speed (particles/tick:", 0, 82));
        this.controls.add(new GuiTextfield("speed", "" + this.particle.speed, 120, 80, 40, 12).setFloatOnly());
        this.controls.add(new GuiCheckBox("randomize", 0, 100, this.particle.randomize));
        this.controls.add(new GuiAnalogeSlider("age", 0, 120, 100, 10, this.particle.ageModifier, 0.1f, 10.0f));
        this.controls.add(new GuiButton("Save", 145, 145){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("particle", ((GuiComboBox)SubGuiParticle.this.get((String)"list")).caption);
                LittleParticleType type = LittleParticleType.valueOf(((GuiComboBox)SubGuiParticle.this.get((String)"list")).caption);
                if (type != null) {
                    switch (type.type) {
                        case COLOR: 
                        case COLOR_RED_OFFSET: {
                            GuiColorPlate plate = (GuiColorPlate)SubGuiParticle.this.get("color");
                            Color color = plate.getColor();
                            nbt.func_74776_a("par1", (float)color.getRed() / 255.0f);
                            nbt.func_74776_a("par2", (float)color.getGreen() / 255.0f);
                            nbt.func_74776_a("par3", (float)color.getBlue() / 255.0f);
                            break;
                        }
                        case FIRST_COLOR: {
                            nbt.func_74776_a("par1", ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"color")).value);
                            break;
                        }
                        case MOTION: 
                        case MOTION_WITHOUT_Y: {
                            nbt.func_74776_a("par1", ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"par1")).value);
                            if (type.type == LittleParticleSettingType.MOTION_WITHOUT_Y) {
                                nbt.func_74776_a("par2", 0.0f);
                            } else {
                                nbt.func_74776_a("par2", ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"par2")).value);
                            }
                            nbt.func_74776_a("par3", ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"par3")).value);
                            break;
                        }
                        case MOTION_XY_OPTION: {
                            if (!((GuiCheckBox)SubGuiParticle.this.get((String)"spread")).value) break;
                            nbt.func_74776_a("par1", 1.0f);
                            nbt.func_74776_a("par2", 1.0f);
                            nbt.func_74776_a("par3", 1.0f);
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        case SIZE: {
                            nbt.func_74776_a("par1", 2.0f - ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"size")).value);
                            break;
                        }
                    }
                }
                nbt.func_74776_a("speed", Float.parseFloat(((GuiTextfield)SubGuiParticle.this.get((String)"speed")).text));
                nbt.func_74757_a("randomize", ((GuiCheckBox)SubGuiParticle.this.get((String)"randomize")).value);
                nbt.func_74776_a("age", ((GuiAnalogeSlider)SubGuiParticle.this.get((String)"age")).value);
                SubGuiParticle.this.sendPacketToServer(nbt);
            }
        });
        this.loadParticleSettings();
    }

    @CustomEventSubscribe
    public void onParticleChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"list"})) {
            this.removeControls(new String[]{"<<", "list", ">>", "randomize", "age", "Save", "labelSpeed", "speed"});
            this.loadParticleSettings();
        } else if (event.source.is(new String[]{"colorR", "colorG", "colorB"})) {
            ((GuiColorPlate)this.get("color")).setColor(new Vec3i((double)(((GuiAnalogeSlider)this.get((String)"colorR")).value * 255.0f), (double)(((GuiAnalogeSlider)this.get((String)"colorG")).value * 255.0f), (double)(((GuiAnalogeSlider)this.get((String)"colorB")).value * 255.0f)));
        }
    }

    public void loadParticleSettings() {
        LittleParticleType type = LittleParticleType.valueOf(((GuiComboBox)this.get((String)"list")).caption);
        if (type != null) {
            switch (type.type) {
                case COLOR: 
                case COLOR_RED_OFFSET: {
                    this.controls.add(new GuiAnalogeSlider("colorR", 0, 25, 100, 10, this.particle.par1, 0.0f, 1.0f));
                    this.controls.add(new GuiAnalogeSlider("colorG", 0, 42, 100, 10, this.particle.par2, 0.0f, 1.0f));
                    this.controls.add(new GuiAnalogeSlider("colorB", 0, 59, 100, 10, this.particle.par3, 0.0f, 1.0f));
                    this.controls.add(new GuiColorPlate("color", 120, 25, 20, 20, ColorUtils.IntToRGB((int)ColorUtils.VecToInt((Vec3d)new Vec3d((double)this.particle.par1, (double)this.particle.par2, (double)this.particle.par3)))));
                    break;
                }
                case FIRST_COLOR: {
                    this.controls.add(new GuiAnalogeSlider("color", 0, 25, 100, 10, this.particle.par1, 0.0f, 1.0f));
                    break;
                }
                case MOTION: 
                case MOTION_WITHOUT_Y: {
                    this.controls.add(new GuiAnalogeSlider("par1", 0, 25, 100, 10, this.particle.par1, -1.0f, 1.0f));
                    if (type.type != LittleParticleSettingType.MOTION_WITHOUT_Y) {
                        this.controls.add(new GuiAnalogeSlider("par2", 0, 42, 100, 10, this.particle.par2, -1.0f, 1.0f));
                    }
                    this.controls.add(new GuiAnalogeSlider("par3", 0, 59, 100, 10, this.particle.par3, -1.0f, 1.0f));
                    break;
                }
                case MOTION_XY_OPTION: {
                    this.controls.add(new GuiCheckBox("spread", 0, 25, this.particle.par1 != 0.0f || this.particle.par3 != 0.0f));
                    break;
                }
                case NONE: {
                    break;
                }
                case SIZE: {
                    this.controls.add(new GuiAnalogeSlider("size", 0, 25, 100, 10, 2.0f - this.particle.par1, 0.0f, 2.0f));
                }
            }
        }
        this.refreshControls();
    }
}

