/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.gui.ContainerControl;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiScrollBox;
import com.creativemd.littletiles.common.gui.SubContainerTileContainer;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import java.util.ArrayList;
import net.minecraft.block.BlockAir;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiTileContainer
extends SubGui {
    public ItemStack stack;

    public SubGuiTileContainer(ItemStack stack) {
        super(250, 250);
        this.stack = stack;
    }

    public static String getStringOfValue(double value) {
        String line = "";
        if (value >= 1.0) {
            line = line + (int)value + " blocks";
        }
        if (value % 1.0 != 0.0) {
            if (!line.equals("")) {
                line = line + " ";
            }
            int amount = (int)(value % 1.0 * 4096.0);
            line = line + amount + " tile";
            if (amount != 1) {
                line = line + "s";
            }
        }
        return line;
    }

    public void addContainerControls() {
        GuiScrollBox box = (GuiScrollBox)this.get("items");
        for (int i = 0; i < this.container.controls.size(); ++i) {
            ((ContainerControl)this.container.controls.get(i)).onOpened();
            if (((ContainerControl)this.container.controls.get((int)i)).name.startsWith("item")) {
                box.addControl(((ContainerControl)this.container.controls.get(i)).getGuiControl());
                continue;
            }
            this.controls.add(((ContainerControl)this.container.controls.get(i)).getGuiControl());
        }
    }

    public void createControls() {
        GuiScrollBox box = new GuiScrollBox("items", 0, 0, 245, 150);
        this.controls.add(box);
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        ArrayList<ItemTileContainer.BlockEntry> map = ItemTileContainer.loadMap(this.stack);
        int i = 0;
        int cols = 2;
        for (ItemTileContainer.BlockEntry entry : map) {
            if (entry.block instanceof BlockAir || entry.block == null) continue;
            box.addControl((GuiControl)new GuiLabel(SubGuiTileContainer.getStringOfValue(entry.value % 1.0), 28 + i % cols * 110, 11 + i / cols * 24));
            ++i;
        }
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        if (nbt.func_74767_n("reload")) {
            nbt.func_82580_o("reload");
            this.stack.func_77982_d(nbt);
            this.controls.clear();
            this.createControls();
            this.refreshControls();
            this.container.controls.clear();
            ((SubContainerTileContainer)this.container).stack = this.stack;
            this.container.createControls();
            this.container.refreshControls();
            this.addContainerControls();
            this.refreshControls();
        }
    }
}

