/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRubberMallet
extends Item {
    public ItemRubberMallet() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        list.add("rightclick moves tiles in faced direction");
        list.add("shift+rightclick moves tiles in oposite faced direction");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            if (world.field_72995_K) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("side", facing.func_176745_a());
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(pos, player, 4, nbt));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static boolean moveTile(TileEntityLittleTiles te, EnumFacing facing, LittleTile tile, boolean simulate) {
        LittleTileVec vec = new LittleTileVec(facing);
        LittleTileBox box = tile.boundingBoxes.get(0).copy();
        box.addOffset(vec);
        if (box.isBoxInsideBlock()) {
            return ItemRubberMallet.tryMoveTile(te.func_145831_w(), te.func_174877_v(), facing, box, tile, simulate);
        }
        if (ItemRubberMallet.tryMoveTile(te.func_145831_w(), te.func_174877_v().func_177972_a(facing), facing, box.createOutsideBlockBox(facing), tile, simulate)) {
            if (!simulate) {
                box.makeItFitInsideBlock();
                if (box.isValidBox()) {
                    tile.boundingBoxes.clear();
                    tile.boundingBoxes.add(box);
                    te.updateBlock();
                } else {
                    if (tile.isStructureBlock) {
                        tile.structure.getTiles().remove(tile);
                    }
                    te.removeTile(tile);
                }
            }
            return true;
        }
        return false;
    }

    private static void placeMovingTile(LittleTile movingTile, TileEntityLittleTiles littleTE, LittleTileBox box) {
        LittleTile tile = movingTile;
        if (movingTile.te != littleTE) {
            tile = movingTile.copy();
        }
        tile.boundingBoxes.clear();
        tile.boundingBoxes.add(box);
        tile.updateCorner();
        if (movingTile.te != littleTE) {
            tile.te = littleTE;
            tile.place();
            if (movingTile.isStructureBlock) {
                tile.isStructureBlock = true;
            }
            if (movingTile.isStructureBlock) {
                tile.structure.getTiles().add(tile);
            }
        }
    }

    public static boolean tryMoveTile(World world, BlockPos pos, EnumFacing facing, LittleTileBox box, LittleTile movingTile, boolean simulate) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        TileEntityLittleTiles littleTE = null;
        if (state.func_185904_a().func_76222_j()) {
            littleTE = new TileEntityLittleTiles();
        }
        if (te instanceof TileEntityLittleTiles) {
            littleTE = (TileEntityLittleTiles)te;
        }
        if (littleTE != null) {
            if (littleTE.isSpaceForLittleTile(box, movingTile)) {
                if (!simulate) {
                    ItemRubberMallet.placeMovingTile(movingTile, littleTE, box);
                    if (state.func_177230_c() != LittleTiles.blockTile) {
                        world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
                        world.func_175690_a(pos, (TileEntity)littleTE);
                    }
                }
                return true;
            }
            LittleTile tile = littleTE.getIntersectingTile(box, movingTile);
            if (!tile.canBeMoved(facing)) {
                return false;
            }
            if (movingTile.isStructureBlock) {
                if (tile.isStructureBlock && tile.structure == movingTile.structure) {
                    if (!simulate) {
                        ItemRubberMallet.placeMovingTile(movingTile, littleTE, box);
                        if (state.func_177230_c() != LittleTiles.blockTile) {
                            world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
                            world.func_175690_a(pos, (TileEntity)littleTE);
                        }
                    }
                    return true;
                }
            } else if (movingTile.canBeCombined(tile) && tile.canBeCombined(movingTile) && tile.boundingBoxes.get(0).doesMatchTwoSides(box, facing) && ItemRubberMallet.moveTile(littleTE, facing, tile, simulate)) {
                if (!simulate) {
                    LittleTileBox newBox = tile.boundingBoxes.get(0).copy();
                    newBox.makeItFitInsideBlock();
                    newBox = newBox.combineBoxes(box);
                    if (newBox != null) {
                        if (littleTE == movingTile.te) {
                            movingTile.boundingBoxes.clear();
                            movingTile.boundingBoxes.add(newBox);
                            movingTile.updateCorner();
                            littleTE.removeTile(tile);
                        } else {
                            tile.boundingBoxes.clear();
                            tile.boundingBoxes.add(newBox);
                            tile.updateCorner();
                        }
                    }
                    littleTE.updateBlock();
                }
                return true;
            }
        }
        return false;
    }
}

