/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.opener.GuiHandler;
import com.creativemd.creativecore.gui.opener.IGuiCreator;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.gui.SubContainerUtilityKnife;
import com.creativemd.littletiles.common.gui.SubGuiUtilityKnife;
import com.creativemd.littletiles.common.packet.LittleBlockVanillaPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUtilityKnife
extends Item
implements ISpecialBlockSelector,
IGuiCreator {
    public ItemUtilityKnife() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        list.add("can be used to chisel blocks");
        list.add("mode: " + ItemUtilityKnife.getMode(stack).name());
        list.add("thickness: " + ItemUtilityKnife.getThickness(stack));
    }

    @Override
    public LittleTileBox getBox(TileEntityLittleTiles te, LittleTile tile, BlockPos pos, EntityPlayer player, RayTraceResult result) {
        if (tile.isStructureBlock) {
            return null;
        }
        LittleTileVec vec = PlacementHelper.getInstance(player).getHitVec(result.field_72307_f, pos, result.field_178784_b, false, false, false);
        if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.subVec(new LittleTileVec(result.field_178784_b));
        }
        return ItemUtilityKnife.getMode(player.func_184614_ca()).getBox(vec, ItemUtilityKnife.getThickness(player.func_184614_ca()), result.field_178784_b);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        IBlockState state = world.func_180495_p(pos);
        if (SubContainerHammer.isBlockValid(state.func_177230_c()) && stack != null && stack.func_77973_b() instanceof ItemUtilityKnife && (state.func_185887_b(world, pos) >= 0.0f || player.func_184812_l_())) {
            if (world.field_72995_K) {
                this.destroyBlock(stack, player, world, pos, state);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void destroyBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        LittleTileBox box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(world, pos, state, player, Minecraft.func_71410_x().field_71476_x);
        world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
        TileEntityLittleTiles te = (TileEntityLittleTiles)world.func_175625_s(pos);
        LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        tile.boundingBoxes.add(new LittleTileBox(0, 0, 0, LittleTile.maxPos, LittleTile.maxPos, LittleTile.maxPos));
        tile.te = te;
        ((LittleTile)tile).place();
        te.removeBoxFromTiles(box);
        if (!player.field_71075_bZ.field_75098_d) {
            tile.boundingBoxes.clear();
            tile.boundingBoxes.add(box.copy());
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockVanillaPacket(pos, player));
    }

    @Override
    public LittleTileBox getBox(World world, BlockPos pos, IBlockState state, EntityPlayer player, RayTraceResult result) {
        LittleTileVec vec = PlacementHelper.getInstance(player).getHitVec(result.field_72307_f, pos, result.field_178784_b, false, false, false);
        if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            vec.subVec(new LittleTileVec(result.field_178784_b));
        }
        return ItemUtilityKnife.getMode(player.func_184614_ca()).getBox(vec, ItemUtilityKnife.getThickness(player.func_184614_ca()), result.field_178784_b);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        if (!worldIn.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)playerIn, (World)worldIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiUtilityKnife(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerUtilityKnife(player, stack);
    }

    public static int getThickness(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return Math.max(1, stack.func_77978_p().func_74762_e("thick"));
    }

    public static UtilityKnifeMode getMode(ItemStack stack) {
        int mode;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((mode = stack.func_77978_p().func_74762_e("mode")) >= 0 && mode < UtilityKnifeMode.values().length) {
            return UtilityKnifeMode.values()[mode];
        }
        return UtilityKnifeMode.Cube;
    }

    public static enum UtilityKnifeMode {
        Cube{

            @Override
            public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
                LittleTileVec offset = new LittleTileVec(side);
                offset.scale((thickness - 1) / 2);
                vec.subVec(offset);
                if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE && (thickness & 1) == 0) {
                    vec.subVec(new LittleTileVec(side));
                }
                LittleTileBox box = new LittleTileBox(vec, new LittleTileSize(thickness, thickness, thickness));
                box.makeItFitInsideBlock();
                return box;
            }
        }
        ,
        Bar{

            @Override
            public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
                LittleTileBox box = Cube.getBox(vec, thickness, side);
                switch (side.func_176740_k()) {
                    case X: {
                        box.minX = 0;
                        box.maxX = LittleTile.gridSize;
                        break;
                    }
                    case Y: {
                        box.minY = 0;
                        box.maxY = LittleTile.gridSize;
                        break;
                    }
                    case Z: {
                        box.minZ = 0;
                        box.maxZ = LittleTile.gridSize;
                    }
                }
                return box;
            }
        }
        ,
        Plane{

            @Override
            public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
                LittleTileBox box = Cube.getBox(vec, thickness, side);
                switch (side.func_176740_k()) {
                    case X: {
                        box.minY = 0;
                        box.maxY = LittleTile.gridSize;
                        box.minZ = 0;
                        box.maxZ = LittleTile.gridSize;
                        break;
                    }
                    case Y: {
                        box.minX = 0;
                        box.maxX = LittleTile.gridSize;
                        box.minZ = 0;
                        box.maxZ = LittleTile.gridSize;
                        break;
                    }
                    case Z: {
                        box.minX = 0;
                        box.maxX = LittleTile.gridSize;
                        box.minY = 0;
                        box.maxY = LittleTile.gridSize;
                    }
                }
                return box;
            }
        };


        public abstract LittleTileBox getBox(LittleTileVec var1, int var2, EnumFacing var3);

        public static String[] names() {
            String[] names = new String[UtilityKnifeMode.values().length];
            for (int i = 0; i < UtilityKnifeMode.values().length; ++i) {
                names[i] = UtilityKnifeMode.values()[i].name();
            }
            return names;
        }
    }
}

