/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class LittleBedPacket
extends CreativeCorePacket {
    public BlockPos pos;
    public LittleTileVec vec;
    public int playerID;

    public LittleBedPacket() {
    }

    public LittleBedPacket(BlockPos pos, LittleTileVec vec) {
        this.pos = pos;
        this.vec = vec;
        this.playerID = -1;
    }

    public LittleBedPacket(BlockPos pos, LittleTileVec vec, EntityPlayer player) {
        this.pos = pos;
        this.vec = vec;
        this.playerID = player.func_145782_y();
    }

    public void writeBytes(ByteBuf buf) {
        LittleBedPacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.vec.x);
        buf.writeInt(this.vec.y);
        buf.writeInt(this.vec.z);
        buf.writeInt(this.playerID);
    }

    public void readBytes(ByteBuf buf) {
        this.pos = LittleBedPacket.readPos((ByteBuf)buf);
        this.vec = new LittleTileVec(buf.readInt(), buf.readInt(), buf.readInt());
        this.playerID = buf.readInt();
    }

    public void executeClient(EntityPlayer player) {
        LittleTile tile;
        TileEntityLittleTiles te;
        EntityPlayer entity;
        Object object = entity = this.playerID == -1 ? player : player.field_70170_p.func_73045_a(this.playerID);
        if (entity instanceof EntityPlayer && (te = BlockTile.loadTe((IBlockAccess)player.field_70170_p, this.pos)) != null && (tile = te.getTile(this.vec)) != null && tile.isLoaded() && tile.structure instanceof LittleBed) {
            ((LittleBed)tile.structure).trySleep(entity, tile.structure.getHighestCenterPoint());
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

