/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.items.ItemRubberMallet;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTileBlockColored;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBlockPacket
extends CreativeCorePacket {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;
    public int action;
    public NBTTagCompound nbt;

    public LittleBlockPacket() {
    }

    public LittleBlockPacket(BlockPos blockPos, EntityPlayer player, int action) {
        this(blockPos, player, action, new NBTTagCompound());
    }

    public LittleBlockPacket(BlockPos blockPos, EntityPlayer player, int action, NBTTagCompound nbt) {
        this.blockPos = blockPos;
        this.action = action;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.nbt = nbt;
    }

    public void writeBytes(ByteBuf buf) {
        LittleBlockPacket.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleBlockPacket.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleBlockPacket.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeInt(this.action);
        LittleBlockPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleBlockPacket.readPos((ByteBuf)buf);
        this.pos = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.look = LittleBlockPacket.readVec3d((ByteBuf)buf);
        this.action = buf.readInt();
        this.nbt = LittleBlockPacket.readNBT((ByteBuf)buf);
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        TileEntityLittleTiles te;
        LittleTile tile;
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        World world = player.field_70170_p;
        if (tileEntity instanceof TileEntityLittleTiles && (tile = (te = (TileEntityLittleTiles)tileEntity).getFocusedTile(this.pos, this.look)) != null) {
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            switch (this.action) {
                case 0: {
                    RayTraceResult moving = te.getMoving(this.pos, this.look);
                    if (!tile.onBlockActivated(player.field_70170_p, this.blockPos, player.field_70170_p.func_180495_p(this.blockPos), player, EnumHand.MAIN_HAND, player.func_184586_b(EnumHand.MAIN_HAND), moving.field_178784_b, (float)moving.field_72307_f.field_72450_a, (float)moving.field_72307_f.field_72448_b, (float)moving.field_72307_f.field_72449_c)) break;
                    BlockTile.cancelNext = true;
                    break;
                }
                case 1: {
                    LittleTileBox box = null;
                    RayTraceResult moving = te.getMoving(this.pos, this.look);
                    if (stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector && (box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(te, tile, te.func_174877_v(), player, moving)) != null) {
                        te.removeBoxFromTiles(box);
                        if (!player.field_71075_bZ.field_75098_d) {
                            tile.boundingBoxes.clear();
                            tile.boundingBoxes.add(box.copy());
                            WorldUtils.dropItem((EntityPlayer)player, tile.getDrops());
                        }
                    }
                    if (box == null) {
                        tile.destroy();
                        if (!player.field_71075_bZ.field_75098_d) {
                            WorldUtils.dropItem((World)player.field_70170_p, tile.getDrops(), (BlockPos)this.blockPos);
                        }
                    }
                    world.func_184133_a((EntityPlayer)null, this.blockPos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
                    break;
                }
                case 2: {
                    int side = this.nbt.func_74762_e("side");
                    EnumFacing direction = EnumFacing.func_82600_a((int)side);
                    if (!tile.canSawResizeTile(direction, player)) break;
                    LittleTileBox box = null;
                    box = player.func_70093_af() ? tile.boundingBoxes.get(0).shrink(direction) : tile.boundingBoxes.get(0).expand(direction);
                    if (!box.isValidBox()) break;
                    double ammount = tile.boundingBoxes.get(0).getSize().getPercentVolume() - box.getSize().getPercentVolume();
                    boolean success = false;
                    if (player.func_70093_af()) {
                        if (ItemTileContainer.addBlock(player, ((LittleTileBlock)tile).getBlock(), ((LittleTileBlock)tile).getMeta(), ammount)) {
                            success = true;
                        }
                    } else if (ItemTileContainer.drainBlock(player, ((LittleTileBlock)tile).getBlock(), ((LittleTileBlock)tile).getMeta(), -ammount)) {
                        success = true;
                    }
                    if (!player.field_71075_bZ.field_75098_d && !success) break;
                    if (box.isBoxInsideBlock() && te.isSpaceForLittleTile(box.getBox(), tile)) {
                        tile.boundingBoxes.set(0, box);
                        tile.updateCorner();
                        te.updateBlock();
                        break;
                    }
                    if (box.isBoxInsideBlock()) break;
                    box = box.createOutsideBlockBox(direction);
                    BlockPos newPos = this.blockPos.func_177972_a(direction);
                    IBlockState state = world.func_180495_p(newPos);
                    TileEntityLittleTiles littleTe = null;
                    TileEntity newTE = world.func_175625_s(newPos);
                    if (newTE instanceof TileEntityLittleTiles) {
                        littleTe = (TileEntityLittleTiles)newTE;
                    }
                    if (state.func_185904_a().func_76222_j()) {
                        world.func_175656_a(newPos, LittleTiles.blockTile.func_176223_P());
                        littleTe = (TileEntityLittleTiles)world.func_175625_s(newPos);
                    }
                    if (littleTe == null) break;
                    LittleTile newTile = tile.copy();
                    newTile.boundingBoxes.clear();
                    newTile.boundingBoxes.add(box);
                    newTile.te = littleTe;
                    if (!littleTe.isSpaceForLittleTile(box)) break;
                    newTile.place();
                    littleTe.updateBlock();
                    break;
                }
                case 3: {
                    if (tile.getClass() != LittleTileBlock.class && !(tile instanceof LittleTileBlockColored)) break;
                    int color = this.nbt.func_74762_e("color");
                    if (player.func_70093_af()) {
                        color = ColorUtils.WHITE;
                        if (tile instanceof LittleTileBlockColored) {
                            color = ((LittleTileBlockColored)tile).color;
                        }
                        ItemColorTube.setColor(player.func_184614_ca(), color);
                        break;
                    }
                    LittleTileBlock newTile = LittleTileBlockColored.setColor((LittleTileBlock)tile, color);
                    if (newTile != null) {
                        tile.te.removeTile(tile);
                        tile.te.addTile(newTile);
                    }
                    if (tile.isStructureBlock) {
                        newTile.isStructureBlock = true;
                        newTile.structure.getTiles().remove(tile);
                        newTile.structure.getTiles().add(newTile);
                        if (tile.isMainBlock) {
                            newTile.structure.setMainTile(newTile);
                        }
                        newTile.structure.getMainTile().te.updateBlock();
                    }
                    te.updateBlock();
                    break;
                }
                case 4: {
                    int side = this.nbt.func_74762_e("side");
                    EnumFacing direction = EnumFacing.func_82600_a((int)side).func_176734_d();
                    if (player.func_70093_af()) {
                        direction = direction.func_176734_d();
                    }
                    if (!tile.canBeMoved(direction)) break;
                    if (tile.isStructureBlock) {
                        if (!tile.checkForStructure()) break;
                        LittleStructure structure = tile.structure;
                        if (structure.hasLoaded()) {
                            int i;
                            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>(structure.getTiles());
                            for (i = 0; i < tiles.size(); ++i) {
                                if (ItemRubberMallet.moveTile(tiles.get((int)i).te, direction, tiles.get(i), true)) continue;
                                return;
                            }
                            for (i = 0; i < tiles.size(); ++i) {
                                ItemRubberMallet.moveTile(tiles.get((int)i).te, direction, tiles.get(i), false);
                            }
                            structure.combineTiles();
                            structure.selectMainTile();
                            structure.moveStructure(direction);
                            break;
                        }
                        player.func_145747_a((ITextComponent)new TextComponentString("Cannot move structure (not all tiles are loaded)."));
                        break;
                    }
                    if (!ItemRubberMallet.moveTile(te, direction, tile, false)) break;
                    te.updateTiles();
                    break;
                }
                case 5: {
                    if (stack == null || stack.func_77973_b() != Items.field_151114_aO || !player.func_70093_af()) break;
                    if (!player.func_184812_l_()) {
                        if (tile.glowing) {
                            if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151114_aO))) {
                                player.func_71019_a(new ItemStack(Items.field_151114_aO), true);
                            }
                        } else {
                            --stack.field_77994_a;
                            if (stack.field_77994_a <= 0) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            }
                        }
                    }
                    if (tile.glowing) {
                        player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
                    } else {
                        player.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
                    }
                    tile.glowing = !tile.glowing;
                    te.updateLighting();
                }
            }
        }
    }
}

