/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoorInteractPacket
extends CreativeCorePacket {
    public BlockPos blockPos;
    public Rotation direction;
    public boolean inverse;
    public Vec3d pos;
    public Vec3d look;
    public UUID uuid;

    public LittleDoorInteractPacket() {
    }

    public LittleDoorInteractPacket(BlockPos blockPos, EntityPlayer player, Rotation rotation, boolean inverse, UUID uuid) {
        this.blockPos = blockPos;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        this.direction = rotation;
        this.inverse = inverse;
        this.uuid = uuid;
    }

    public void writeBytes(ByteBuf buf) {
        LittleDoorInteractPacket.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleDoorInteractPacket.writeVec3d((Vec3d)this.pos, (ByteBuf)buf);
        LittleDoorInteractPacket.writeVec3d((Vec3d)this.look, (ByteBuf)buf);
        buf.writeInt(this.direction.ordinal());
        buf.writeBoolean(this.inverse);
        LittleDoorInteractPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleDoorInteractPacket.readPos((ByteBuf)buf);
        this.pos = LittleDoorInteractPacket.readVec3d((ByteBuf)buf);
        this.look = LittleDoorInteractPacket.readVec3d((ByteBuf)buf);
        this.direction = Rotation.values()[buf.readInt()];
        this.inverse = buf.readBoolean();
        this.uuid = UUID.fromString(LittleDoorInteractPacket.readString((ByteBuf)buf));
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        TileEntityLittleTiles te;
        LittleTile tile;
        TileEntity tileEntity = player.field_70170_p.func_175625_s(this.blockPos);
        World world = player.field_70170_p;
        if (tileEntity instanceof TileEntityLittleTiles && (tile = (te = (TileEntityLittleTiles)tileEntity).getFocusedTile(this.pos, this.look)) != null && tile.isLoaded() && tile.structure instanceof LittleDoor) {
            ((LittleDoor)tile.structure).interactWithDoor(world, player, this.direction, this.inverse, this.uuid);
        }
    }
}

