/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittlePlacePacket
extends CreativeCorePacket {
    public Vec3d hitVec;
    public Vec3d playerPos;
    public BlockPos pos;
    public EnumFacing side;
    public boolean customPlacement;
    public boolean isSneaking;
    public boolean forced;

    public LittlePlacePacket() {
    }

    public LittlePlacePacket(Vec3d playerPos, Vec3d hitVec, BlockPos pos, EnumFacing side, boolean customPlacement, boolean isSneaking, boolean forced) {
        this.playerPos = playerPos;
        this.hitVec = hitVec;
        this.pos = pos;
        this.side = side;
        this.customPlacement = customPlacement;
        this.isSneaking = isSneaking;
        this.forced = forced;
    }

    public void writeBytes(ByteBuf buf) {
        LittlePlacePacket.writeVec3d((Vec3d)this.playerPos, (ByteBuf)buf);
        LittlePlacePacket.writeVec3d((Vec3d)this.hitVec, (ByteBuf)buf);
        LittlePlacePacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
        LittlePlacePacket.writeFacing((ByteBuf)buf, (EnumFacing)this.side);
        buf.writeBoolean(this.customPlacement);
        buf.writeBoolean(this.isSneaking);
        buf.writeBoolean(this.forced);
    }

    public void readBytes(ByteBuf buf) {
        this.playerPos = LittlePlacePacket.readVec3d((ByteBuf)buf);
        this.hitVec = LittlePlacePacket.readVec3d((ByteBuf)buf);
        this.pos = LittlePlacePacket.readPos((ByteBuf)buf);
        this.side = LittlePlacePacket.readFacing((ByteBuf)buf);
        this.customPlacement = buf.readBoolean();
        this.isSneaking = buf.readBoolean();
        this.forced = buf.readBoolean();
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (PlacementHelper.isLittleBlock(stack)) {
            PlacementHelper helper = PlacementHelper.getInstance(player);
            ((ItemBlockTiles)Item.func_150898_a((Block)LittleTiles.blockTile)).placeBlockAt(player, stack, player.field_70170_p, this.playerPos, this.hitVec, helper, this.pos, this.side, this.customPlacement, this.isSneaking, this.forced);
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
        }
    }
}

