/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.packet.LittleBedPacket;
import com.creativemd.littletiles.common.structure.LittleSlidingDoor;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class LittleBed
extends LittleStructure {
    public EntityPlayer sleepingPlayer = null;
    public EnumFacing direction;
    @SideOnly(value=Side.CLIENT)
    public boolean hasBeenActivated;
    public static Method setSize = ReflectionHelper.findMethod(Entity.class, null, (String[])new String[]{"setSize", "func_70105_a"}, (Class[])new Class[]{Float.TYPE, Float.TYPE});
    public static Field sleeping = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleeping", "field_71083_bS"});
    public static Field sleepTimer = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleepTimer", "field_71076_b"});
    public static Field littleBed = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"littleBed"});

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.direction = EnumFacing.func_176731_b((int)nbt.func_74762_e("direction"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("direction", this.direction.func_176736_b());
    }

    @SideOnly(value=Side.CLIENT)
    @CustomEventSubscribe
    public void buttonClicked(GuiControlClickEvent event) {
        if (event.source.parent instanceof SubGuiStructure) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)event.source.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_176731_b((int)((GuiStateButton)event.source.parent.get("direction")).getState());
            LittleSlidingDoor.updateDirection(viewer, direction, relativeDirection);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, ((SubGuiStructure)gui).stack);
        tile.viewDirection = EnumFacing.UP;
        gui.addControl((GuiControl)tile);
        LittleTileSize size = ItemRecipe.getSize(((SubGuiStructure)gui).stack);
        int index = EnumFacing.EAST.func_176736_b();
        if (size.sizeX < size.sizeZ) {
            index = EnumFacing.SOUTH.func_176736_b();
        }
        if (structure instanceof LittleBed) {
            index = ((LittleBed)structure).direction.func_176736_b();
        }
        gui.addControl((GuiControl)new GuiStateButton("direction", index, 110, 30, 37, RotationUtils.getHorizontalFacingNames()));
        GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 30, EnumFacing.UP);
        gui.addControl((GuiControl)relativeDirection);
        LittleSlidingDoor.updateDirection(tile, EnumFacing.func_176731_b((int)index), relativeDirection);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleStructure parseStructure(SubGui gui) {
        EnumFacing direction = EnumFacing.func_176731_b((int)((GuiStateButton)gui.get("direction")).getState());
        LittleBed bed = new LittleBed();
        bed.direction = direction;
        return bed;
    }

    @Override
    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getBedOrientationInDegrees(EntityPlayer player) {
        IBlockState state;
        try {
            LittleStructure bed = (LittleStructure)littleBed.get(player);
            if (bed instanceof LittleBed) {
                switch (((LittleBed)bed).direction) {
                    case SOUTH: {
                        return 90.0f;
                    }
                    case WEST: {
                        return 0.0f;
                    }
                    case NORTH: {
                        return 270.0f;
                    }
                    case EAST: {
                        return 180.0f;
                    }
                }
                return 0.0f;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        IBlockState iBlockState = state = player.field_71081_bT == null ? null : player.field_70170_p.func_180495_p(player.field_71081_bT);
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, player.field_71081_bT, (Entity)player)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)player.field_70170_p, player.field_71081_bT);
            switch (enumfacing) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    public EntityPlayer.SleepResult trySleep(EntityPlayer player, LittleTileVec highest) {
        BlockPos center = highest.getBlockPos();
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!player.field_70170_p.field_73011_w.func_76569_d()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            if (player.field_70170_p.func_72935_r()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = player.field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB((double)center.func_177958_n() - 8.0, (double)center.func_177956_o() - 5.0, (double)center.func_177952_p() - 8.0, (double)center.func_177958_n() + 8.0, (double)center.func_177956_o() + 5.0, (double)center.func_177952_p() + 8.0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        this.sleepingPlayer = player;
        try {
            littleBed.set(player, this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        try {
            setSize.invoke((Object)player, Float.valueOf(0.2f), Float.valueOf(0.2f));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        float f1 = 0.5f + (float)this.direction.func_82601_c() * 0.8f;
        float f = 0.5f + (float)this.direction.func_82599_e() * 0.8f;
        player.field_71079_bU = -1.8f * (float)this.direction.func_82601_c();
        player.field_71089_bV = -1.8f * (float)this.direction.func_82599_e();
        player.func_70107_b((double)((float)highest.getPosX() - 0.5f + f1), (double)((float)highest.getPosY() + 0.6875f - 0.5f), (double)((float)highest.getPosZ() - 0.5f + f));
        try {
            sleeping.setBoolean(player, true);
            sleepTimer.setInt(player, 0);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        player.field_71081_bT = this.getMainTile().te.func_174877_v();
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    @Override
    public void onLittleTileDestory() {
        super.onLittleTileDestory();
        if (this.sleepingPlayer != null) {
            try {
                littleBed.set(this.sleepingPlayer, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setBedDirection(Entity player) {
        if (player instanceof EntityPlayer) {
            try {
                LittleStructure bed = (LittleStructure)littleBed.get(player);
                if (bed instanceof LittleBed) {
                    int i = ((LittleBed)bed).direction.func_176736_b();
                    GL11.glRotatef((float)(i * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            this.hasBeenActivated = true;
            return true;
        }
        if (world.field_73011_w.func_76567_e() && world.func_180494_b(pos) != Biomes.field_76778_j) {
            LittleTileVec vec = this.getHighestCenterPoint();
            if (this.sleepingPlayer != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]));
                return true;
            }
            EntityPlayer.SleepResult enumstatus = this.trySleep(player, vec);
            if (enumstatus == EntityPlayer.SleepResult.OK) {
                player.func_71029_a(StatList.field_188064_ad);
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleBedPacket(pos, this.getMainTile().cornerVec), (EntityPlayerMP)((EntityPlayerMP)player));
                PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleBedPacket(pos, this.getMainTile().cornerVec, player), (EntityPlayerMP)((EntityPlayerMP)player));
                return true;
            }
            if (enumstatus == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]));
            } else if (enumstatus == EntityPlayer.SleepResult.NOT_SAFE) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return true;
        }
        return true;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        if (direction.func_176740_k() == this.direction.func_176740_k()) {
            this.direction = this.direction.func_176734_d();
        }
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        this.direction = RotationUtils.rotateFacing((EnumFacing)this.direction, (EnumFacing)direction);
    }
}

