/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiIDButton;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.packet.LittleDoorInteractPacket;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.PlacePreviewTileAxis;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.rotation.OrdinaryDoorTransformation;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoor
extends LittleDoorBase {
    public EnumFacing normalDirection;
    public EnumFacing.Axis axis;
    public LittleTileVec axisVec;
    public LittleTileVec lastMainTileVec = null;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        if (nbt.func_74764_b("ax")) {
            this.axisVec = new LittleTileVec("a", nbt);
            if (this.getMainTile() != null) {
                this.axisVec.subVec(this.getMainTile().cornerVec);
            }
        } else {
            this.axisVec = new LittleTileVec("av", nbt);
        }
        this.axis = RotationUtils.getAxisFromIndex((int)nbt.func_74762_e("axis"));
        this.normalDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("ndirection"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        this.axisVec.writeToNBT("av", nbt);
        nbt.func_74768_a("axis", RotationUtils.getAxisIndex((EnumFacing.Axis)this.axis));
        nbt.func_74768_a("ndirection", this.normalDirection.func_176745_a());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        super.createControls(gui, structure);
        LittleDoor door = null;
        if (structure instanceof LittleDoor) {
            door = (LittleDoor)structure;
        }
        GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, ((SubGuiStructure)gui).stack);
        if (door != null) {
            tile.axisDirection = door.axis;
            tile.axisX = door.axisVec.x;
            tile.axisY = door.axisVec.y;
            tile.axisZ = door.axisVec.z;
            tile.normalAxis = door.normalDirection.func_176740_k();
        }
        tile.visibleAxis = true;
        tile.updateViewDirection();
        gui.controls.add(tile);
        gui.controls.add(new GuiIDButton("reset view", 109, 30, 0));
        gui.controls.add(new GuiIDButton("flip view", 109, 50, 1));
        gui.controls.add(new GuiIDButton("swap axis", 109, 10, 2));
        gui.controls.add(new GuiIDButton("swap normal", 109, 70, 3));
        gui.controls.add(new GuiButton("up", "<-", 125, 91, 14){

            public void onClicked(int x, int y, int button) {
            }
        }.setRotation(90.0f));
        gui.controls.add(new GuiIDButton("->", 146, 112, 4));
        gui.controls.add(new GuiIDButton("<-", 107, 112, 5));
        gui.controls.add(new GuiButton("down", "<-", 125, 112, 14){

            public void onClicked(int x, int y, int button) {
            }
        }.setRotation(-90.0f));
    }

    @Override
    public LittleTileVec getAxisVec() {
        LittleTileVec newAxisVec = this.axisVec.copy();
        newAxisVec.addVec(this.getMainTile().getAbsoluteCoordinates());
        return newAxisVec;
    }

    @Override
    public void moveStructure(EnumFacing facing) {
        this.axisVec.addVec(new LittleTileVec(facing));
    }

    @Override
    public void setMainTile(LittleTile tile) {
        if (this.getMainTile() != null) {
            LittleTileVec oldVec = this.lastMainTileVec;
            oldVec.subVec(tile.getAbsoluteCoordinates());
            this.axisVec.addVec(oldVec);
        }
        this.lastMainTileVec = tile.getAbsoluteCoordinates().copy();
        super.setMainTile(tile);
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(GuiControlClickEvent event) {
        GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
        if (event.source.is(new String[]{"swap axis"})) {
            switch (viewer.axisDirection) {
                case X: {
                    this.axis = EnumFacing.Axis.Y;
                    break;
                }
                case Y: {
                    this.axis = EnumFacing.Axis.Z;
                    break;
                }
                case Z: {
                    this.axis = EnumFacing.Axis.X;
                    break;
                }
            }
            viewer.axisDirection = this.axis;
            viewer.updateViewDirection();
            viewer.updateNormalAxis();
        } else if (event.source.is(new String[]{"reset view"})) {
            viewer.offsetX = 0.0f;
            viewer.offsetY = 0.0f;
            viewer.scale = 5.0f;
        } else if (event.source.is(new String[]{"flip view"})) {
            viewer.viewDirection = viewer.viewDirection.func_176734_d();
            viewer.baked = null;
        } else if (event.source instanceof GuiButton) {
            if (event.source.is(new String[]{"<-"})) {
                if (viewer.axisDirection == EnumFacing.Axis.X) {
                    ++viewer.axisZ;
                } else {
                    --viewer.axisX;
                }
            }
            if (event.source.is(new String[]{"->"})) {
                if (viewer.axisDirection == EnumFacing.Axis.X) {
                    --viewer.axisZ;
                } else {
                    ++viewer.axisX;
                }
            }
            if (event.source.is(new String[]{"up"})) {
                if (viewer.axisDirection == EnumFacing.Axis.Y) {
                    --viewer.axisZ;
                } else {
                    ++viewer.axisY;
                }
            }
            if (event.source.is(new String[]{"down"})) {
                if (viewer.axisDirection == EnumFacing.Axis.Y) {
                    ++viewer.axisZ;
                } else {
                    --viewer.axisY;
                }
            } else if (event.source.is(new String[]{"swap normal"})) {
                viewer.changeNormalAxis();
            }
        }
    }

    @Override
    public ArrayList<PlacePreviewTile> getSpecialTiles() {
        ArrayList<PlacePreviewTile> boxes = new ArrayList<PlacePreviewTile>();
        LittleTileBox box = new LittleTileBox(this.axisVec);
        boxes.add(new PlacePreviewTileAxis(box, null, this.axis));
        return boxes;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        LittleTileBox box = new LittleTileBox(this.axisVec.x, this.axisVec.y, this.axisVec.z, this.axisVec.x + 1, this.axisVec.y + 1, this.axisVec.z + 1);
        box.flipBoxWithCenter(direction, null);
        this.axisVec = box.getMinVec();
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        LittleTileBox box = new LittleTileBox(this.axisVec.x, this.axisVec.y, this.axisVec.z, this.axisVec.x + 1, this.axisVec.y + 1, this.axisVec.z + 1);
        box.rotateBox(direction);
        this.axisVec = box.getMinVec();
        this.axis = RotationUtils.rotateFacing((EnumFacing)RotationUtils.getFacingFromAxis((EnumFacing.Axis)this.axis), (EnumFacing)direction).func_176740_k();
        this.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (EnumFacing)direction);
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, BlockPos pos, Rotation direction, boolean inverse, UUID uuid) {
        ArrayList<LittleTile> tiles = this.getTiles();
        ArrayList<PlacePreviewTile> defaultpreviews = new ArrayList<PlacePreviewTile>();
        LittleTileVec axisPoint = this.getAxisVec();
        LittleTileVec invaxis = axisPoint.copy();
        invaxis.invert();
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTile tileOfList = tiles.get(i);
            NBTTagCompound nbt = new NBTTagCompound();
            LittleTilePreview preview = tileOfList.getPreviewTile();
            preview.box.addOffset(new LittleTileVec((Vec3i)tileOfList.te.func_174877_v()));
            preview.box.addOffset(invaxis);
            preview.rotatePreview(direction);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, new LittleTileVec(0, 0, 0)));
        }
        defaultpreviews.add(new PlacePreviewTileAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), null, this.axis));
        LittleTileVec internalOffset = new LittleTileVec(axisPoint.x - pos.func_177958_n() * LittleTile.gridSize, axisPoint.y - pos.func_177956_o() * LittleTile.gridSize, axisPoint.z - pos.func_177952_p() * LittleTile.gridSize);
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        for (int i = 0; i < defaultpreviews.size(); ++i) {
            PlacePreviewTile box = (PlacePreviewTile)defaultpreviews.get(i);
            box.box.addOffset(internalOffset);
            previews.add(box);
        }
        LittleDoor structure = new LittleDoor();
        structure.axisVec = new LittleTileVec(0, 0, 0);
        structure.setTiles(new ArrayList<LittleTile>());
        structure.axis = this.axis;
        EnumFacing rotationAxis = RotationUtils.getFacingFromAxis((EnumFacing.Axis)this.axis);
        if (inverse) {
            rotationAxis = rotationAxis.func_176734_d();
        }
        structure.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (EnumFacing)rotationAxis);
        structure.duration = this.duration;
        return this.place(world, structure, player, previews, pos, new OrdinaryDoorTransformation(direction), uuid);
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && this.axis != null && !this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]));
                return true;
            }
            Rotation rotation = Rotation.EAST;
            double playerRotation = MathHelper.func_76142_g((float)player.field_70177_z);
            boolean rotX = playerRotation <= -90.0 || playerRotation >= 90.0;
            boolean rotY = player.field_70125_A > 0.0f;
            boolean rotZ = playerRotation > 0.0 && playerRotation <= 180.0;
            boolean inverse = false;
            switch (this.axis) {
                case X: {
                    rotation = Rotation.UPX;
                    switch (this.normalDirection) {
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case SOUTH: {
                            if (rotX) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                        case NORTH: {
                            if (!rotX) break;
                            rotation = Rotation.DOWNX;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.UPX;
                    break;
                }
                case Y: {
                    rotation = Rotation.SOUTH;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotX) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case WEST: {
                            if (rotX) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case SOUTH: {
                            if (rotZ) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                        case NORTH: {
                            if (!rotZ) break;
                            rotation = Rotation.NORTH;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.SOUTH;
                    break;
                }
                case Z: {
                    rotation = Rotation.UP;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotZ) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case WEST: {
                            if (rotZ) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.DOWN;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.UP;
                    break;
                }
            }
            UUID uuid = UUID.randomUUID();
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleDoorInteractPacket(pos, player, rotation, inverse, uuid));
            this.interactWithDoor(world, player, rotation, inverse, uuid);
        }
        return true;
    }

    public boolean interactWithDoor(World world, EntityPlayer player, Rotation rotation, boolean inverse, UUID uuid) {
        int i;
        ArrayList<LittleTile> tiles = this.getTiles();
        LittleTileVec axisPoint = this.getAxisVec();
        int mainX = axisPoint.x / LittleTile.gridSize;
        int mainY = axisPoint.y / LittleTile.gridSize;
        int mainZ = axisPoint.z / LittleTile.gridSize;
        for (i = 0; i < tiles.size(); ++i) {
            tiles.get((int)i).te.removeTile(tiles.get(i));
        }
        if (this.tryToPlacePreviews(world, player, new BlockPos(mainX, mainY, mainZ), rotation, !inverse, uuid)) {
            return true;
        }
        if (this.tryToPlacePreviews(world, player, new BlockPos(mainX, mainY, mainZ), rotation.getOpposite(), inverse, uuid)) {
            return true;
        }
        for (i = 0; i < tiles.size(); ++i) {
            tiles.get((int)i).te.addTile(tiles.get(i));
        }
        return false;
    }

    public void updateNormalDirection() {
        switch (this.axis) {
            case X: {
                this.normalDirection = RotationUtils.getFacingFromAxis((EnumFacing.Axis)EnumFacing.Axis.Z);
                break;
            }
            case Y: {
                this.normalDirection = RotationUtils.getFacingFromAxis((EnumFacing.Axis)EnumFacing.Axis.X);
                break;
            }
            case Z: {
                this.normalDirection = RotationUtils.getFacingFromAxis((EnumFacing.Axis)EnumFacing.Axis.Y);
                break;
            }
        }
    }

    @Override
    public void writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        LittleTileVec axisPointBackup = this.axisVec.copy();
        this.axisVec.subVec(new LittleTileVec((Vec3i)newCenter));
        this.axisVec.addVec(new LittleTileVec((Vec3i)this.getMainTile().te.func_174877_v()));
        this.axisVec.addVec(this.getMainTile().cornerVec);
        super.writeToNBTPreview(nbt, newCenter);
        this.axisVec = axisPointBackup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleDoorBase parseStructure(SubGui gui, int duration) {
        LittleDoor door = new LittleDoor();
        GuiTileViewer viewer = (GuiTileViewer)gui.get("tileviewer");
        door.axisVec = new LittleTileVec(viewer.axisX, viewer.axisY, viewer.axisZ);
        door.axis = viewer.axisDirection;
        door.normalDirection = RotationUtils.getFacingFromAxis((EnumFacing.Axis)viewer.normalAxis);
        door.duration = duration;
        return door;
    }

    @Override
    public LittleDoorBase copyToPlaceDoor() {
        LittleDoor structure = new LittleDoor();
        structure.axisVec = new LittleTileVec(0, 0, 0);
        structure.setTiles(new ArrayList<LittleTile>());
        structure.axis = this.axis;
        structure.normalDirection = this.normalDirection;
        structure.duration = this.duration;
        return structure;
    }

    @Override
    public ArrayList<PlacePreviewTile> getAdditionalPreviews() {
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        previews.add(new PlacePreviewTileAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), null, this.axis));
        return previews;
    }
}

