/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiIDButton;
import com.creativemd.creativecore.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.packet.LittleSlidingDoorPacket;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.rotation.SlidingDoorTransformation;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSlidingDoor
extends LittleDoorBase {
    public EnumFacing moveDirection;
    public int moveDistance;
    public LittleTileVec placedAxis;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.moveDistance = nbt.func_74762_e("distance");
        this.moveDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        if (nbt.func_74764_b("placedAxis")) {
            this.placedAxis = new LittleTileVec("placedAxis", nbt);
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("distance", this.moveDistance);
        nbt.func_74768_a("direction", this.moveDirection.func_176745_a());
        if (this.placedAxis != null) {
            this.placedAxis.writeToNBT("placedAxis", nbt);
        }
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.isWaitingForApprove = false;
        if (world.field_72995_K && !this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]));
                return true;
            }
            UUID uuid = UUID.randomUUID();
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleSlidingDoorPacket(pos, player, uuid));
            this.interactWithDoor(world, pos, player, uuid);
        }
        return true;
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, BlockPos pos, UUID uuid) {
        ArrayList<LittleTile> tiles = this.getTiles();
        ArrayList<PlacePreviewTile> defaultpreviews = new ArrayList<PlacePreviewTile>();
        this.placedAxis = new LittleTileVec((Vec3i)pos);
        LittleTileVec invaxis = this.placedAxis.copy();
        invaxis.invert();
        LittleTileVec offset = new LittleTileVec(this.moveDirection);
        offset.scale(this.moveDistance);
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTile tileOfList = tiles.get(i);
            NBTTagCompound nbt = new NBTTagCompound();
            LittleTilePreview preview = tileOfList.getPreviewTile();
            preview.box.addOffset(new LittleTileVec((Vec3i)tileOfList.te.func_174877_v()));
            preview.box.addOffset(invaxis);
            preview.box.addOffset(offset);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, new LittleTileVec(0, 0, 0)));
        }
        LittleTileVec internalOffset = new LittleTileVec(this.placedAxis.x - pos.func_177958_n() * LittleTile.gridSize, this.placedAxis.y - pos.func_177956_o() * LittleTile.gridSize, this.placedAxis.z - pos.func_177952_p() * LittleTile.gridSize);
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        for (int i = 0; i < defaultpreviews.size(); ++i) {
            PlacePreviewTile box = (PlacePreviewTile)defaultpreviews.get(i);
            box.box.addOffset(internalOffset);
            previews.add(box);
        }
        LittleSlidingDoor structure = new LittleSlidingDoor();
        structure.placedAxis = this.placedAxis;
        structure.duration = this.duration;
        structure.moveDirection = this.moveDirection.func_176734_d();
        structure.moveDistance = this.moveDistance;
        structure.setTiles(new ArrayList<LittleTile>());
        return this.place(world, structure, player, previews, pos, new SlidingDoorTransformation(this.moveDirection, this.moveDistance), uuid);
    }

    public boolean interactWithDoor(World world, BlockPos pos, EntityPlayer player, UUID uuid) {
        int i;
        ArrayList<LittleTile> tiles = this.getTiles();
        for (i = 0; i < tiles.size(); ++i) {
            tiles.get((int)i).te.removeTile(tiles.get(i));
        }
        if (this.tryToPlacePreviews(world, player, pos, uuid)) {
            return true;
        }
        for (i = 0; i < tiles.size(); ++i) {
            tiles.get((int)i).te.addTile(tiles.get(i));
        }
        return false;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        if (direction.func_176740_k() == this.moveDirection.func_176740_k()) {
            this.moveDirection = this.moveDirection.func_176734_d();
        }
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
        this.moveDirection = RotationUtils.rotateFacing((EnumFacing)this.moveDirection, (EnumFacing)direction);
    }

    @Override
    public LittleTileVec getAxisVec() {
        return this.placedAxis;
    }

    @Override
    public ArrayList<PlacePreviewTile> getAdditionalPreviews() {
        return new ArrayList<PlacePreviewTile>();
    }

    @SideOnly(value=Side.CLIENT)
    @CustomEventSubscribe
    public void buttonClicked(GuiControlClickEvent event) {
        if (event.source.is(new String[]{"direction"})) {
            SubGuiStructure gui = (SubGuiStructure)event.source.parent;
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)event.source).getState());
            GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("distance");
            LittleTileSize size = ItemRecipe.getSize(gui.stack);
            slider.minValue = 1.0f;
            slider.maxValue = size.getSizeOfAxis(direction.func_176740_k()) + 1;
            slider.value = gui.structure instanceof LittleSlidingDoor && ((LittleSlidingDoor)gui.structure).moveDirection == direction ? (float)((LittleSlidingDoor)gui.structure).moveDistance : slider.maxValue - 1.0f;
        }
        GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
        if (event.source.is(new String[]{"change view"})) {
            switch (viewer.axisDirection) {
                case X: {
                    viewer.axisDirection = EnumFacing.Axis.Y;
                    break;
                }
                case Y: {
                    viewer.axisDirection = EnumFacing.Axis.Z;
                    break;
                }
                case Z: {
                    viewer.axisDirection = EnumFacing.Axis.X;
                    break;
                }
            }
            viewer.updateViewDirection();
            viewer.updateNormalAxis();
        } else if (event.source.is(new String[]{"reset view"})) {
            viewer.offsetX = 0.0f;
            viewer.offsetY = 0.0f;
            viewer.scale = 5.0f;
        } else if (event.source.is(new String[]{"flip view"})) {
            viewer.viewDirection = viewer.viewDirection.func_176734_d();
            viewer.baked = null;
        }
        if (event.source.parent instanceof SubGuiStructure) {
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)event.source.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)event.source.parent.get("direction")).getState());
            LittleSlidingDoor.updateDirection(viewer, direction, relativeDirection);
        }
    }

    public static void updateDirection(GuiTileViewer viewer, EnumFacing direction, GuiDirectionIndicator relativeDirection) {
        EnumFacing newDirection = EnumFacing.EAST;
        if (viewer.getXFacing().func_176740_k() == direction.func_176740_k()) {
            newDirection = viewer.getXFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.EAST : EnumFacing.WEST;
        } else if (viewer.getYFacing().func_176740_k() == direction.func_176740_k()) {
            newDirection = viewer.getYFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.DOWN : EnumFacing.UP;
        } else if (viewer.getZFacing().func_176740_k() == direction.func_176740_k()) {
            newDirection = viewer.getZFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        relativeDirection.setDirection(newDirection);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        super.createControls(gui, structure);
        LittleSlidingDoor door = null;
        if (structure instanceof LittleSlidingDoor) {
            door = (LittleSlidingDoor)structure;
        }
        LittleTileSize size = ItemRecipe.getSize(((SubGuiStructure)gui).stack);
        int index = EnumFacing.UP.ordinal();
        if (door != null) {
            index = door.moveDirection.ordinal();
        }
        gui.addControl((GuiControl)new GuiStateButton("direction", index, 110, 30, 37, RotationUtils.getFacingNames()));
        GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 30, EnumFacing.UP);
        gui.addControl((GuiControl)relativeDirection);
        int distance = size.getSizeOfAxis(EnumFacing.func_82600_a((int)index).func_176740_k());
        if (door != null) {
            distance = door.moveDistance;
        }
        gui.addControl((GuiControl)new GuiSteppedSlider("distance", 110, 51, 60, 14, distance, 1, size.getSizeOfAxis(EnumFacing.func_82600_a((int)index).func_176740_k()) + 1));
        gui.addControl((GuiControl)new GuiIDButton("reset view", 110, 75, 0));
        gui.addControl((GuiControl)new GuiIDButton("change view", 110, 95, 1));
        gui.addControl((GuiControl)new GuiIDButton("flip view", 110, 115, 1));
        GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, ((SubGuiStructure)gui).stack);
        tile.visibleAxis = false;
        tile.updateViewDirection();
        gui.addControl((GuiControl)tile);
        LittleSlidingDoor.updateDirection(tile, EnumFacing.func_82600_a((int)index), relativeDirection);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleDoorBase parseStructure(SubGui gui, int duration) {
        EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)gui.get("direction")).getState());
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("distance");
        LittleSlidingDoor door = new LittleSlidingDoor();
        door.duration = duration;
        door.moveDirection = direction;
        door.moveDistance = (int)slider.value;
        return door;
    }

    @Override
    public LittleDoorBase copyToPlaceDoor() {
        LittleSlidingDoor structure = new LittleSlidingDoor();
        structure.setTiles(new ArrayList<LittleTile>());
        structure.moveDirection = this.moveDirection;
        structure.moveDistance = this.moveDistance;
        structure.duration = this.duration;
        return structure;
    }
}

