/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.ColoredCube;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PreviewTileAxis
extends PlacePreviewTile {
    public static Vec3d red = new Vec3d(1.0, 0.0, 0.0);
    public EnumFacing.Axis axis;

    public PreviewTileAxis(LittleTileBox box, LittleTilePreview preview, EnumFacing.Axis axis) {
        super(box, preview);
        this.axis = axis;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public PlacePreviewTile copy() {
        return new PreviewTileAxis(this.box.copy(), null, this.axis);
    }

    @Override
    public ArrayList<ColoredCube> getPreviews() {
        ArrayList<ColoredCube> cubes = new ArrayList<ColoredCube>();
        LittleTileBox preview = this.box.copy();
        int max = 40 * LittleTile.gridSize;
        int min = -max;
        switch (this.axis) {
            case X: {
                preview.minX = min;
                preview.maxX = max;
                break;
            }
            case Y: {
                preview.minY = min;
                preview.maxY = max;
                break;
            }
            case Z: {
                preview.minZ = min;
                preview.maxZ = max;
                break;
            }
        }
        cubes.add(new ColoredCube(preview.getCube(), red));
        return cubes;
    }

    @Override
    public LittleTile placeTile(EntityPlayer player, ItemStack stack, BlockPos pos, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing) {
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            door.axisVec = this.box.getMinVec();
            door.axisVec.addVec(new LittleTileVec((Vec3i)pos));
            if (door.getMainTile() == null) {
                door.selectMainTile();
            }
            if (door.getMainTile() != null) {
                door.axisVec.subVec(door.getMainTile().getAbsoluteCoordinates());
            }
        }
        return null;
    }
}

