/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.client.rendering.RenderCubeLayerCache;
import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLittleTiles
extends TileEntityCreative
implements ITickable {
    private CopyOnWriteArrayList<LittleTile> tiles = TileEntityLittleTiles.createTileList();
    private CopyOnWriteArrayList<LittleTile> updateTiles = TileEntityLittleTiles.createTileList();
    @SideOnly(value=Side.CLIENT)
    private CopyOnWriteArrayList<LittleTile> renderTiles;
    private boolean hasLoaded = false;
    @SideOnly(value=Side.CLIENT)
    public int renderIndex;
    @SideOnly(value=Side.CLIENT)
    public boolean hasLightChanged;
    @SideOnly(value=Side.CLIENT)
    public boolean hasNeighborChanged;
    public int collisionChecks = 0;
    @SideOnly(value=Side.CLIENT)
    public EntityAnimation waitingAnimation;
    @SideOnly(value=Side.CLIENT)
    private AtomicBoolean hasBeenAddedToBuffer;
    @SideOnly(value=Side.CLIENT)
    public RenderChunk lastRenderedChunk;
    @SideOnly(value=Side.CLIENT)
    private AtomicReference<BlockLayerRenderBuffer> buffer;
    @SideOnly(value=Side.CLIENT)
    private RenderCubeLayerCache cubeCache;
    @SideOnly(value=Side.CLIENT)
    public AtomicBoolean rendering;
    @SideOnly(value=Side.CLIENT)
    private double cachedRenderDistance;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB cachedRenderBoundingBox;
    public boolean needFullUpdate = true;
    public boolean preventUpdate = false;

    public static CopyOnWriteArrayList<LittleTile> createTileList() {
        return new CopyOnWriteArrayList<LittleTile>();
    }

    @SideOnly(value=Side.CLIENT)
    public CopyOnWriteArrayList<LittleTile> getRenderTiles() {
        if (this.renderTiles == null) {
            this.renderTiles = TileEntityLittleTiles.createTileList();
        }
        return this.renderTiles;
    }

    public CopyOnWriteArrayList<LittleTile> getTiles() {
        return this.tiles;
    }

    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    public void setLoaded() {
        this.hasLoaded = true;
    }

    public boolean shouldCheckForCollision() {
        return this.collisionChecks > 0;
    }

    public AtomicBoolean getBeenAddedToBuffer() {
        if (this.hasBeenAddedToBuffer == null) {
            this.hasBeenAddedToBuffer = new AtomicBoolean(false);
        }
        return this.hasBeenAddedToBuffer;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuadCache(RenderChunk chunk) {
        this.lastRenderedChunk = chunk;
        this.getBeenAddedToBuffer().set(false);
        if (this.renderIndex != LittleChunkDispatcher.currentRenderIndex.get()) {
            this.getCubeCache().clearCache();
        }
        if (this.waitingAnimation != null && !this.getCubeCache().doesNeedUpdate()) {
            this.waitingAnimation.removeWaitingTe(this);
            this.waitingAnimation = null;
        }
        boolean doesNeedUpdate = this.getCubeCache().doesNeedUpdate() || this.hasNeighborChanged || this.hasLightChanged;
        this.hasLightChanged = false;
        if (doesNeedUpdate) {
            this.addToRenderUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setBuffer(BlockLayerRenderBuffer buffer) {
        if (this.buffer == null) {
            this.buffer = new AtomicReference<BlockLayerRenderBuffer>(buffer);
        } else {
            this.buffer.set(buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockLayerRenderBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new AtomicReference<Object>(null);
        }
        return this.buffer.get();
    }

    public RenderCubeLayerCache getCubeCache() {
        if (this.cubeCache == null) {
            this.cubeCache = new RenderCubeLayerCache();
        }
        return this.cubeCache;
    }

    private boolean removeLittleTile(LittleTile tile) {
        boolean result = this.tiles.remove(tile);
        this.updateTiles.remove(tile);
        if (this.isClientSide()) {
            this.removeLittleTileClient(tile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void removeLittleTileClient(LittleTile tile) {
        CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.getRenderTiles();
        synchronized (copyOnWriteArrayList) {
            this.getRenderTiles().remove(tile);
        }
    }

    public boolean removeTile(LittleTile tile) {
        boolean result = this.removeLittleTile(tile);
        this.updateTiles();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void addLittleTileClient(LittleTile tile) {
        if (tile.needCustomRendering()) {
            CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.getRenderTiles();
            synchronized (copyOnWriteArrayList) {
                this.getRenderTiles().add(tile);
            }
        }
    }

    private boolean addLittleTile(LittleTile tile) {
        if (this.isClientSide()) {
            this.addLittleTileClient(tile);
        }
        if (tile.shouldTick()) {
            this.updateTiles.add(tile);
        }
        return this.tiles.add(tile);
    }

    public void addTiles(ArrayList<LittleTile> tiles) {
        for (int i = 0; i < tiles.size(); ++i) {
            this.addLittleTile(tiles.get(i));
        }
        this.updateTiles();
    }

    public boolean addTile(LittleTile tile) {
        boolean result = this.addLittleTile(tile);
        this.updateTiles();
        return result;
    }

    public void updateLighting() {
        this.field_145850_b.func_175664_x(this.func_174877_v());
    }

    public void updateTiles() {
        if (this.preventUpdate) {
            return;
        }
        this.updateCollisionCache();
        if (this.field_145850_b != null) {
            this.updateBlock();
            this.updateNeighbor();
            this.updateLighting();
        }
        if (this.isClientSide()) {
            this.updateCustomRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateCustomRenderer() {
        this.updateRenderBoundingBox();
        this.updateRenderDistance();
        this.getCubeCache().clearCache();
        this.addToRenderUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public void onNeighBorChangedClient() {
        this.addToRenderUpdate();
        this.hasNeighborChanged = true;
        this.updateRender();
    }

    @SideOnly(value=Side.CLIENT)
    public void addToRenderUpdate() {
        if (this.rendering == null) {
            this.rendering = new AtomicBoolean(false);
        }
        if (!this.rendering.get()) {
            RenderingThread.addCoordToUpdate(this);
        }
    }

    public boolean isBoxFilled(LittleTileBox box) {
        LittleTileSize size = box.getSize();
        boolean[][][] filled = new boolean[size.sizeX][size.sizeY][size.sizeZ];
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                LittleTileBox otherBox = tile.boundingBoxes.get(j);
                int minX = Math.max(box.minX, otherBox.minX);
                int maxX = Math.min(box.maxX, otherBox.maxX);
                int minY = Math.max(box.minY, otherBox.minY);
                int maxY = Math.min(box.maxY, otherBox.maxY);
                int minZ = Math.max(box.minZ, otherBox.minZ);
                int maxZ = Math.min(box.maxZ, otherBox.maxZ);
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        for (int z = minZ; z < maxZ; ++z) {
                            filled[x - box.minX][y - box.minY][z - box.minZ] = true;
                        }
                    }
                }
            }
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbor() {
        for (LittleTile tile : this.updateTiles) {
            tile.onNeighborChangeInside();
        }
        if (this.isClientSide()) {
            this.hasNeighborChanged = true;
        }
        this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)LittleTiles.blockTile);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.getRenderTiles().size() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderDistance() {
        this.cachedRenderDistance = 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 262144.0;
            for (LittleTile tile : this.getRenderTiles()) {
                renderDistance = Math.max(renderDistance, tile.getMaxRenderDistanceSquared());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderBoundingBox() {
        this.cachedRenderBoundingBox = null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double maxY = Double.MIN_VALUE;
            double maxZ = Double.MIN_VALUE;
            boolean found = false;
            for (LittleTile tile : this.tiles) {
                if (!tile.needCustomRendering()) continue;
                AxisAlignedBB box = tile.getRenderBoundingBox().func_186670_a(this.field_174879_c);
                minX = Math.min(box.field_72340_a, minX);
                minY = Math.min(box.field_72338_b, minY);
                minZ = Math.min(box.field_72339_c, minZ);
                maxX = Math.max(box.field_72336_d, maxX);
                maxY = Math.max(box.field_72337_e, maxY);
                maxZ = Math.max(box.field_72334_f, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ) : new AxisAlignedBB(this.field_174879_c);
        }
        return this.cachedRenderBoundingBox;
    }

    public LittleTile getTileFromPosition(int x, int y, int z) {
        LittleTileBox box = new LittleTileBox(new LittleTileVec(x, y, z));
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                if (!box.intersectsWith(tile.boundingBoxes.get(j))) continue;
                return tile;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing facing, LittleTileBox box, LittleTile rendered) {
        for (int littleX = box.minX; littleX < box.maxX; ++littleX) {
            for (int littleY = box.minY; littleY < box.maxY; ++littleY) {
                for (int littleZ = box.minZ; littleZ < box.maxZ; ++littleZ) {
                    LittleTile tile = this.getTileFromPosition(littleX, littleY, littleZ);
                    if (tile != null && (tile.doesProvideSolidFace(facing) || tile.canBeRenderCombined(rendered))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSpaceForLittleTile(CubeObject cube) {
        return this.isSpaceForLittleTile(cube.getAxis());
    }

    public boolean isSpaceForLittleTile(AxisAlignedBB alignedBB, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                if (ignoreTile == tile || !alignedBB.func_72326_a(tile.boundingBoxes.get(j).getBox())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpaceForLittleTile(AxisAlignedBB alignedBB) {
        return this.isSpaceForLittleTile(alignedBB, null);
    }

    public boolean isSpaceForLittleTile(LittleTileBox box) {
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                if (!box.intersectsWith(tile.boundingBoxes.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSpaceForLittleTile(LittleTileBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                if (ignoreTile == tile || !box.intersectsWith(tile.boundingBoxes.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public LittleTile getIntersectingTile(LittleTileBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                if (ignoreTile == tile || !box.intersectsWith(tile.boundingBoxes.get(j))) continue;
                return tile;
            }
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.tiles != null) {
            this.tiles.clear();
        }
        if (this.updateTiles != null) {
            this.updateTiles.clear();
        }
        this.collisionChecks = 0;
        int count = nbt.func_74762_e("tilesCount");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = nbt.func_74775_l("t" + i);
            LittleTile tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT);
            if (tile == null) continue;
            this.addLittleTile(tile);
        }
        this.setLoaded();
        if (this.field_145850_b != null) {
            this.updateBlock();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        int i = 0;
        for (LittleTile tile : this.tiles) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            tile.saveTile(tileNBT);
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
            ++i;
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
        return nbt;
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        int i = 0;
        for (LittleTile tile : this.tiles) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            NBTTagCompound packet = new NBTTagCompound();
            tile.saveTile(tileNBT);
            tile.updatePacket(packet);
            tileNBT.func_74782_a("update", (NBTBase)packet);
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
            if (this.needFullUpdate || tile.needsFullUpdate) {
                tile.needsFullUpdate = false;
                nbt.func_74757_a("f" + i, true);
            }
            ++i;
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
        this.needFullUpdate = false;
    }

    public LittleTile getTile(LittleTileVec vec) {
        return this.getTile(vec.x, vec.y, vec.z);
    }

    public LittleTile getTile(int minX, int minY, int minZ) {
        for (LittleTile tile : this.tiles) {
            if (tile.cornerVec.x != minX || tile.cornerVec.y != minY || tile.cornerVec.z != minZ) continue;
            return tile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        ArrayList<LittleTile> exstingTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> tilesToAdd = new ArrayList<LittleTile>();
        exstingTiles.addAll(this.tiles);
        int count = nbt.func_74762_e("tilesCount");
        for (int i = 0; i < count; ++i) {
            boolean isIdentical;
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = nbt.func_74775_l("t" + i);
            LittleTile tile = this.getTile(new LittleTileVec("cVec", tileNBT));
            if (!exstingTiles.contains(tile)) {
                tile = null;
            }
            boolean fullUpdate = nbt.func_74767_n("f" + i);
            boolean bl = isIdentical = tile != null ? tile.isIdenticalToNBT(tileNBT) : false;
            if (isIdentical && !fullUpdate) {
                tile.receivePacket(tileNBT.func_74775_l("update"), net);
                exstingTiles.remove(tile);
                continue;
            }
            if (isIdentical && tile.isLoaded()) {
                tile.structure.getTiles().remove(tile);
            }
            if ((tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT)) == null) continue;
            tilesToAdd.add(tile);
        }
        CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.tiles;
        synchronized (copyOnWriteArrayList) {
            CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList2 = this.updateTiles;
            synchronized (copyOnWriteArrayList2) {
                int i;
                for (i = 0; i < exstingTiles.size(); ++i) {
                    this.removeLittleTile((LittleTile)exstingTiles.get(i));
                }
                for (i = 0; i < tilesToAdd.size(); ++i) {
                    this.addLittleTile((LittleTile)tilesToAdd.get(i));
                }
            }
        }
        this.updateTiles();
        super.onDataPacket(net, pkt);
    }

    public RayTraceResult getMoving(EntityPlayer player) {
        Object hit = null;
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.getMoving(pos, vec32);
    }

    public RayTraceResult getMoving(Vec3d pos, Vec3d look) {
        RayTraceResult hit = null;
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                RayTraceResult Temphit = tile.boundingBoxes.get(j).getBox().func_186670_a(this.func_174877_v()).func_72327_a(pos, look);
                if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
                hit = Temphit;
            }
        }
        return hit;
    }

    public LittleTile getFocusedTile(EntityPlayer player) {
        if (!this.isClientSide()) {
            return null;
        }
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.getFocusedTile(pos, vec32);
    }

    public LittleTile getFocusedTile(Vec3d pos, Vec3d look) {
        LittleTile tileFocus = null;
        RayTraceResult hit = null;
        for (LittleTile tile : this.tiles) {
            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                RayTraceResult Temphit = tile.boundingBoxes.get(j).getBox().func_186670_a(this.func_174877_v()).func_72327_a(pos, look);
                if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
                hit = Temphit;
                tileFocus = tile;
            }
        }
        return tileFocus;
    }

    public void onLoad() {
    }

    public void func_73660_a() {
        for (LittleTile tile : this.updateTiles) {
            tile.updateEntity();
        }
        if (!this.field_145850_b.field_72995_K && this.tiles.size() == 0) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }

    public void combineTiles(LittleStructure structure) {
        if (!structure.hasLoaded()) {
            return;
        }
        int size = 0;
        boolean isMainTile = false;
        while (size != this.tiles.size()) {
            size = this.tiles.size();
            int i = 0;
            while (i < this.tiles.size()) {
                if (this.tiles.get((int)i).structure != structure) {
                    ++i;
                    continue;
                }
                int j = 0;
                while (j < this.tiles.size()) {
                    if (this.tiles.get((int)j).structure != structure) {
                        ++j;
                        continue;
                    }
                    if (i != j && this.tiles.get((int)i).boundingBoxes.size() == 1 && this.tiles.get((int)j).boundingBoxes.size() == 1 && this.tiles.get(i).canBeCombined(this.tiles.get(j)) && this.tiles.get(j).canBeCombined(this.tiles.get(i))) {
                        LittleTileBox box;
                        if (this.tiles.get((int)i).isMainBlock || this.tiles.get((int)j).isMainBlock) {
                            isMainTile = true;
                        }
                        if ((box = this.tiles.get((int)i).boundingBoxes.get(0).combineBoxes(this.tiles.get((int)j).boundingBoxes.get(0))) != null) {
                            this.tiles.get((int)i).boundingBoxes.set(0, box);
                            this.tiles.get(i).combineTiles(this.tiles.get(j));
                            this.tiles.get(i).updateCorner();
                            this.tiles.remove(j);
                            if (i <= j) continue;
                            --i;
                            continue;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (isMainTile) {
            structure.selectMainTile();
        }
        this.updateTiles();
    }

    public void updateCollisionCache() {
        this.collisionChecks = 0;
        for (LittleTile tile : this.tiles) {
            if (!tile.shouldCheckForCollision()) continue;
            ++this.collisionChecks;
        }
    }

    public void combineTiles() {
        TileEntityLittleTiles.combineTilesList(this.tiles);
        this.updateBlock();
        this.updateCollisionCache();
    }

    public static void combineTilesList(List<LittleTile> tiles) {
        int size = 0;
        while (size != tiles.size()) {
            size = tiles.size();
            for (int i = 0; i < tiles.size(); ++i) {
                int j = 0;
                while (j < tiles.size()) {
                    LittleTileBox box;
                    if (i != j && tiles.get((int)i).boundingBoxes.size() == 1 && tiles.get((int)j).boundingBoxes.size() == 1 && tiles.get(i).canBeCombined(tiles.get(j)) && tiles.get(j).canBeCombined(tiles.get(i)) && (box = tiles.get((int)i).boundingBoxes.get(0).combineBoxes(tiles.get((int)j).boundingBoxes.get(0))) != null) {
                        tiles.get((int)i).boundingBoxes.set(0, box);
                        tiles.get(i).combineTiles(tiles.get(j));
                        tiles.get(i).updateCorner();
                        tiles.remove(j);
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public void removeBoxFromTiles(LittleTileBox box) {
        for (LittleTile tile : this.tiles) {
            if (tile.canBeSplitted()) {
                this.removeBoxFromTile(tile, box);
                continue;
            }
            tile.destroy();
        }
        this.combineTiles();
    }

    private void removeBoxFromTile(LittleTile loaded, LittleTileBox box) {
        int i;
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>(loaded.boundingBoxes);
        ArrayList<LittleTile> newTiles = new ArrayList<LittleTile>();
        boolean isIntersecting = false;
        for (i = 0; i < boxes.size(); ++i) {
            if (!box.intersectsWith(boxes.get(i))) continue;
            isIntersecting = true;
            LittleTileBox oldBox = boxes.get(i);
            for (int littleX = oldBox.minX; littleX < oldBox.maxX; ++littleX) {
                for (int littleY = oldBox.minY; littleY < oldBox.maxY; ++littleY) {
                    for (int littleZ = oldBox.minZ; littleZ < oldBox.maxZ; ++littleZ) {
                        LittleTileVec vec = new LittleTileVec(littleX, littleY, littleZ);
                        if (box.isVecInsideBox(vec)) continue;
                        LittleTile newTile = loaded.copy();
                        newTile.boundingBoxes.clear();
                        newTile.boundingBoxes.add(new LittleTileBox(vec));
                        newTiles.add(newTile);
                    }
                }
            }
        }
        if (isIntersecting) {
            loaded.destroy();
            TileEntityLittleTiles.combineTilesList(newTiles);
            for (i = 0; i < newTiles.size(); ++i) {
                this.addTile(newTiles.get(i));
            }
        }
    }
}

