/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleTile {
    private static HashMap<Class<? extends LittleTile>, String> tileIDs = new HashMap();
    public static int gridSize = 16;
    public static int halfGridSize = gridSize / 2;
    public static double gridMCLength = 1.0 / (double)gridSize;
    public static int minPos = 0;
    public static int maxPos = gridSize;
    public static int maxTilesPerBlock = gridSize * gridSize * gridSize;
    public static double minimumTileSize = 1.0 / (double)maxTilesPerBlock;
    public boolean needsFullUpdate = false;
    public boolean invisible = false;
    public boolean glowing = false;
    public TileEntityLittleTiles te;
    public LittleTileVec cornerVec;
    public ArrayList<LittleTileBox> boundingBoxes = new ArrayList();
    public boolean isStructureBlock = false;
    public LittleStructure structure;
    public LittleTileCoord coord;
    public boolean isMainBlock = false;
    private boolean loadingStructure = false;
    public boolean isAllowedToSearchForStructure = true;

    public static void setGridSize(int size) {
        gridSize = size;
        halfGridSize = gridSize / 2;
        gridMCLength = 1.0 / (double)gridSize;
        minPos = 0;
        maxPos = gridSize;
        maxTilesPerBlock = gridSize * gridSize * gridSize;
        minimumTileSize = 1.0 / (double)maxTilesPerBlock;
    }

    public static Class<? extends LittleTile> getClassByID(String id) {
        for (Map.Entry<Class<? extends LittleTile>, String> entry : tileIDs.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getIDByClass(Class<? extends LittleTile> LittleClass) {
        return tileIDs.get(LittleClass);
    }

    public static void registerLittleTile(Class<? extends LittleTile> LittleClass, String id) {
        tileIDs.put(LittleClass, id);
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt) {
        return LittleTile.CreateandLoadTile(te, world, nbt, false, null);
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt, boolean isPacket, NetworkManager net) {
        if (nbt.func_74764_b("tileID")) {
            if (nbt.func_74764_b("block")) {
                Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                LittleTileBox box = new LittleTileBox(new LittleTileVec("i", nbt), new LittleTileVec("a", nbt));
                box.addOffset(new LittleTileVec(halfGridSize, halfGridSize, halfGridSize));
                LittleTileBlock tile = new LittleTileBlock(block, meta);
                tile.boundingBoxes.add(box);
                tile.cornerVec = box.getMinVec();
                return tile;
            }
        } else {
            String id = nbt.func_74779_i("tID");
            Class<? extends LittleTile> TileClass = LittleTile.getClassByID(id);
            LittleTile tile = null;
            if (TileClass != null) {
                try {
                    tile = TileClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    System.out.println("Found invalid tileID=" + id);
                }
            }
            if (tile != null) {
                if (isPacket) {
                    tile.receivePacket(nbt, net);
                } else {
                    try {
                        tile.loadTile(te, nbt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }
            return tile;
        }
        return null;
    }

    public String getID() {
        return LittleTile.getIDByClass(this.getClass());
    }

    public LittleTileVec getAbsoluteCoordinates() {
        LittleTileVec coord = new LittleTileVec((Vec3i)this.te.func_174877_v());
        coord.addVec(this.cornerVec);
        return coord;
    }

    public AxisAlignedBB getSelectedBox() {
        if (this.boundingBoxes.size() > 0) {
            LittleTileBox box = this.boundingBoxes.get(0).copy();
            for (int i = 1; i < this.boundingBoxes.size(); ++i) {
                box.minX = Math.min(box.minX, this.boundingBoxes.get((int)i).minX);
                box.minY = Math.min(box.minY, this.boundingBoxes.get((int)i).minY);
                box.minZ = Math.min(box.minZ, this.boundingBoxes.get((int)i).minZ);
                box.maxX = Math.max(box.maxX, this.boundingBoxes.get((int)i).maxX);
                box.maxY = Math.max(box.maxY, this.boundingBoxes.get((int)i).maxY);
                box.maxZ = Math.max(box.maxZ, this.boundingBoxes.get((int)i).maxZ);
            }
            return box.getBox();
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public int getVolume() {
        int percent = 0;
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            percent += this.boundingBoxes.get(i).getSize().getVolume();
        }
        return percent;
    }

    public double getPercentVolume() {
        double percent = 0.0;
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            percent += this.boundingBoxes.get(i).getSize().getPercentVolume();
        }
        return percent;
    }

    public LittleTileSize getSize() {
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            LittleTileSize tempSize = this.boundingBoxes.get(i).getSize();
            size.sizeX = Math.max(size.sizeX, tempSize.sizeX);
            size.sizeY = Math.max(size.sizeY, tempSize.sizeY);
            size.sizeZ = Math.max(size.sizeZ, tempSize.sizeZ);
        }
        return size;
    }

    public boolean canBeCombined(LittleTile tile) {
        if (this.isStructureBlock != tile.isStructureBlock) {
            return false;
        }
        if (this.isStructureBlock && this.structure != tile.structure) {
            return false;
        }
        if (this.invisible != tile.invisible) {
            return false;
        }
        return this.glowing == tile.glowing;
    }

    public boolean canBeSplitted() {
        return true;
    }

    public void combineTiles(LittleTile tile) {
        if (this.isLoaded()) {
            this.structure.getTiles().remove(tile);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return !this.invisible;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        return this.invisible == tile.invisible;
    }

    public void updatePacket(NBTTagCompound nbt) {
        if (this.isLoaded() && this.isMainBlock) {
            this.structure.onUpdatePacketReceived();
        }
        nbt.func_74768_a("bSize", this.boundingBoxes.size());
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            this.boundingBoxes.get(i).writeToNBT("bBox" + i, nbt);
        }
    }

    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
        int count = nbt.func_74762_e("bSize");
        if (this.te.isClientSide()) {
            this.te.removeTile(this);
        }
        this.boundingBoxes.clear();
        for (int i = 0; i < count; ++i) {
            this.boundingBoxes.add(new LittleTileBox("bBox" + i, nbt));
        }
        if (this.te.isClientSide()) {
            this.te.addTile(this);
        }
        this.updateCorner();
    }

    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return this.getID().equals(nbt.func_74779_i("tID")) && this.glowing == nbt.func_74767_n("glowing") && this.invisible == nbt.func_74767_n("invisible");
    }

    public void saveTile(NBTTagCompound nbt) {
        this.saveTileCore(nbt);
        this.saveTileExtra(nbt);
    }

    public void saveTileExtra(NBTTagCompound nbt) {
        if (this.invisible) {
            nbt.func_74757_a("invisible", this.invisible);
        }
        if (this.glowing) {
            nbt.func_74757_a("glowing", this.glowing);
        }
    }

    public void saveTileCore(NBTTagCompound nbt) {
        nbt.func_74778_a("tID", this.getID());
        if (this.cornerVec != null) {
            this.cornerVec.writeToNBT("cVec", nbt);
        }
        nbt.func_74768_a("bSize", this.boundingBoxes.size());
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            this.boundingBoxes.get(i).writeToNBT("bBox" + i, nbt);
        }
        if (this.isStructureBlock) {
            nbt.func_74757_a("isStructure", true);
            if (this.isMainBlock) {
                nbt.func_74757_a("main", true);
                this.structure.writeToNBT(nbt);
            } else {
                this.coord.writeToNBT(nbt);
            }
        }
    }

    public void loadTile(TileEntityLittleTiles te, NBTTagCompound nbt) {
        this.te = te;
        this.loadTileCore(nbt);
        this.loadTileExtra(nbt);
    }

    public void loadTileExtra(NBTTagCompound nbt) {
        this.invisible = nbt.func_74767_n("invisible");
        this.glowing = nbt.func_74767_n("glowing");
    }

    public void loadTileCore(NBTTagCompound nbt) {
        this.cornerVec = new LittleTileVec("cVec", nbt);
        int count = nbt.func_74762_e("bSize");
        this.boundingBoxes.clear();
        for (int i = 0; i < count; ++i) {
            this.boundingBoxes.add(new LittleTileBox("bBox" + i, nbt));
        }
        this.updateCorner();
        this.isStructureBlock = nbt.func_74767_n("isStructure");
        if (this.isStructureBlock) {
            if (nbt.func_74767_n("main")) {
                this.isMainBlock = true;
                this.structure = LittleStructure.createAndLoadStructure(nbt, this);
            } else if (nbt.func_74764_b("coX")) {
                LittleTilePosition pos = new LittleTilePosition(nbt);
                this.coord = new LittleTileCoord((TileEntity)this.te, pos.coord, pos.position);
                System.out.println("Converting old positioning to new relative coordinates " + pos + " to " + this.coord);
            } else {
                this.coord = new LittleTileCoord(nbt);
            }
        }
    }

    public void markForUpdate() {
        if (!this.te.func_145831_w().field_72995_K) {
            this.te.updateBlock();
        } else {
            this.te.updateRender();
        }
    }

    public void onPlaced(@Nullable EntityPlayer player, ItemStack stack, EnumFacing facing) {
        this.onNeighborChangeInside();
    }

    public void updateCorner() {
        if (this.boundingBoxes.size() > 0) {
            LittleTileBox box = this.boundingBoxes.get(0);
            if (this.cornerVec != null) {
                this.cornerVec.x = box.minX;
                this.cornerVec.y = box.minY;
                this.cornerVec.z = box.minZ;
            } else {
                this.cornerVec = new LittleTileVec(box.minX, box.minY, box.minZ);
            }
        } else {
            this.cornerVec = new LittleTileVec(0, 0, 0);
        }
    }

    public void place() {
        this.updateCorner();
        this.te.addTile(this);
    }

    public void onDestoryed() {
    }

    public void destroy() {
        if (this.isStructureBlock) {
            if (!this.te.func_145831_w().field_72995_K && this.isLoaded()) {
                this.structure.onLittleTileDestory();
            }
        } else {
            this.te.removeTile(this);
        }
    }

    public LittleTile copy() {
        LittleTile tile = null;
        try {
            tile = (LittleTile)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid LittleTile class=" + this.getClass().getName());
            tile = null;
        }
        if (tile != null) {
            this.copyCore(tile);
            this.copyExtra(tile);
        }
        return tile;
    }

    public void assignTo(LittleTile target) {
        this.copyCore(target);
        this.copyExtra(target);
    }

    public void copyExtra(LittleTile tile) {
        tile.invisible = this.invisible;
        tile.glowing = this.glowing;
    }

    public void copyCore(LittleTile tile) {
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            tile.boundingBoxes.add(this.boundingBoxes.get(i).copy());
        }
        tile.cornerVec = this.cornerVec.copy();
        tile.te = this.te;
        tile.isStructureBlock = this.isStructureBlock;
        tile.structure = this.structure;
        if (this.coord != null) {
            tile.coord = this.coord.copy();
        }
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = null;
        if (this.isStructureBlock) {
            if (this.isLoaded()) {
                stack = this.structure.getStructureDrop();
            }
        } else {
            stack = this.getDrop();
        }
        if (stack != null) {
            drops.add(stack);
        }
        return drops;
    }

    public abstract ItemStack getDrop();

    public void onNeighborChangeOutside() {
        this.onNeighborChange();
    }

    public void onNeighborChangeInside() {
        this.onNeighborChange();
    }

    public void onNeighborChange() {
    }

    public boolean needCustomRendering() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public final ArrayList<RenderCubeObject> getRenderingCubes() {
        if (this.invisible) {
            return new ArrayList<RenderCubeObject>();
        }
        return this.getInternalRenderingCubes();
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract ArrayList<RenderCubeObject> getInternalRenderingCubes();

    @SideOnly(value=Side.CLIENT)
    public void renderTick(double x, double y, double z, float partialTickTime) {
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public abstract SoundType getSound();

    public void updateEntity() {
    }

    public boolean shouldTick() {
        return false;
    }

    protected abstract boolean canSawResize(EnumFacing var1, EntityPlayer var2);

    public boolean canSawResizeTile(EnumFacing facing, EntityPlayer player) {
        return this.boundingBoxes.size() == 1 && !this.isStructureBlock && this.canSawResize(facing, player);
    }

    public boolean canBeMoved(EnumFacing facing) {
        return this.boundingBoxes.size() == 1;
    }

    public abstract float getExplosionResistance();

    public void onTileExplodes(Explosion explosion) {
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isLoaded()) {
            return this.structure.onBlockActivated(worldIn, this, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.glowing ? 14 : 0;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    public boolean isLadder() {
        if (this.isLoaded()) {
            return this.structure.isLadder();
        }
        return false;
    }

    public ArrayList<LittleTileBox> getCollisionBoxes() {
        if (this.shouldCheckForCollision()) {
            return new ArrayList<LittleTileBox>();
        }
        if (this.isLoaded() && this.structure.noCollisionBoxes()) {
            return new ArrayList<LittleTileBox>();
        }
        return this.boundingBoxes;
    }

    public boolean shouldCheckForCollision() {
        if (this.isLoaded()) {
            return this.structure.shouldCheckForCollision();
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.isLoaded()) {
            this.structure.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
        }
    }

    public boolean checkForStructure() {
        BlockPos absoluteCoord;
        Chunk chunk;
        if (this.loadingStructure) {
            return false;
        }
        if (this.structure != null) {
            return true;
        }
        this.loadingStructure = true;
        World world = this.te.func_145831_w();
        if (world != null && WorldUtils.checkIfChunkExists((Chunk)(chunk = world.func_175726_f(absoluteCoord = this.coord.getAbsolutePosition((TileEntity)this.te))))) {
            LittleTile tile;
            TileEntity tileEntity = world.func_175625_s(absoluteCoord);
            if (tileEntity instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)tileEntity).getTile(this.coord.position)) != null && tile.isStructureBlock && tile.isMainBlock) {
                this.structure = tile.structure;
                if (this.structure != null && this.structure.getTiles() != null && !this.structure.getTiles().contains(this)) {
                    this.structure.getTiles().add(this);
                }
            }
            if (this.structure == null && !world.field_72995_K) {
                this.te.removeTile(this);
                this.te.updateBlock();
            }
            this.loadingStructure = false;
            return this.structure != null;
        }
        this.loadingStructure = false;
        return false;
    }

    public boolean isLoaded() {
        return this.isAllowedToSearchForStructure && this.isStructureBlock && this.checkForStructure();
    }

    public LittleTilePreview getPreviewTile() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTileExtra(nbt);
        nbt.func_74778_a("tID", this.getID());
        return new LittleTilePreview(this.boundingBoxes.get(0).copy(), nbt);
    }

    @Deprecated
    public static class LittleTilePosition {
        public BlockPos coord;
        public LittleTileVec position;

        public LittleTilePosition(BlockPos coord, LittleTileVec position) {
            this.coord = coord;
            this.position = position;
        }

        public LittleTilePosition(String id, NBTTagCompound nbt) {
            this.coord = new BlockPos(nbt.func_74762_e(id + "coX"), nbt.func_74762_e(id + "coY"), nbt.func_74762_e(id + "coZ"));
            this.position = new LittleTileVec(id + "po", nbt);
        }

        public LittleTilePosition(NBTTagCompound nbt) {
            this("", nbt);
        }

        public void writeToNBT(String id, NBTTagCompound nbt) {
            nbt.func_74768_a(id + "coX", this.coord.func_177958_n());
            nbt.func_74768_a(id + "coY", this.coord.func_177956_o());
            nbt.func_74768_a(id + "coZ", this.coord.func_177952_p());
            this.position.writeToNBT(id + "po", nbt);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT("", nbt);
        }

        public String toString() {
            return "coord:" + this.coord + "|position:" + this.position;
        }

        public LittleTilePosition copy() {
            return new LittleTilePosition(new BlockPos((Vec3i)this.coord), this.position.copy());
        }
    }
}

