/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.api.blocks.SpecialBlockHandler;
import com.creativemd.littletiles.common.blocks.ISpecialLittleBlock;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileBlock
extends LittleTile {
    private Block block;
    private int meta;
    private SpecialBlockHandler handler;
    @SideOnly(value=Side.CLIENT)
    private boolean translucent;
    private IBlockState state = null;

    private void updateSpecialHandler() {
        this.handler = SpecialBlockHandler.getSpecialBlockHandler(this.block, this.meta);
    }

    public boolean hasSpecialBlockHandler() {
        return this.handler != null;
    }

    public void setBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setMeta(int meta) {
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setBlock(Block block) {
        this.block = block;
        this.updateSpecialHandler();
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.block.func_176203_a(this.meta);
            if (this.state == null) {
                this.state = this.block.func_176223_P();
            }
        }
        return this.state;
    }

    public LittleTileBlock(Block block, int meta) {
        this.setBlock(block, meta);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.updateClient();
        }
    }

    public LittleTileBlock(Block block) {
        this(block, 0);
    }

    public LittleTileBlock() {
    }

    public void updateClient() {
        this.updateTranslucent();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTranslucent() {
        this.translucent = this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.TRANSLUCENT) || this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.CUTOUT);
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        super.saveTileExtra(nbt);
        nbt.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        nbt.func_74768_a("meta", this.meta);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        super.loadTileExtra(nbt);
        this.setBlock(Block.func_149684_b((String)nbt.func_74779_i("block")), nbt.func_74762_e("meta"));
        if (this.te.isClientSide()) {
            this.updateClient();
        }
    }

    @Override
    public void copyExtra(LittleTile tile) {
        super.copyExtra(tile);
        if (tile instanceof LittleTileBlock) {
            LittleTileBlock thisTile = (LittleTileBlock)tile;
            thisTile.setBlock(this.block, this.meta);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                thisTile.translucent = this.translucent;
            }
        }
    }

    @Override
    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return super.isIdenticalToNBT(nbt) && ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString().equals(nbt.func_74779_i("block")) && this.meta == nbt.func_74762_e("meta");
    }

    @Override
    public ItemStack getDrop() {
        ItemStack stack = new ItemStack((Block)LittleTiles.blockTile);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("tID", this.getID());
        this.saveTileExtra(stack.func_77978_p());
        ((LittleTileBox)this.boundingBoxes.get(0)).getSize().writeToNBT("size", stack.func_77978_p());
        return stack;
    }

    @Override
    public ArrayList<RenderCubeObject> getInternalRenderingCubes() {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            cubes.add(new RenderCubeObject(((LittleTileBox)this.boundingBoxes.get(i)).getCube(), this.block, this.meta));
        }
        return cubes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        if (FMLClientHandler.instance().hasOptifine() && this.block.canRenderInLayer(this.state, BlockRenderLayer.CUTOUT)) {
            return layer == BlockRenderLayer.CUTOUT_MIPPED;
        }
        try {
            return this.block.canRenderInLayer(this.getBlockState(), layer);
        }
        catch (Exception e) {
            try {
                return this.block.func_180664_k() == layer;
            }
            catch (Exception e2) {
                return layer == BlockRenderLayer.SOLID;
            }
        }
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.onPlaced(player, stack, facing);
        try {
            this.block.func_180633_a(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState(), (EntityLivingBase)player, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SoundType getSound() {
        return this.block.func_185467_w();
    }

    @Override
    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.randomDisplayTick(this, stateIn, worldIn, pos, rand);
        } else {
            this.block.func_180655_c(this.getBlockState(), worldIn, pos, rand);
        }
    }

    @Override
    public void onTileExplodes(Explosion explosion) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.onTileExplodes(this, explosion);
        }
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (this.hasSpecialBlockHandler()) {
            return this.handler.onBlockActivated(this, worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return this.block.func_180639_a(worldIn, pos, this.getBlockState(), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public void place() {
        super.place();
        this.block.func_176213_c(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState());
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.glowing) {
            return super.getLightValue(state, world, pos);
        }
        return this.block.func_149750_m(this.getBlockState());
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.block.getEnchantPowerBonus(world, pos);
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (super.canBeCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return super.doesProvideSolidFace(facing) && !this.translucent;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        if (super.canBeRenderCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    protected boolean canSawResize(EnumFacing facing, EntityPlayer player) {
        return true;
    }

    @Override
    public float getExplosionResistance() {
        return this.block.func_149638_a(null);
    }

    @Override
    public ArrayList<LittleTileBox> getCollisionBoxes() {
        if (this.block instanceof ISpecialLittleBlock) {
            return ((ISpecialLittleBlock)this.block).getCollisionBoxes(super.getCollisionBoxes(), this);
        }
        return super.getCollisionBoxes();
    }
}

