/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.InsideShiftHandler;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlacementHelper {
    private static PlacementHelper instance;
    public EntityPlayer player;
    public World world;

    public static PlacementHelper getInstance(EntityPlayer player) {
        if (instance == null) {
            instance = new PlacementHelper(player);
        } else {
            PlacementHelper.instance.player = player;
            PlacementHelper.instance.world = player.field_70170_p;
        }
        return instance;
    }

    public PlacementHelper(EntityPlayer player) {
        this.player = player;
        this.world = player.field_70170_p;
    }

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).getLittlePreview(stack) != null;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).getLittlePreview(stack) != null;
        }
        return false;
    }

    public ArrayList<PlacePreviewTile> getPreviewTiles(ItemStack stack, RayTraceResult moving, boolean customPlacement) {
        return this.getPreviewTiles(stack, moving.func_178782_a(), this.player.func_174824_e(TickUtils.getPartialTickTime()), moving.field_72307_f, moving.field_178784_b, customPlacement, LittleTiles.invertedShift != this.player.func_70093_af(), false);
    }

    public static LittleTileVec getInternalOffset(ArrayList<LittleTilePreview> tiles) {
        int minX = LittleTile.maxPos;
        int minY = LittleTile.maxPos;
        int minZ = LittleTile.maxPos;
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileVec(0, 0, 0);
            }
            if (tile.box == null) continue;
            minX = Math.min(minX, tile.box.minX);
            minY = Math.min(minY, tile.box.minY);
            minZ = Math.min(minZ, tile.box.minZ);
        }
        return new LittleTileVec(minX, minY, minZ);
    }

    public static LittleTileSize getSize(ArrayList<LittleTilePreview> tiles) {
        int minX = LittleTile.maxPos;
        int minY = LittleTile.maxPos;
        int minZ = LittleTile.maxPos;
        int maxX = LittleTile.minPos;
        int maxY = LittleTile.minPos;
        int maxZ = LittleTile.minPos;
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileSize(0, 0, 0);
            }
            if (tile.box != null) {
                minX = Math.min(minX, tile.box.minX);
                minY = Math.min(minY, tile.box.minY);
                minZ = Math.min(minZ, tile.box.minZ);
                maxX = Math.max(maxX, tile.box.maxX);
                maxY = Math.max(maxY, tile.box.maxY);
                maxZ = Math.max(maxZ, tile.box.maxZ);
                continue;
            }
            size.max(tile.size);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public ArrayList<PlacePreviewTile> getPreviewTiles(ItemStack stack, BlockPos pos, Vec3d playerPos, Vec3d hitVec, EnumFacing side, boolean customPlacement, boolean isSneaking) {
        return this.getPreviewTiles(stack, pos, playerPos, hitVec, side, customPlacement, isSneaking, false);
    }

    public ArrayList<PlacePreviewTile> getPreviewTiles(ItemStack stack, BlockPos pos, Vec3d playerPos, Vec3d hitVec, EnumFacing side, boolean customPlacement, boolean isSneaking, boolean inside) {
        ArrayList<ShiftHandler> shifthandlers = new ArrayList<ShiftHandler>();
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        ArrayList<LittleTilePreview> tiles = null;
        Object tempPreview = null;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        if (iTile != null) {
            tiles = iTile.getLittlePreview(stack);
        }
        if (tiles != null) {
            int i;
            LittleTileSize size = PlacementHelper.getSize(tiles);
            if (tiles.size() == 1) {
                shifthandlers.addAll(tiles.get((int)0).shifthandlers);
            }
            shifthandlers.add(new InsideShiftHandler());
            LittleTileBox box = this.getTilesBox(size, hitVec, pos, side, customPlacement, inside);
            LittleTileVec internalOffset = PlacementHelper.getInternalOffset(tiles);
            internalOffset.invert();
            boolean canPlaceNormal = false;
            if (!customPlacement && isSneaking) {
                Block block;
                if (!inside && !this.canBePlacedInside(pos, hitVec, side)) {
                    pos = pos.func_177972_a(side);
                }
                if (tiles.size() > 0 && tiles.get((int)0).box != null && ((block = this.world.func_180495_p(pos).func_177230_c()).func_176200_f((IBlockAccess)this.world, pos) || block instanceof BlockTile)) {
                    TileEntity te = this.world.func_175625_s(pos);
                    canPlaceNormal = true;
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                        for (i = 0; i < tiles.size(); ++i) {
                            LittleTilePreview tile = tiles.get(i);
                            if (teTiles.isSpaceForLittleTile(tile.box)) continue;
                            canPlaceNormal = false;
                            break;
                        }
                    }
                }
                if (!canPlaceNormal) {
                    for (int i2 = 0; i2 < shifthandlers.size(); ++i2) {
                        ((ShiftHandler)shifthandlers.get(i2)).init(this.world, pos);
                    }
                    LittleTileVec hit = this.getHitVec(hitVec, pos, side, customPlacement, inside, true);
                    ShiftHandler handler = null;
                    double distance = 2.0;
                    for (int i3 = 0; i3 < shifthandlers.size(); ++i3) {
                        double tempDistance = ((ShiftHandler)shifthandlers.get(i3)).getDistance(hit);
                        if (!(tempDistance < distance)) continue;
                        distance = tempDistance;
                        handler = (ShiftHandler)shifthandlers.get(i3);
                    }
                    if (handler != null) {
                        box = handler.getNewPosition(this.world, pos, box);
                    }
                }
            }
            LittleTileVec offset = box.getMinVec();
            offset.addVec(internalOffset);
            for (int i4 = 0; i4 < tiles.size(); ++i4) {
                PlacePreviewTile preview;
                LittleTilePreview tile = tiles.get(i4);
                if (tile == null || (preview = tile.getPlaceableTile(box, canPlaceNormal, offset)) == null) continue;
                previews.add(preview);
            }
            LittleStructure structure = iTile.getLittleStructure(stack);
            if (structure != null) {
                ArrayList<PlacePreviewTile> newBoxes = structure.getSpecialTiles();
                for (i = 0; i < newBoxes.size(); ++i) {
                    if (canPlaceNormal) continue;
                    newBoxes.get((int)i).box.addOffset(offset);
                }
                previews.addAll(newBoxes);
            }
        }
        return previews;
    }

    public LittleTileBox getTilesBox(LittleTileSize size, Vec3d hitVec, BlockPos pos, EnumFacing side, boolean customPlacement, boolean inside) {
        LittleTileVec hit = this.getHitVec(hitVec, pos, side, customPlacement, inside, true);
        LittleTileVec center = size.calculateCenter();
        LittleTileVec centerInv = size.calculateInvertedCenter();
        switch (side) {
            case EAST: {
                hit.x += center.x;
                break;
            }
            case WEST: {
                hit.x -= centerInv.x;
                break;
            }
            case UP: {
                hit.y += center.y;
                break;
            }
            case DOWN: {
                hit.y -= centerInv.y;
                break;
            }
            case SOUTH: {
                hit.z += center.z;
                break;
            }
            case NORTH: {
                hit.z -= centerInv.z;
                break;
            }
        }
        return new LittleTileBox(hit, size);
    }

    public boolean canBePlacedInsideBlock(BlockPos pos) {
        TileEntity tileEntity = this.player.field_70170_p.func_175625_s(pos);
        return tileEntity instanceof TileEntityLittleTiles;
    }

    public boolean canBePlacedInside(BlockPos pos, Vec3d hitVec, EnumFacing side) {
        TileEntity tileEntity = this.player.field_70170_p.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return (double)((int)hitVec.field_72450_a) != hitVec.field_72450_a;
                }
                case UP: 
                case DOWN: {
                    return (double)((int)hitVec.field_72448_b) != hitVec.field_72448_b;
                }
                case SOUTH: 
                case NORTH: {
                    return (double)((int)hitVec.field_72449_c) != hitVec.field_72449_c;
                }
            }
            return false;
        }
        return false;
    }

    public LittleTileVec getHitVec(Vec3d hitVec, BlockPos pos, EnumFacing side, boolean customPlacement, boolean isInside, boolean checkIfPlacedInside) {
        if (customPlacement && !isInside) {
            double posX = hitVec.field_72450_a - (double)pos.func_177958_n();
            double posY = hitVec.field_72448_b - (double)pos.func_177956_o();
            double posZ = hitVec.field_72449_c - (double)pos.func_177952_p();
            LittleTileVec vec = new LittleTileVec((int)(posX * (double)LittleTile.gridSize), (int)(posY * (double)LittleTile.gridSize), (int)(posZ * (double)LittleTile.gridSize));
            if (checkIfPlacedInside && !this.canBePlacedInside(pos, hitVec, side)) {
                switch (side) {
                    case EAST: {
                        vec.x -= LittleTile.gridSize;
                        break;
                    }
                    case WEST: {
                        vec.x += LittleTile.gridSize;
                        break;
                    }
                    case UP: {
                        vec.y -= LittleTile.gridSize;
                        break;
                    }
                    case DOWN: {
                        vec.y += LittleTile.gridSize;
                        break;
                    }
                    case SOUTH: {
                        vec.z -= LittleTile.gridSize;
                        break;
                    }
                    case NORTH: {
                        vec.z += LittleTile.gridSize;
                        break;
                    }
                }
            }
            return vec;
        }
        double posX = hitVec.field_72450_a - (double)pos.func_177958_n();
        double posY = hitVec.field_72448_b - (double)pos.func_177956_o();
        double posZ = hitVec.field_72449_c - (double)pos.func_177952_p();
        LittleTileVec vec = new LittleTileVec((int)(posX * (double)LittleTile.gridSize), (int)(posY * (double)LittleTile.gridSize), (int)(posZ * (double)LittleTile.gridSize));
        if (!customPlacement && checkIfPlacedInside && !this.canBePlacedInside(pos, hitVec, side)) {
            switch (side) {
                case EAST: {
                    vec.x = 0;
                    break;
                }
                case WEST: {
                    vec.x = LittleTile.gridSize;
                    break;
                }
                case UP: {
                    vec.y = 0;
                    break;
                }
                case DOWN: {
                    vec.y = LittleTile.gridSize;
                    break;
                }
                case SOUTH: {
                    vec.z = 0;
                    break;
                }
                case NORTH: {
                    vec.z = LittleTile.gridSize;
                    break;
                }
            }
        }
        return vec;
    }
}

