/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.converting;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StructureStringUtils {
    @SideOnly(value=Side.CLIENT)
    public static String exportModel(ItemStack stack) {
        if (stack != null && (PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemRecipe)) {
            JsonObject object = new JsonObject();
            NBTTagCompound nbt = new NBTTagCompound();
            ArrayList<LittleTilePreview> previews = null;
            LittleStructure structure = null;
            if (stack.func_77973_b() instanceof ItemRecipe) {
                previews = ItemRecipe.getPreview(stack);
                structure = ItemMultiTiles.getLTStructure(stack);
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack);
                previews = tile.getLittlePreview(stack);
                structure = tile.getLittleStructure(stack);
            }
            ArrayList<String> texturenames = new ArrayList<String>();
            List cubes = ((ICreativeRendered)stack.func_77973_b()).getRenderingCubes(null, null, stack);
            JsonArray elements = new JsonArray();
            for (int i = 0; i < cubes.size(); ++i) {
                RenderCubeObject cube = (RenderCubeObject)cubes.get(i);
                JsonObject element = new JsonObject();
                element.addProperty("name", "littletile_" + i);
                JsonArray positionArray = new JsonArray();
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minX * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minY * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.minZ * 16.0f)));
                element.add("from", (JsonElement)positionArray);
                positionArray = new JsonArray();
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxX * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxY * 16.0f)));
                positionArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(cube.maxZ * 16.0f)));
                element.add("to", (JsonElement)positionArray);
                IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(cube.getBlockState());
                CubeObject uvCube = cube.offset(cube.getOffset());
                JsonObject faces = new JsonObject();
                for (int j = 0; j < EnumFacing.field_82609_l.length; ++j) {
                    EnumFacing facing = EnumFacing.field_82609_l[j];
                    List quads = CreativeBakedModel.getBakedQuad((RenderCubeObject)cube, (CubeObject)uvCube, (IBlockState)cube.getBlockState(), (IBakedModel)blockModel, (EnumFacing)facing, (long)0L);
                    if (quads.isEmpty()) continue;
                    JsonObject face = new JsonObject();
                    BakedQuad quad = (BakedQuad)quads.get(0);
                    if (!texturenames.contains(quad.func_187508_a().func_94215_i())) {
                        texturenames.add(quad.func_187508_a().func_94215_i());
                    }
                    int iconID = texturenames.indexOf(quad.func_187508_a().func_94215_i());
                    face.addProperty("texture", "#" + iconID);
                    JsonArray uv = new JsonArray();
                    float minX = 16.0f;
                    float maxX = 0.0f;
                    float minY = 16.0f;
                    float maxY = 0.0f;
                    for (int k = 0; k < 4; ++k) {
                        int index = k * quad.getFormat().func_181719_f();
                        int uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
                        float u = quad.func_187508_a().func_188537_a(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]));
                        minX = Math.min(minX, u);
                        maxX = Math.max(maxX, u);
                        float v = quad.func_187508_a().func_188536_b(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]));
                        minY = Math.min(minY, v);
                        maxY = Math.max(maxY, v);
                    }
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(minX)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(minY)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(maxX)));
                    uv.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(maxY)));
                    face.add("uv", (JsonElement)uv);
                    faces.add(facing.func_176610_l(), (JsonElement)face);
                }
                element.add("faces", (JsonElement)faces);
                elements.add((JsonElement)element);
            }
            object.add("elements", (JsonElement)elements);
            JsonObject textures = new JsonObject();
            for (int j = 0; j < texturenames.size(); ++j) {
                textures.addProperty("" + j, (String)texturenames.get(j));
            }
            object.add("textures", (JsonElement)textures);
            object.addProperty("__comment", "Model generated by LittleTiles");
            return object.toString();
        }
        return "";
    }

    public static String exportStructure(ItemStack stack) {
        String text = "";
        if (stack != null && (PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemRecipe)) {
            NBTTagCompound nbt = new NBTTagCompound();
            ArrayList<LittleTilePreview> previews = null;
            LittleStructure structure = null;
            if (stack.func_77973_b() instanceof ItemRecipe) {
                previews = ItemRecipe.getPreview(stack);
                structure = ItemMultiTiles.getLTStructure(stack);
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack);
                previews = tile.getLittlePreview(stack);
                structure = tile.getLittleStructure(stack);
            }
            nbt.func_74768_a("tiles", previews.size());
            ArrayList<String> blockNames = new ArrayList<String>();
            for (int i = 0; i < previews.size(); ++i) {
                if (previews.get((int)i).box == null) continue;
                LittleTileBox box = previews.get((int)i).box;
                String blockName = previews.get(i).getPreviewBlockName();
                if (!blockNames.contains(blockName)) {
                    blockNames.add(blockName);
                }
                String tileString = blockNames.indexOf(blockName) + "." + previews.get(i).getPreviewBlockMeta();
                if (previews.get(i).hasColor()) {
                    tileString = tileString + "." + previews.get(i).getColor();
                }
                nbt.func_74778_a("" + i, box.minX + "." + box.minY + "." + box.minZ + "." + box.maxX + "." + box.maxY + "." + box.maxZ + "." + tileString);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < blockNames.size(); ++i) {
                if (i > 0) {
                    builder.append(".");
                }
                builder.append((String)blockNames.get(i));
            }
            nbt.func_74778_a("names", builder.toString());
            if (structure != null) {
                NBTTagCompound nbtStructure = new NBTTagCompound();
                structure.writeToNBT(nbtStructure);
                nbt.func_74782_a("structure", (NBTBase)nbtStructure);
            }
            text = nbt.toString();
        }
        return text;
    }

    public static ItemStack importStructure(String input) {
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)input);
            NBTTagCompound itemNBT = new NBTTagCompound();
            if (nbt.func_74764_b("structure")) {
                itemNBT.func_74782_a("structure", (NBTBase)nbt.func_74775_l("structure"));
            }
            String[] names = nbt.func_74779_i("names").split("\\.");
            int tiles = nbt.func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                String[] entries = nbt.func_74779_i("" + i).split("\\.");
                if (entries.length < 8) continue;
                NBTTagCompound tileNBT = new NBTTagCompound();
                LittleTileBox box = new LittleTileBox(Integer.parseInt(entries[0]), Integer.parseInt(entries[1]), Integer.parseInt(entries[2]), Integer.parseInt(entries[3]), Integer.parseInt(entries[4]), Integer.parseInt(entries[5]));
                tileNBT.func_74778_a("block", names[Integer.parseInt(entries[6])]);
                tileNBT.func_74768_a("meta", Integer.parseInt(entries[7]));
                if (entries.length >= 9) {
                    tileNBT.func_74768_a("color", Integer.parseInt(entries[8]));
                }
                box.writeToNBT("bBox", tileNBT);
                tileNBT.func_74778_a("tID", "BlockTileBlock");
                itemNBT.func_74782_a("tile" + i, (NBTBase)tileNBT);
            }
            itemNBT.func_74768_a("tiles", tiles);
            ItemStack stack = new ItemStack(LittleTiles.recipe);
            stack.func_77982_d(itemNBT);
            return stack;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

