/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.rotation;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import net.minecraft.nbt.NBTTagCompound;

public class OrdinaryDoorTransformation
extends DoorTransformation {
    public Rotation rotation;

    public OrdinaryDoorTransformation() {
    }

    public OrdinaryDoorTransformation(Rotation rotation) {
        this.rotation = rotation;
    }

    @Override
    public void performTransformation(EntityAnimation animation, double progress) {
        switch (this.rotation) {
            case NORTH: {
                animation.worldRotY = -90.0 + progress * 90.0;
                break;
            }
            case SOUTH: {
                animation.worldRotY = (1.0 - progress) * 90.0;
                break;
            }
            case UP: {
                animation.worldRotZ = -90.0 + progress * 90.0;
                break;
            }
            case DOWN: {
                animation.worldRotZ = (1.0 - progress) * 90.0;
                break;
            }
            case UPX: {
                animation.worldRotX = (1.0 - progress) * 90.0;
                break;
            }
            case DOWNX: {
                animation.worldRotX = -90.0 + progress * 90.0;
            }
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("rot", this.rotation.ordinal());
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        this.rotation = Rotation.getRotationByID((int)nbt.func_74762_e("rot"));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OrdinaryDoorTransformation) {
            return ((OrdinaryDoorTransformation)object).rotation == this.rotation;
        }
        return false;
    }
}

