/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.rotation;

import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SlidingDoorTransformation
extends DoorTransformation {
    public EnumFacing direction;
    public int distance;

    public SlidingDoorTransformation() {
    }

    public SlidingDoorTransformation(EnumFacing direction, int distance) {
        this.direction = direction;
        this.distance = distance;
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("direction", this.direction.ordinal());
        nbt.func_74768_a("distance", this.distance);
    }

    @Override
    protected void readFromNBT(NBTTagCompound nbt) {
        this.direction = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        this.distance = nbt.func_74762_e("distance");
    }

    @Override
    public void performTransformation(EntityAnimation animation, double progress) {
        switch (this.direction) {
            case EAST: {
                animation.field_70165_t = (double)(animation.getAxisPos().func_177958_n() - animation.startOffset.func_177958_n()) - (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
            case WEST: {
                animation.field_70165_t = (double)(animation.getAxisPos().func_177958_n() - animation.startOffset.func_177958_n()) + (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
            case UP: {
                animation.field_70163_u = (double)(animation.getAxisPos().func_177956_o() - animation.startOffset.func_177956_o()) - (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
            case DOWN: {
                animation.field_70163_u = (double)(animation.getAxisPos().func_177956_o() - animation.startOffset.func_177956_o()) + (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
            case SOUTH: {
                animation.field_70161_v = (double)(animation.getAxisPos().func_177952_p() - animation.startOffset.func_177952_p()) - (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
            case NORTH: {
                animation.field_70161_v = (double)(animation.getAxisPos().func_177952_p() - animation.startOffset.func_177952_p()) + (double)this.distance * LittleTile.gridMCLength * (1.0 - progress);
                break;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SlidingDoorTransformation) {
            return ((SlidingDoorTransformation)object).direction == this.direction && ((SlidingDoorTransformation)object).distance == this.distance;
        }
        return false;
    }
}

