/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;

public class LittleTileSize {
    public int sizeX;
    public int sizeY;
    public int sizeZ;

    public LittleTileSize(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "x") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
        } else if (nbt.func_74781_a(name + "x") instanceof NBTTagInt) {
            this.set(nbt.func_74762_e(name + "x"), nbt.func_74762_e(name + "y"), nbt.func_74762_e(name + "z"));
        } else {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            }
            catch (Exception e) {
                this.set(0, 0, 0);
            }
        }
    }

    public LittleTileSize(String data) {
        String[] coords = data.split("\\.");
        try {
            this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        }
        catch (Exception e) {
            this.set(0, 0, 0);
        }
    }

    public LittleTileSize(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void set(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileSize) {
            return this.sizeX == ((LittleTileSize)object).sizeX && this.sizeY == ((LittleTileSize)object).sizeY && this.sizeZ == ((LittleTileSize)object).sizeZ;
        }
        return super.equals(object);
    }

    public int getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public double getPercentVolume() {
        return (double)this.getVolume() / (double)LittleTile.maxTilesPerBlock;
    }

    public LittleTileVec calculateInvertedCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((int)Math.ceil(x), (int)Math.ceil(y), (int)Math.ceil(z));
    }

    public LittleTileVec calculateCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public double getPosX() {
        return (double)this.sizeX / (double)LittleTile.gridSize;
    }

    public double getPosY() {
        return (double)this.sizeY / (double)LittleTile.gridSize;
    }

    public double getPosZ() {
        return (double)this.sizeZ / (double)LittleTile.gridSize;
    }

    public LittleTileSize copy() {
        return new LittleTileSize(this.sizeX, this.sizeY, this.sizeZ);
    }

    public void rotateSize(Rotation direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                int tempY = this.sizeY;
                this.sizeY = this.sizeX;
                this.sizeX = tempY;
                break;
            }
            case UPX: 
            case DOWNX: {
                int tempY = this.sizeY;
                this.sizeY = this.sizeZ;
                this.sizeZ = tempY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                int tempZ = this.sizeZ;
                this.sizeZ = this.sizeX;
                this.sizeX = tempZ;
                break;
            }
        }
    }

    public void rotateSize(EnumFacing direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                int tempY = this.sizeY;
                this.sizeY = this.sizeX;
                this.sizeX = tempY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                int tempZ = this.sizeZ;
                this.sizeZ = this.sizeX;
                this.sizeX = tempZ;
                break;
            }
        }
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74778_a(name, this.sizeX + "." + this.sizeY + "." + this.sizeZ);
    }

    public String toString() {
        return this.sizeX + "." + this.sizeY + "." + this.sizeZ;
    }

    public LittleTileSize max(LittleTileSize size) {
        this.sizeX = Math.max(this.sizeX, size.sizeX);
        this.sizeY = Math.max(this.sizeY, size.sizeY);
        this.sizeZ = Math.max(this.sizeZ, size.sizeZ);
        return this;
    }

    public int getSizeOfAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.sizeX;
            }
            case Y: {
                return this.sizeY;
            }
            case Z: {
                return this.sizeZ;
            }
        }
        return 0;
    }
}

