/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.littletiles.common.utils.LittleTile;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class LittleTileVec {
    public int x;
    public int y;
    public int z;

    public LittleTileVec(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "x") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
            this.writeToNBT(name, nbt);
        } else if (nbt.func_74781_a(name + "x") instanceof NBTTagInt) {
            this.set(nbt.func_74762_e(name + "x"), nbt.func_74762_e(name + "y"), nbt.func_74762_e(name + "z"));
        } else {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            }
            catch (Exception e) {
                this.set(0, 0, 0);
            }
        }
    }

    public LittleTileVec(Vec3d vec) {
        this((int)(vec.field_72450_a * (double)LittleTile.gridSize), (int)(vec.field_72448_b * (double)LittleTile.gridSize), (int)(vec.field_72449_c * (double)LittleTile.gridSize));
    }

    public LittleTileVec(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                this.set(1, 0, 0);
                break;
            }
            case WEST: {
                this.set(-1, 0, 0);
                break;
            }
            case UP: {
                this.set(0, 1, 0);
                break;
            }
            case DOWN: {
                this.set(0, -1, 0);
                break;
            }
            case SOUTH: {
                this.set(0, 0, 1);
                break;
            }
            case NORTH: {
                this.set(0, 0, -1);
                break;
            }
            default: {
                this.set(0, 0, 0);
            }
        }
    }

    public LittleTileVec(int x, int y, int z) {
        this.set(x, y, z);
    }

    public LittleTileVec(Vec3i vec) {
        this(vec.func_177958_n() * LittleTile.gridSize, vec.func_177956_o() * LittleTile.gridSize, vec.func_177952_p() * LittleTile.gridSize);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos getBlockPos() {
        return new BlockPos((int)this.getPosX(), (int)this.getPosY(), (int)this.getPosZ());
    }

    public Vec3d getVec() {
        return new Vec3d(this.getPosX(), this.getPosY(), this.getPosZ());
    }

    public double getPosX() {
        return (double)this.x / (double)LittleTile.gridSize;
    }

    public double getPosY() {
        return (double)this.y / (double)LittleTile.gridSize;
    }

    public double getPosZ() {
        return (double)this.z / (double)LittleTile.gridSize;
    }

    public void addVec(LittleTileVec vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void subVec(LittleTileVec vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void rotateVec(EnumFacing direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                int tempY = this.y;
                this.y = this.x;
                this.x = tempY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                int tempZ = this.z;
                this.z = this.x;
                this.x = tempZ;
                break;
            }
        }
    }

    public double distanceTo(LittleTileVec vec) {
        return Math.sqrt(Math.pow(vec.x - this.x, 2.0) + Math.pow(vec.y - this.y, 2.0) + Math.pow(vec.z - this.z, 2.0));
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileVec) {
            return this.x == ((LittleTileVec)object).x && this.y == ((LittleTileVec)object).y && this.z == ((LittleTileVec)object).z;
        }
        return super.equals(object);
    }

    public LittleTileVec copy() {
        return new LittleTileVec(this.x, this.y, this.z);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74778_a(name, this.x + "." + this.y + "." + this.z);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void invert() {
        this.set(-this.x, -this.y, -this.z);
    }

    public void scale(int factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }
}

