/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="littletiles", category="")
@Mod.EventBusSubscriber
public class LittleTilesConfig {
    @Config.Name(value="core")
    @Config.LangKey(value="config.littletiles.core")
    @Config.RequiresMcRestart
    public static Core core = new Core();
    @Config.Name(value="building")
    @Config.LangKey(value="config.littletiles.building")
    public static Building building = new Building();
    @Config.Name(value="rendering")
    @Config.LangKey(value="config.littletiles.rendering")
    public static Rendering rendering = new Rendering();

    public static List<String> getConfigProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        LittleTilesConfig.loadProperties("", LittleTilesConfig.class, properties);
        return properties;
    }

    private static void loadProperties(String category, Class<?> clazz, List<String> properties) {
        for (Field field : clazz.getFields()) {
            Config.Name config = field.getAnnotation(Config.Name.class);
            if (config == null) continue;
            if (field.getType().getAnnotation(LittleConfig.class) != null) {
                LittleTilesConfig.loadProperties(category + (category.isEmpty() ? "" : ".") + config.value(), field.getType(), properties);
                continue;
            }
            properties.add(category + "." + config.value());
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("littletiles")) {
            ConfigManager.sync((String)"littletiles", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @LittleConfig
    public static class Rendering {
        @Config.Name(value="hideParticleBlock")
        @Config.LangKey(value="config.littletiles.hideParticleBlock")
        @Config.Comment(value={"Whether the particle block is visible or not"})
        public boolean hideParticleBlock = false;
    }

    @LittleConfig
    public static class Building {
        @Config.Name(value="invertStickToGrid")
        @Config.LangKey(value="config.littletiles.invertStickToGrid")
        @Config.Comment(value={"Whether tiles should stick to the vanilla grid when second mode is enabled or disabled."})
        public boolean invertStickToGrid = false;
        @Config.Name(value="maxSavedActions")
        @Config.LangKey(value="config.littletiles.maxSavedActions")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Number of actions which can be reverted."})
        public int maxSavedActions = 32;
        @Config.Name(value="useALTForEverything")
        @Config.LangKey(value="config.littletiles.useALTForEverything")
        @Config.Comment(value={"Second mode will be activated if 'ALT' is pressed (default: sneaking)."})
        public boolean useALTForEverything = false;
        @Config.Name(value="useAltWhenFlying")
        @Config.LangKey(value="config.littletiles.useAltWhenFlying")
        @Config.Comment(value={"Press 'ALT' when flying instead of sneaking to activate second mode."})
        public boolean useAltWhenFlying = true;
    }

    @Config.RequiresMcRestart
    @LittleConfig
    public static class Core {
        @Config.Name(value="gridSize")
        @Config.RequiresMcRestart
        @Config.Comment(value={"ATTENTION! This needs be equal for every client & server. Backup your world. This will make your tiles either shrink down or increase in size!"})
        @Config.RangeInt(min=1, max=0x7FFFFFFF)
        public int gridSize = 16;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LittleConfig {
    }
}

