/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles;

import com.creativemd.creativecore.transformer.CreativeTransformer;
import com.creativemd.creativecore.transformer.Transformer;
import com.creativemd.creativecore.transformer.TransformerNames;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LittleTilesTransformer
extends CreativeTransformer {
    public LittleTilesTransformer() {
        super("littletiles");
    }

    protected void initTransformers() {
        this.addTransformer(new Transformer("net.minecraft.client.renderer.RenderGlobal"){

            public void transform(ClassNode classNode) {
                MethodNode m = this.findMethod(classNode, "loadRenderers", "()V");
                String className = this.patchClassName("net/minecraft/client/renderer/chunk/ChunkRenderDispatcher");
                boolean isNextLabel = false;
                for (AbstractInsnNode node : m.instructions) {
                    if (isNextLabel && node instanceof LabelNode) {
                        m.instructions.insert(node, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "onReloadRenderers", this.patchDESC("(Lnet/minecraft/client/renderer/RenderGlobal;)V"), false));
                        m.instructions.insert(node, (AbstractInsnNode)new VarInsnNode(25, 0));
                        isNextLabel = false;
                    }
                    if (node instanceof TypeInsnNode && ((TypeInsnNode)node).getOpcode() == 187 && ((TypeInsnNode)node).desc.equals(className)) {
                        ((TypeInsnNode)node).desc = "com/creativemd/littletiles/client/render/LittleChunkDispatcher";
                    }
                    if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).name.equals("<init>") || !((MethodInsnNode)node).desc.equals("()V") || !((MethodInsnNode)node).owner.equals(className)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    method.owner = "com/creativemd/littletiles/client/render/LittleChunkDispatcher";
                    isNextLabel = true;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.player.EntityPlayer"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleBed", "Lcom/creativemd/littletiles/common/structure/LittleStructure;", null, null));
                MethodNode m = this.findMethod(node, "getBedOrientationInDegrees", "()F");
                if (m != null) {
                    m.instructions.clear();
                    m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/LittleBed", "getBedOrientationInDegrees", this.patchDESC("(Lnet/minecraft/entity/player/EntityPlayer;)F"), false));
                    m.instructions.add((AbstractInsnNode)new InsnNode(174));
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.client.ForgeHooksClient"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "orientBedCamera", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V");
                ListIterator iterator = m.instructions.iterator();
                boolean nextLabel = false;
                while (iterator.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (nextLabel && insn instanceof LabelNode) {
                        m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/LittleBed", "setBedDirection", this.patchDESC("(Lnet/minecraft/entity/Entity;)V"), false));
                        m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 3));
                        break;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.patchDESC("org/lwjgl/opengl/GL11")) || !((MethodInsnNode)insn).name.equals(this.patchFieldName("glRotatef"))) continue;
                    nextLabel = true;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.chunk.RenderChunk"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "resortTransparency", "(FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new LabelNode());
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "resortTransparency", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;FFFLnet/minecraft/client/renderer/chunk/ChunkCompileTaskGenerator;)V", false));
                m.instructions.add((AbstractInsnNode)new InsnNode(177));
                m.instructions.add((AbstractInsnNode)new LabelNode());
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.renderer.VertexBuffer"){

            public void transform(ClassNode node) {
                node.fields.add(new FieldNode(1, "littleTilesAdded", "Z", null, (Object)Boolean.FALSE));
                MethodNode m = this.findMethod(node, "reset", "()V");
                AbstractInsnNode start = m.instructions.getFirst();
                m.instructions.insertBefore(start, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore(start, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore(start, (AbstractInsnNode)new InsnNode(3));
                m.instructions.insertBefore(start, (AbstractInsnNode)new FieldInsnNode(181, this.patchClassName("net/minecraft/client/renderer/VertexBuffer"), "littleTilesAdded", "Z"));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.NettyCompressionDecoder"){

            public void transform(ClassNode node) {
                String descException = this.patchDESC("io/netty/handler/codec/DecoderException");
                String desc = this.patchDESC("(Lio/netty/channel/ChannelHandlerContext;Lio/netty/buffer/ByteBuf;Ljava/util/List;)V");
                String name = TransformerNames.patchMethodName((String)"decode", (String)desc, (String)this.patchClassName("io/netty/handler/codec/ByteToMessageDecoder"));
                MethodNode m = this.findMethod(node, name, desc);
                ListIterator iterator = m.instructions.iterator();
                int found = 0;
                while (iterator.hasNext()) {
                    AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
                    if (insn instanceof TypeInsnNode && insn.getOpcode() == 187 && ((TypeInsnNode)insn).desc.equals(descException)) {
                        if (++found != 2) continue;
                        iterator.remove();
                        continue;
                    }
                    if (found != 2) continue;
                    iterator.remove();
                    if (!(insn instanceof InsnNode) || insn.getOpcode() != 191) continue;
                    break;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.network.PacketBuffer"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "readCompoundTag", "()Lnet/minecraft/nbt/NBTTagCompound;");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof LdcInsnNode) || !(((LdcInsnNode)insn).cst instanceof Long)) continue;
                    m.instructions.remove(insn.getPrevious().getPrevious());
                    m.instructions.remove(insn.getPrevious());
                    m.instructions.remove(insn.getNext());
                    m.instructions.insert(insn, (AbstractInsnNode)new FieldInsnNode(178, this.patchDESC("net/minecraft/nbt/NBTSizeTracker"), TransformerNames.patchFieldName((String)"INFINITE", (String)this.patchClassName("net/minecraft/nbt/NBTSizeTracker")), this.patchDESC("Lnet/minecraft/nbt/NBTSizeTracker;")));
                    m.instructions.remove(insn);
                    break;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.util.math.AxisAlignedBB"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "intersectsWith", "(Lnet/minecraft/util/math/AxisAlignedBB;)Z");
                String axisClassName = this.patchClassName("net/minecraft/util/math/AxisAlignedBB");
                String methodDesc = "(L" + axisClassName + ";)Z";
                LabelNode label = (LabelNode)m.instructions.getFirst();
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new TypeInsnNode(193, "com/creativemd/creativecore/common/collision/CreativeAxisAlignedBB"));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new JumpInsnNode(153, label));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new LabelNode());
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new MethodInsnNode(182, axisClassName, this.patchMethodName("intersectsWith", methodDesc), methodDesc, false));
                m.instructions.insertBefore((AbstractInsnNode)label, (AbstractInsnNode)new InsnNode(172));
                String methodDESC2 = this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;D)D");
                String methodName = this.patchMethodName("calculateYOffset", methodDESC2);
                m = new MethodNode(1, "calculateYOffsetStepUp", this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/util/math/AxisAlignedBB;D)D"), null, null);
                LabelNode l0 = new LabelNode();
                m.instructions.add((AbstractInsnNode)l0);
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(24, 3));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(182, axisClassName, methodName, methodDESC2, false));
                m.instructions.add((AbstractInsnNode)new InsnNode(175));
                LabelNode l1 = new LabelNode();
                m.instructions.add((AbstractInsnNode)l1);
                m.localVariables.add(new LocalVariableNode("this", "L" + axisClassName + ";", null, l0, l1, 0));
                m.localVariables.add(new LocalVariableNode("other", "L" + axisClassName + ";", null, l0, l1, 1));
                m.localVariables.add(new LocalVariableNode("otherY", "L" + axisClassName + ";", null, l0, l1, 2));
                m.localVariables.add(new LocalVariableNode("offset", "D", null, l0, l1, 3));
                m.visitMaxs(4, 5);
                node.methods.add(m);
            }
        });
        this.addTransformer(new Transformer("net.minecraftforge.common.ForgeHooks"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "isLivingOnLadder", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z");
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
                m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/structure/LittleLadder", "isLivingOnLadder", this.patchDESC("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/EntityLivingBase;)Z"), false));
                m.instructions.add((AbstractInsnNode)new InsnNode(172));
            }
        });
        this.addTransformer(new Transformer("net.minecraft.entity.Entity"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "move", "(Lnet/minecraft/entity/MoverType;DDD)V");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof VarInsnNode) || insn.getOpcode() != 25 || ((VarInsnNode)insn).var != 32) continue;
                    MethodInsnNode methodInsn = (MethodInsnNode)insn.getNext().getNext();
                    methodInsn.name = "calculateYOffsetStepUp";
                    methodInsn.desc = this.patchDESC("(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/util/math/AxisAlignedBB;D)D");
                    m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 31));
                    return;
                }
            }
        });
        this.addTransformer(new Transformer("DynamicLight"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "updateChunkLight", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;Ljava/util/Set;Ljava/util/Set;)V");
                String className = this.patchClassName("net/minecraft/client/renderer/chunk/RenderChunk");
                String methodName = TransformerNames.patchMethodName((String)"setNeedsUpdate", (String)"(Z)V", (String)className);
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 182 || !((MethodInsnNode)insn).name.equals(methodName) || !((MethodInsnNode)insn).owner.equals(className)) continue;
                    AbstractInsnNode before = insn.getPrevious().getPrevious();
                    m.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/client/render/LittleChunkDispatcher", "onOptifineMarksChunkRenderUpdateForDynamicLights", "(Lnet/minecraft/client/renderer/chunk/RenderChunk;)V", false));
                    m.instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, ((VarInsnNode)before).var));
                    return;
                }
            }
        });
        this.addTransformer(new Transformer("net.minecraft.client.Minecraft"){

            public void transform(ClassNode node) {
                MethodNode m = this.findMethod(node, "middleClickMouse", "()V");
                String className = this.patchClassName("net/minecraft/client/Minecraft");
                for (AbstractInsnNode insn : m.instructions) {
                    if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 184 || !((MethodInsnNode)insn).owner.equals("net/minecraftforge/common/ForgeHooks") || !((MethodInsnNode)insn).name.equals("onPickBlock") || !((MethodInsnNode)insn).desc.equals(this.patchDESC("(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"))) continue;
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/littletiles/common/events/LittleEvent", "onMouseWheelClick", this.patchDESC("(Lnet/minecraft/util/math/RayTraceResult;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;)Z"), false));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new JumpInsnNode(154, this.findNextLabel(insn)));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new LabelNode());
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("objectMouseOver"), this.patchDESC("Lnet/minecraft/util/math/RayTraceResult;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("player"), this.patchDESC("Lnet/minecraft/client/entity/EntityPlayerSP;")));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore(insn, (AbstractInsnNode)new FieldInsnNode(180, className, this.patchFieldName("world"), this.patchDESC("Lnet/minecraft/client/multiplayer/WorldClient;")));
                    break;
                }
            }
        });
    }
}

