/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockLayerRenderBuffer {
    private AtomicBoolean isDrawing = new AtomicBoolean(false);
    public final VertexFormat format;
    public final int bufferSizePerQuad;
    private VertexBuffer solid;
    private VertexBuffer cutout_mipped;
    private VertexBuffer cutout;
    private VertexBuffer translucent;

    public synchronized void setDrawing() throws RenderOverlapException {
        if (this.isDrawing.get()) {
            throw new RenderOverlapException();
        }
        this.isDrawing.set(true);
    }

    public synchronized void setFinishedDrawing() {
        this.isDrawing.set(false);
    }

    public synchronized boolean isDrawing() {
        return this.isDrawing.get();
    }

    public BlockLayerRenderBuffer() {
        this(DefaultVertexFormats.field_176600_a);
    }

    public BlockLayerRenderBuffer(VertexFormat format) {
        this.format = format;
        this.bufferSizePerQuad = format.func_181719_f() * 4;
    }

    public int getBufferSizeForLayer(int tilesOfType) {
        return this.bufferSizePerQuad * 6 * tilesOfType;
    }

    public VertexBuffer createVertexBuffer(int tilesOfType) {
        return new VertexBuffer(this.getBufferSizeForLayer(tilesOfType));
    }

    public VertexBuffer getBufferByLayer(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                return this.solid;
            }
            case CUTOUT_MIPPED: {
                return this.cutout_mipped;
            }
            case CUTOUT: {
                return this.cutout;
            }
            case TRANSLUCENT: {
                return this.translucent;
            }
        }
        return null;
    }

    public void setBufferByLayer(VertexBuffer buffer, BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                this.solid = buffer;
                break;
            }
            case CUTOUT_MIPPED: {
                this.cutout_mipped = buffer;
                break;
            }
            case CUTOUT: {
                this.cutout = buffer;
                break;
            }
            case TRANSLUCENT: {
                this.translucent = buffer;
            }
        }
    }

    public void clear() {
        this.solid = null;
        this.cutout_mipped = null;
        this.cutout = null;
        this.translucent = null;
    }

    public static class RenderOverlapException
    extends Exception {
        public RenderOverlapException() {
            super("Buffer is already rendering!");
        }
    }
}

