/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.FixedHandler;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static PlacementHelper.PositionResult markedPosition = null;

    public static boolean isCentered(EntityPlayer player) {
        return LittleTilesConfig.building.invertStickToGrid == LittleAction.isUsingSecondMode(player) || markedPosition != null;
    }

    public static boolean isFixed(EntityPlayer player) {
        return LittleTilesConfig.building.invertStickToGrid != LittleAction.isUsingSecondMode(player) && markedPosition == null;
    }

    public static void handleUndoAndRedo(EntityPlayer player) {
        while (LittleTilesClient.undo.func_151468_f()) {
            try {
                LittleAction.undo();
            }
            catch (LittleActionException e) {
                player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            }
        }
        while (LittleTilesClient.redo.func_151468_f()) {
            try {
                LittleAction.redo();
            }
            catch (LittleActionException e) {
                player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            }
        }
    }

    @SubscribeEvent
    public void tick(RenderWorldLastEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G) {
            WorldClient world = PreviewRenderer.mc.field_71441_e;
            EntityPlayerSP player = PreviewRenderer.mc.field_71439_g;
            ItemStack stack = PreviewRenderer.mc.field_71439_g.func_184614_ca();
            PreviewRenderer.handleUndoAndRedo((EntityPlayer)player);
            if (PlacementHelper.isLittleBlock(stack) && (markedPosition != null || PreviewRenderer.mc.field_71476_x != null && PreviewRenderer.mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK)) {
                PlacementHelper.PositionResult position = markedPosition != null ? markedPosition : PlacementHelper.getPosition((World)world, PreviewRenderer.mc.field_71476_x);
                this.processRoateKeys();
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GL11.glDisable((int)3553);
                GL11.glDepthMask((boolean)false);
                ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
                iTile.tickPreview((EntityPlayer)player, stack, position, PreviewRenderer.mc.field_71476_x);
                boolean absolute = iTile.arePreviewsAbsolute();
                PlacementHelper.PreviewResult result = null;
                if (absolute) {
                    result = new PlacementHelper.PreviewResult();
                    List<LittleTilePreview> tiles = iTile.getLittlePreview(stack, true, markedPosition != null);
                    for (int i = 0; i < tiles.size(); ++i) {
                        result.placePreviews.add(tiles.get(i).getPlaceableTile(null, true, null));
                    }
                } else {
                    result = PlacementHelper.getPreviews((World)world, stack, position, PreviewRenderer.isCentered((EntityPlayer)player), PreviewRenderer.isFixed((EntityPlayer)player), true, markedPosition != null);
                }
                if (result != null) {
                    this.processMarkKey((EntityPlayer)player, position, result, absolute);
                    double x = (double)position.pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
                    double y = (double)position.pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
                    double z = (double)position.pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
                    for (int i = 0; i < result.placePreviews.size(); ++i) {
                        PlacePreviewTile preview = result.placePreviews.get(i);
                        List<LittleRenderingCube> cubes = preview.getPreviews();
                        for (LittleRenderingCube cube : cubes) {
                            GL11.glPushMatrix();
                            cube.renderCubePreview(absolute, x, y, z, iTile);
                            GL11.glPopMatrix();
                        }
                    }
                    if (!absolute && markedPosition == null && LittleAction.isUsingSecondMode((EntityPlayer)player) && result.singleMode) {
                        int i;
                        ArrayList<FixedHandler> shifthandlers = new ArrayList<FixedHandler>();
                        for (i = 0; i < result.placePreviews.size(); ++i) {
                            if (result.placePreviews.get((int)i).preview == null) continue;
                            shifthandlers.addAll(result.placePreviews.get((int)i).preview.fixedhandlers);
                        }
                        for (i = 0; i < shifthandlers.size(); ++i) {
                            ((FixedHandler)shifthandlers.get(i)).handleRendering(mc, x, y, z);
                        }
                    }
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
            } else {
                markedPosition = null;
            }
        }
    }

    public void processMarkKey(EntityPlayer player, PlacementHelper.PositionResult result, PlacementHelper.PreviewResult preview, boolean absolute) {
        while (LittleTilesClient.mark.func_151468_f()) {
            if (markedPosition == null) {
                boolean centered = PreviewRenderer.isCentered(player);
                markedPosition = result.copy();
                if (absolute) continue;
                PreviewRenderer.markedPosition.hit = preview.box.getCenter();
                LittleTileVec center = preview.size.calculateCenter();
                LittleTileVec centerInv = preview.size.calculateInvertedCenter();
                switch (result.facing) {
                    case EAST: {
                        PreviewRenderer.markedPosition.hit.x -= center.x;
                        break;
                    }
                    case WEST: {
                        PreviewRenderer.markedPosition.hit.x += centerInv.x;
                        break;
                    }
                    case UP: {
                        PreviewRenderer.markedPosition.hit.y -= center.y;
                        break;
                    }
                    case DOWN: {
                        PreviewRenderer.markedPosition.hit.y += centerInv.y;
                        break;
                    }
                    case SOUTH: {
                        PreviewRenderer.markedPosition.hit.z -= center.z;
                        break;
                    }
                    case NORTH: {
                        PreviewRenderer.markedPosition.hit.z += centerInv.z;
                        break;
                    }
                }
                if (preview.singleMode || !preview.placedFixed) continue;
                PreviewRenderer.markedPosition.hit.sub(preview.offset);
                continue;
            }
            markedPosition = null;
        }
    }

    public void processRotateKey(Rotation rotation) {
        LittleRotatePacket packet = new LittleRotatePacket(rotation);
        packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
        PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
    }

    public void processRoateKeys() {
        while (LittleTilesClient.flip.func_151468_f()) {
            int i4 = MathHelper.func_76128_c((double)((double)(PreviewRenderer.mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            EnumFacing direction = null;
            switch (i4) {
                case 0: {
                    direction = EnumFacing.SOUTH;
                    break;
                }
                case 1: {
                    direction = EnumFacing.WEST;
                    break;
                }
                case 2: {
                    direction = EnumFacing.NORTH;
                    break;
                }
                case 3: {
                    direction = EnumFacing.EAST;
                }
            }
            if (PreviewRenderer.mc.field_71439_g.field_70125_A > 45.0f) {
                direction = EnumFacing.DOWN;
            }
            if (PreviewRenderer.mc.field_71439_g.field_70125_A < -45.0f) {
                direction = EnumFacing.UP;
            }
            LittleFlipPacket packet = new LittleFlipPacket(direction.func_176740_k());
            packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
            PacketHandler.sendPacketToServer((CreativeCorePacket)packet);
        }
        while (LittleTilesClient.up.func_151468_f()) {
            if (markedPosition != null) {
                this.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? EnumFacing.UP : EnumFacing.EAST);
                continue;
            }
            this.processRotateKey(Rotation.Z_CLOCKWISE);
        }
        while (LittleTilesClient.down.func_151468_f()) {
            if (markedPosition != null) {
                this.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? EnumFacing.DOWN : EnumFacing.WEST);
                continue;
            }
            this.processRotateKey(Rotation.Z_COUNTER_CLOCKWISE);
        }
        while (LittleTilesClient.right.func_151468_f()) {
            if (markedPosition != null) {
                this.moveMarkedHit(EnumFacing.SOUTH);
                continue;
            }
            this.processRotateKey(Rotation.Y_COUNTER_CLOCKWISE);
        }
        while (LittleTilesClient.left.func_151468_f()) {
            if (markedPosition != null) {
                this.moveMarkedHit(EnumFacing.NORTH);
                continue;
            }
            this.processRotateKey(Rotation.Y_CLOCKWISE);
        }
    }

    private void moveMarkedHit(EnumFacing facing) {
        LittleTileVec vec = new LittleTileVec(facing);
        vec.scale(GuiScreen.func_146271_m() ? LittleTile.gridSize : 1);
        markedPosition.subVec(vec);
    }
}

