/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.client.rendering.model.CreativeCubeConsumer;
import com.creativemd.creativecore.common.world.WorldFake;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.RenderCubeLayerCache;
import com.creativemd.littletiles.client.render.RenderUploader;
import com.creativemd.littletiles.client.render.optifine.OptifineHelper;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.blocks.BlockLTTransparentColored;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import shadersmod.client.SVertexBuilder;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    public ConcurrentLinkedQueue<RenderingData> updateCoords = new ConcurrentLinkedQueue();
    public ConcurrentHashMap<RenderChunk, AtomicInteger> chunks = new ConcurrentHashMap();
    public static Minecraft mc = Minecraft.func_71410_x();
    public static int nearbyRenderDistance = 1024;
    public static RenderingThread nearbyRenderer = new RenderingThread();
    public static RenderingThread distanceRenderer = new RenderingThread();
    public boolean active = true;
    private static LoadingCache<Pair<VertexFormat, VertexFormat>, int[]> formatMaps;
    private CreativeCubeConsumer consumer = new CreativeCubeConsumer(DefaultVertexFormats.field_176600_a, mc.func_184125_al());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoordToUpdate(TileEntityLittleTiles te, double distanceSq, boolean requiresUpdate) {
        RenderingThread renderer = nearbyRenderer;
        if (distanceSq > (double)nearbyRenderDistance) {
            renderer = distanceRenderer;
        }
        if (!te.rendering.get()) {
            te.rendering.set(true);
            if (requiresUpdate) {
                RenderChunk chunk = te.lastRenderedChunk;
                if (chunk == null) {
                    te.lastRenderedChunk = chunk = RenderUploader.getRenderChunk(RenderUploader.getViewFrustum(), te.func_174877_v());
                }
                ConcurrentHashMap<RenderChunk, AtomicInteger> concurrentHashMap = renderer.chunks;
                synchronized (concurrentHashMap) {
                    AtomicInteger count = renderer.chunks.get(chunk);
                    if (count == null) {
                        count = new AtomicInteger(0);
                        renderer.chunks.put(chunk, count);
                    }
                    count.getAndIncrement();
                }
            }
            renderer.updateCoords.add(new RenderingData(te, LittleTiles.blockTile.func_176223_P(), te.func_174877_v(), requiresUpdate));
        }
    }

    public static void addCoordToUpdate(TileEntityLittleTiles te) {
        try {
            RenderingThread.addCoordToUpdate(te, mc.func_175606_aa().func_174818_b(te.func_174877_v()), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RenderingThread() {
        this.start();
    }

    @Override
    public void run() {
        while (this.active) {
            block30: {
                WorldClient world = RenderingThread.mc.field_71441_e;
                if (world != null && this.updateCoords.size() > 0) {
                    RenderingData data = this.updateCoords.poll();
                    try {
                        BlockPos pos = data.pos;
                        RenderCubeLayerCache cubeCache = data.te.getCubeCache();
                        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                            BlockRenderLayer layer = BlockRenderLayer.values()[i];
                            if (data.te.func_145831_w() == null || !data.te.hasLoaded()) {
                                throw new RenderingException("Tileentity is not loaded yet!");
                            }
                            cubeCache.setCubesByLayer(BlockTile.getRenderingCubes(data.state, (TileEntity)data.te, null, layer), layer);
                            List<LittleRenderingCube> cubes = cubeCache.getCubesByLayer(layer);
                            for (int j = 0; j < cubes.size(); ++j) {
                                RenderCubeObject cube = cubes.get(j);
                                if (!cube.doesNeedQuadUpdate) continue;
                                IBlockState modelState = cube.getBlockState().func_185899_b((IBlockAccess)world, pos);
                                IBakedModel blockModel = mc.func_175602_ab().func_184389_a(modelState);
                                modelState = cube.getModelState(modelState, (IBlockAccess)world, pos);
                                BlockPos offset = cube.getOffset();
                                for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                    EnumFacing facing = EnumFacing.field_82609_l[h];
                                    if (cube.shouldSideBeRendered(facing)) {
                                        if (cube.getQuad(facing) != null) continue;
                                        cube.setQuad(facing, CreativeBakedModel.getBakedQuad((RenderCubeObject)cube, (BlockPos)offset, (IBlockState)modelState, (IBakedModel)blockModel, (EnumFacing)facing, (long)0L, (boolean)false));
                                        continue;
                                    }
                                    cube.setQuad(facing, null);
                                }
                                cube.doesNeedQuadUpdate = false;
                            }
                        }
                        BlockLayerRenderBuffer layerBuffer = new BlockLayerRenderBuffer();
                        if (!layerBuffer.isDrawing()) {
                            data.te.renderIndex = LittleChunkDispatcher.currentRenderIndex.get();
                            try {
                                World renderWorld;
                                layerBuffer.setDrawing();
                                if (!this.consumer.format.equals((Object)DefaultVertexFormats.field_176600_a)) {
                                    this.consumer = new CreativeCubeConsumer(DefaultVertexFormats.field_176600_a, mc.func_184125_al());
                                }
                                if ((renderWorld = data.te.func_145831_w()) instanceof WorldFake && !((WorldFake)renderWorld).shouldRender) {
                                    renderWorld = ((WorldFake)renderWorld).parentWorld;
                                }
                                this.consumer.setWorld((IBlockAccess)renderWorld);
                                this.consumer.setBlockPos(pos);
                                this.consumer.setState(LittleTiles.blockTile.func_176223_P());
                                this.consumer.getBlockInfo().updateLightMatrix();
                                for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                                    BlockRenderLayer layer = BlockRenderLayer.values()[i];
                                    List<LittleRenderingCube> cubes = cubeCache.getCubesByLayer(layer);
                                    VertexBuffer buffer = null;
                                    if (cubes != null && cubes.size() > 0) {
                                        buffer = layerBuffer.createVertexBuffer(cubes.size());
                                    }
                                    if (buffer == null) continue;
                                    this.consumer.buffer = buffer;
                                    this.consumer.layer = layer;
                                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                                    int chunkX = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
                                    int chunkY = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
                                    int chunkZ = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
                                    int offsetX = pos.func_177958_n() - chunkX * 16;
                                    int offsetY = pos.func_177956_o() - chunkY * 16;
                                    int offsetZ = pos.func_177952_p() - chunkZ * 16;
                                    buffer.func_178969_c((double)offsetX, (double)offsetY, (double)offsetZ);
                                    for (int j = 0; j < cubes.size(); ++j) {
                                        RenderCubeObject cube;
                                        this.consumer.cube = cube = (RenderCubeObject)cubes.get(j);
                                        this.consumer.setState(cube.getBlockState());
                                        this.consumer.getBlockInfo().updateShift(false);
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                            IBlockState state = cube.getBlockState();
                                            if (state.func_177230_c() instanceof BlockLTTransparentColored && state.func_177229_b(BlockLTTransparentColored.VARIANT) == BlockLTTransparentColored.EnumType.water) {
                                                state = Blocks.field_150355_j.func_176223_P();
                                            }
                                            SVertexBuilder.pushEntity((IBlockState)state, (BlockPos)pos, (IBlockAccess)data.te.func_145831_w(), (VertexBuffer)buffer);
                                        }
                                        for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                            List quads = cube.getQuad(EnumFacing.field_82609_l[h]);
                                            if (quads == null || quads.isEmpty()) continue;
                                            for (int k = 0; k < quads.size(); ++k) {
                                                BakedQuad quad = (BakedQuad)quads.get(k);
                                                this.consumer.quad = (CreativeBakedQuad)quad;
                                                this.renderQuad(buffer, quad);
                                            }
                                        }
                                        if (!FMLClientHandler.instance().hasOptifine() || !OptifineHelper.isShaders()) continue;
                                        SVertexBuilder.popEntity((VertexBuffer)buffer);
                                    }
                                    this.consumer.quad = null;
                                    this.consumer.cube = null;
                                    if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                        SVertexBuilder.calcNormalChunkLayer((VertexBuffer)buffer);
                                    }
                                    buffer.func_178977_d();
                                    this.consumer.buffer = null;
                                    layerBuffer.setBufferByLayer(buffer, layer);
                                }
                                layerBuffer.setFinishedDrawing();
                                this.setRendered(data, layerBuffer);
                            }
                            catch (BlockLayerRenderBuffer.RenderOverlapException e) {
                                this.updateCoords.add(data);
                            }
                            catch (Exception e) {
                                this.updateCoords.add(data);
                                if (layerBuffer != null) {
                                    layerBuffer.setFinishedDrawing();
                                }
                                break block30;
                            }
                        }
                        this.updateCoords.add(data);
                    }
                    catch (Exception e) {
                        this.updateCoords.add(data);
                    }
                } else if (!(world != null || this.updateCoords.isEmpty() && this.chunks.isEmpty())) {
                    this.updateCoords.clear();
                    this.chunks.clear();
                } else if (world == null || !this.chunks.isEmpty()) {
                    // empty if block
                }
            }
            try {
                RenderingThread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static LoadingCache<Pair<VertexFormat, VertexFormat>, int[]> getFormatMaps() {
        if (formatMaps == null) {
            formatMaps = (LoadingCache)ReflectionHelper.getPrivateValue(LightUtil.class, null, (String[])new String[]{"formatMaps"});
        }
        return formatMaps;
    }

    private synchronized void renderQuad(VertexBuffer buffer, BakedQuad quad) {
        if (quad.func_178212_b()) {
            this.consumer.setQuadTint(quad.func_178211_c());
        }
        this.consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        VertexFormat formatFrom = this.consumer.format;
        VertexFormat formatTo = quad.getFormat();
        int countFrom = formatFrom.func_177345_h();
        int countTo = formatTo.func_177345_h();
        int[] eMap = (int[])RenderingThread.getFormatMaps().getUnchecked((Object)Pair.of((Object)formatFrom, (Object)formatTo));
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack((int[])quad.func_178209_a(), (float[])data, (VertexFormat)quad.getFormat(), (int)v, (int)eMap[e]);
                    this.consumer.put(e, data);
                    continue;
                }
                this.consumer.put(e, new float[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRendered(RenderingData data, BlockLayerRenderBuffer buffer) {
        TileEntityLittleTiles te = data.te;
        te.rendering.set(false);
        if (data.requiresUpdate) {
            RenderChunk chunk = te.lastRenderedChunk;
            if (chunk == null) {
                this.chunks.clear();
                te.setBuffer(buffer);
                return;
            }
            ConcurrentHashMap<RenderChunk, AtomicInteger> concurrentHashMap = this.chunks;
            synchronized (concurrentHashMap) {
                AtomicInteger count;
                if (RenderingThread.distanceRenderer.updateCoords.size() == 0 && RenderingThread.nearbyRenderer.updateCoords.size() == 0) {
                    this.chunks.clear();
                }
                if ((count = this.chunks.get(chunk)) != null) {
                    count.getAndDecrement();
                }
                boolean uploadDirectly = te.getBuffer() == null;
                uploadDirectly = false;
                te.setBuffer(buffer);
                if (count == null || count.intValue() <= 0) {
                    this.chunks.remove(chunk);
                    chunk.func_178575_a(true);
                }
            }
        } else {
            te.setBuffer(buffer);
        }
    }

    private static class RenderingData {
        public TileEntityLittleTiles te;
        public IBlockState state;
        public BlockPos pos;
        public boolean requiresUpdate;

        public RenderingData(TileEntityLittleTiles te, IBlockState state, BlockPos pos, boolean requiresUpdate) {
            this.te = te;
            this.state = state;
            this.pos = pos;
            this.requiresUpdate = requiresUpdate;
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }
}

