/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.tiles;

import com.creativemd.creativecore.common.utils.Rotation;
import net.minecraft.util.EnumFacing;

public enum LittleCorner {
    EUN(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH),
    EUS(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH),
    EDN(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH),
    EDS(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH),
    WUN(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH),
    WUS(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH),
    WDN(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH),
    WDS(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH);

    public final EnumFacing x;
    public final EnumFacing y;
    public final EnumFacing z;

    private LittleCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isFacingPositive(EnumFacing.Axis axis) {
        return this.getFacing(axis).func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
    }

    public EnumFacing getFacing(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return null;
    }

    public LittleCorner flip(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return LittleCorner.getCorner(this.x.func_176734_d(), this.y, this.z);
            }
            case Y: {
                return LittleCorner.getCorner(this.x, this.y.func_176734_d(), this.z);
            }
            case Z: {
                return LittleCorner.getCorner(this.x, this.y, this.z.func_176734_d());
            }
        }
        return null;
    }

    public LittleCorner rotate(Rotation rotation) {
        int normalX = this.x.func_176743_c().func_179524_a();
        int normalY = this.y.func_176743_c().func_179524_a();
        int normalZ = this.z.func_176743_c().func_179524_a();
        return LittleCorner.getCorner(EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getX(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.X), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getY(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Y), EnumFacing.func_181076_a((EnumFacing.AxisDirection)(rotation.getMatrix().getZ(normalX, normalY, normalZ) > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)EnumFacing.Axis.Z));
    }

    public static LittleCorner getCornerUnsorted(EnumFacing facing) {
        switch (facing.func_176740_k()) {
            case X: {
                return LittleCorner.getCorner(facing, EnumFacing.UP, EnumFacing.SOUTH);
            }
            case Y: {
                return LittleCorner.getCorner(EnumFacing.EAST, facing, EnumFacing.SOUTH);
            }
            case Z: {
                return LittleCorner.getCorner(EnumFacing.EAST, EnumFacing.UP, facing);
            }
        }
        return null;
    }

    public static LittleCorner getCornerUnsorted(EnumFacing facing, EnumFacing facing2, EnumFacing facing3) {
        return LittleCorner.getCorner(facing.func_176740_k() != EnumFacing.Axis.X ? (facing2.func_176740_k() != EnumFacing.Axis.X ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Y ? (facing2.func_176740_k() != EnumFacing.Axis.Y ? facing3 : facing2) : facing, facing.func_176740_k() != EnumFacing.Axis.Z ? (facing2.func_176740_k() != EnumFacing.Axis.Z ? facing3 : facing2) : facing);
    }

    public static LittleCorner getCorner(EnumFacing x, EnumFacing y, EnumFacing z) {
        for (LittleCorner corner : LittleCorner.values()) {
            if (corner.x != x || corner.y != y || corner.z != z) continue;
            return corner;
        }
        return null;
    }
}

