/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.container.SubContainerGrabber;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.ingredients.CombinedIngredients;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileAbsoluteCoord;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleAction
extends CreativeCorePacket {
    private static List<LittleAction> lastActions = new ArrayList<LittleAction>();
    private static int index = 0;
    private static Method WorldEditEvent = LittleAction.loadWorldEditEvent();
    private static Object worldEditInstance = null;

    @SideOnly(value=Side.CLIENT)
    public static boolean isUsingSecondMode(EntityPlayer player) {
        if (LittleTilesConfig.building.useALTForEverything) {
            return GuiScreen.func_175283_s();
        }
        if (LittleTilesConfig.building.useAltWhenFlying) {
            return player.field_71075_bZ.field_75100_b ? GuiScreen.func_175283_s() : player.func_70093_af();
        }
        return player.func_70093_af();
    }

    public static void rememberAction(LittleAction action) {
        if (!action.canBeReverted()) {
            return;
        }
        if (index > 0) {
            lastActions = index < lastActions.size() ? lastActions.subList(index, lastActions.size() - 1) : new ArrayList<LittleAction>();
        }
        index = 0;
        if (lastActions.size() == LittleTilesConfig.building.maxSavedActions) {
            lastActions.remove(LittleTilesConfig.building.maxSavedActions - 1);
        }
        lastActions.add(0, action);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean undo() throws LittleActionException {
        if (lastActions.size() > index) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LittleAction reverted = lastActions.get(index).revert();
            if (reverted == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.action((EntityPlayer)player)) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                lastActions.set(index, reverted);
                ++index;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean redo() throws LittleActionException {
        if (index > 0 && index <= lastActions.size()) {
            LittleAction reverted;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if ((reverted = lastActions.get(--index).revert()) == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            if (reverted.action((EntityPlayer)player)) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                lastActions.set(index, reverted);
                return true;
            }
        }
        return false;
    }

    public static void registerLittleAction(String id, Class<? extends LittleAction> ... classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            CreativeCorePacket.registerPacket(classTypes[i], (String)("ac" + id + i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean canBeReverted();

    @SideOnly(value=Side.CLIENT)
    public abstract LittleAction revert() throws LittleActionException;

    protected abstract boolean action(EntityPlayer var1) throws LittleActionException;

    @SideOnly(value=Side.CLIENT)
    public boolean execute() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        try {
            if (this.action((EntityPlayer)player)) {
                LittleAction.rememberAction(this);
                PacketHandler.sendPacketToServer((CreativeCorePacket)this);
                return true;
            }
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
            return false;
        }
        return false;
    }

    public void executeClient(EntityPlayer player) {
        try {
            this.action(player);
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public void executeServer(EntityPlayer player) {
        try {
            this.action(player);
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public static TileEntityLittleTiles loadTe(World world, BlockPos pos, boolean shouldConvert) {
        Object tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityLittleTiles)) {
            List<LittleTile> tiles = ChiselsAndBitsManager.getTiles(tileEntity);
            if (tileEntity == null && tiles == null) {
                IBlockState state = world.func_180495_p(pos);
                if (shouldConvert && SubContainerGrabber.isBlockValid(state.func_177230_c())) {
                    tiles = new ArrayList<LittleTile>();
                    LittleTileBox box = new LittleTileBox(LittleTile.minPos, LittleTile.minPos, LittleTile.minPos, LittleTile.maxPos, LittleTile.maxPos, LittleTile.maxPos);
                    LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.box = box;
                    tiles.add(tile);
                } else if (state.func_185904_a().func_76222_j()) {
                    world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
                    tileEntity = (TileEntityLittleTiles)world.func_175625_s(pos);
                }
            }
            if (tiles != null && tiles.size() > 0) {
                world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
                tileEntity = world.func_175625_s(pos);
                for (LittleTile tile : tiles) {
                    tile.te = (TileEntityLittleTiles)tileEntity;
                    tile.place();
                }
            }
        }
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    private static Method loadWorldEditEvent() {
        try {
            Class<?> clazz = Class.forName("com.sk89q.worldedit.forge.ForgeWorldEdit");
            worldEditInstance = clazz.getField("inst").get(null);
            return clazz.getMethod("onPlayerInteract", PlayerInteractEvent.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isAllowedToInteract(EntityPlayer player, BlockPos pos, boolean rightClick, EnumFacing facing) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return true;
        }
        if (WorldEditEvent != null) {
            PlayerInteractEvent.RightClickBlock event = rightClick ? new PlayerInteractEvent.RightClickBlock(player, EnumHand.MAIN_HAND, pos, facing, new Vec3d((Vec3i)pos)) : new PlayerInteractEvent.LeftClickBlock(player, pos, facing, new Vec3d((Vec3i)pos));
            try {
                if (worldEditInstance == null) {
                    LittleAction.loadWorldEditEvent();
                }
                WorldEditEvent.invoke(worldEditInstance, event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (event.isCanceled()) {
                return false;
            }
        }
        return !player.func_184102_h().func_175579_a(player.field_70170_p, pos, player);
    }

    public static boolean isTileStillInPlace(LittleTile tile) {
        return tile.te.getTiles().contains(tile);
    }

    public static LittleTile getTile(World world, LittleTileAbsoluteCoord coord) throws LittleActionException {
        TileEntity te = world.func_175625_s(coord.pos);
        if (te instanceof TileEntityLittleTiles) {
            LittleTile tile = ((TileEntityLittleTiles)te).getTile(coord.identifier);
            if (tile != null) {
                return tile;
            }
            throw new LittleActionException.TileNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }

    public static void writeAbsoluteCoord(LittleTileAbsoluteCoord coord, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)coord.pos);
        buf.writeInt(coord.identifier.length);
        for (int i = 0; i < coord.identifier.length; ++i) {
            buf.writeInt(coord.identifier[i]);
        }
    }

    public static LittleTileAbsoluteCoord readAbsoluteCoord(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        int[] identifier = new int[]{buf.readInt()};
        for (int i = 0; i < identifier.length; ++i) {
            identifier[i] = buf.readInt();
        }
        return new LittleTileAbsoluteCoord(pos, identifier);
    }

    public static void writeLittleVec(LittleTileVec vec, ByteBuf buf) {
        buf.writeInt(vec.x);
        buf.writeInt(vec.y);
        buf.writeInt(vec.z);
    }

    public static LittleTileVec readLittleVec(ByteBuf buf) {
        return new LittleTileVec(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeLittleBox(LittleTileBox box, ByteBuf buf) {
        int[] array = box.getArray();
        buf.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            buf.writeInt(array[i]);
        }
    }

    public static LittleTileBox readLittleBox(ByteBuf buf) {
        int[] array = new int[buf.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buf.readInt();
        }
        return LittleTileBox.createBox(array);
    }

    public static boolean needIngredients(EntityPlayer player) {
        return !player.func_184812_l_();
    }

    public static boolean drainPreviews(EntityPlayer player, List<LittleTilePreview> previews) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ColorUnit color = new ColorUnit();
            BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
            for (LittleTilePreview preview : previews) {
                if (!preview.canBeConvertedToBlockEntry()) continue;
                ingredients.addIngredient(preview.getBlockIngredient());
                color.addColorUnit(ColorUnit.getRequiredColors(preview));
            }
            return LittleAction.drainIngredients(player, ingredients, color);
        }
        return true;
    }

    public static BlockIngredient getIngredientsOfStackSimple(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null && !(block instanceof BlockAir) && SubContainerGrabber.isBlockValid(block)) {
            return new BlockIngredient(block, stack.func_77952_i(), 1.0);
        }
        return null;
    }

    public static CombinedIngredients getIngredientsOfStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            List<LittleTilePreview> tiles;
            ILittleTile tile = PlacementHelper.getLittleInterface(stack);
            if (tile != null && tile.hasLittlePreview(stack) && tile.containsIngredients(stack) && (tiles = tile.getLittlePreview(stack)) != null) {
                CombinedIngredients ingredients = new CombinedIngredients();
                for (int i = 0; i < tiles.size(); ++i) {
                    LittleTilePreview preview = tiles.get(i);
                    if (!preview.canBeConvertedToBlockEntry()) continue;
                    ingredients.block.addIngredient(preview.getBlockIngredient());
                    ingredients.color.addColorUnit(ColorUnit.getRequiredColors(preview));
                }
                return ingredients;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block != null && !(block instanceof BlockAir) && SubContainerGrabber.isBlockValid(block)) {
                CombinedIngredients ingredients = new CombinedIngredients();
                ingredients.block.addIngredient(new BlockIngredient(block, stack.func_77952_i(), 1.0));
                return ingredients;
            }
        }
        return null;
    }

    public static boolean drainIngredients(EntityPlayer player, BlockIngredient.BlockIngredients ingredients, ColorUnit unit) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ColorUnit color;
            List<ItemStack> bags = LittleAction.getBags(player);
            ArrayList<ItemStack> usedBags = new ArrayList<ItemStack>();
            Object toCheck = ingredients != null ? ingredients.copy() : null;
            ColorUnit colorUnit = color = unit != null ? unit.copy() : null;
            if (color != null && color.isEmpty()) {
                color = null;
            }
            for (ItemStack stack : bags) {
                ItemStack used = stack.func_77946_l();
                if (toCheck != null) {
                    toCheck = ItemTileContainer.drainBlocks(used, (BlockIngredient.BlockIngredients)toCheck, false);
                }
                if (color != null) {
                    color = ItemTileContainer.drainColor(used, color, false);
                }
                usedBags.add(used);
            }
            if (color != null) {
                throw new NotEnoughIngredientsException.NotEnoughColorException(color);
            }
            if (toCheck != null) {
                BlockIngredient.BlockIngredients additionalIngredients = new BlockIngredient.BlockIngredients();
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    BlockIngredient leftOver = ((BlockIngredient.BlockIngredients)toCheck).drainItemStack(player.field_71071_by.func_70301_a(i).func_77946_l());
                    if (leftOver != null) {
                        additionalIngredients.addIngredient(leftOver);
                    }
                    if (((BlockIngredient.BlockIngredients)toCheck).isEmpty()) break;
                }
                if (!((BlockIngredient.BlockIngredients)toCheck).isEmpty()) {
                    throw new NotEnoughIngredientsException.NotEnoughVolumeExcepion((BlockIngredient.BlockIngredients)toCheck);
                }
                LittleAction.addIngredients(usedBags, additionalIngredients, null);
            }
            for (ItemStack stack : bags) {
                if (ingredients != null) {
                    ingredients = ItemTileContainer.drainBlocks(stack, ingredients, false);
                }
                if (unit == null) continue;
                unit = ItemTileContainer.drainColor(stack, unit, false);
            }
            if (ingredients != null) {
                BlockIngredient.BlockIngredients additionalIngredients = new BlockIngredient.BlockIngredients();
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    BlockIngredient leftOver = ingredients.drainItemStack(player.field_71071_by.func_70301_a(i));
                    if (leftOver != null) {
                        additionalIngredients.addIngredient(leftOver);
                    }
                    if (ingredients.isEmpty()) break;
                }
                LittleAction.addIngredients(player, additionalIngredients, null);
            }
        }
        return true;
    }

    public static boolean addTileToInventory(EntityPlayer player, LittleTile tile) throws NotEnoughIngredientsException {
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        previews.add(tile.getPreviewTile());
        return LittleAction.addPreviewToInventory(player, previews);
    }

    public static boolean addTilesToInventory(EntityPlayer player, List<LittleTile> tiles) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
            for (LittleTile tile : tiles) {
                previews.add(tile.getPreviewTile());
            }
            return LittleAction.addPreviewToInventory(player, previews);
        }
        return true;
    }

    public static boolean addPreviewToInventory(EntityPlayer player, List<LittleTilePreview> previews) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            ColorUnit color = new ColorUnit();
            BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
            for (LittleTilePreview preview : previews) {
                if (!preview.canBeConvertedToBlockEntry()) continue;
                ingredients.addIngredient(preview.getBlockIngredient());
                color.addColorUnit(ColorUnit.getRequiredColors(preview));
            }
            return LittleAction.addIngredients(player, ingredients, color);
        }
        return true;
    }

    public static boolean store(List<ItemStack> bags, BlockIngredient.BlockIngredients toCheck, ColorUnit color, boolean simulate) throws NotEnoughIngredientsException {
        for (ItemStack stack : bags) {
            if (toCheck != null) {
                toCheck = ItemTileContainer.storeBlocks(stack, toCheck, true, simulate);
            }
            if (color != null) {
                color = ItemTileContainer.storeColor(stack, color, simulate);
            }
            if (toCheck != null || color != null) continue;
            break;
        }
        if (color == null && toCheck != null) {
            ItemStack stack;
            Iterator<ItemStack> iterator = bags.iterator();
            while (iterator.hasNext() && (toCheck = ItemTileContainer.storeBlocks(stack = iterator.next(), toCheck, false, simulate)) != null) {
            }
        }
        if (color != null && !color.isEmpty()) {
            throw new NotEnoughIngredientsException.NotEnoughColorSpaceException();
        }
        if (toCheck != null) {
            throw new NotEnoughIngredientsException.NotEnoughVolumeSpaceException();
        }
        return true;
    }

    public static boolean addIngredients(EntityPlayer player, CombinedIngredients ingredients) throws NotEnoughIngredientsException {
        return LittleAction.addIngredients(player, ingredients.block, ingredients.color);
    }

    public static boolean addIngredients(EntityPlayer player, BlockIngredient.BlockIngredients ingredients, ColorUnit unit) throws NotEnoughIngredientsException {
        return LittleAction.addIngredients(player, ingredients, unit, false);
    }

    public static boolean addIngredients(EntityPlayer player, BlockIngredient.BlockIngredients ingredients, ColorUnit unit, boolean simulate) throws NotEnoughIngredientsException {
        List<ItemStack> bags;
        if (LittleAction.needIngredients(player) && LittleAction.store(bags = LittleAction.getBags(player), ingredients != null ? ingredients.copy() : null, unit != null ? unit.copy() : null, true) && !simulate) {
            LittleAction.store(bags, ingredients, unit, false);
        }
        return true;
    }

    public static boolean addIngredients(List<ItemStack> bags, BlockIngredient.BlockIngredients ingredients, ColorUnit unit) throws NotEnoughIngredientsException {
        if (LittleAction.store(bags, ingredients, unit, true)) {
            LittleAction.store(bags, ingredients, unit, false);
        }
        return true;
    }

    public static List<ItemStack> getBags(EntityPlayer player) {
        ArrayList<ItemStack> bags = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemTileContainer)) continue;
            bags.add(stack);
        }
        return bags;
    }
}

