/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class LittleActionBoxes
extends LittleAction {
    public List<LittleTileBox> boxes;

    public LittleActionBoxes(List<LittleTileBox> boxes) {
        this.boxes = boxes;
    }

    public LittleActionBoxes() {
    }

    public abstract void action(World var1, EntityPlayer var2, BlockPos var3, IBlockState var4, List<LittleTileBox> var5) throws LittleActionException;

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        boolean placed = false;
        World world = player.field_70170_p;
        HashMapList boxesMap = new HashMapList();
        for (int i = 0; i < this.boxes.size(); ++i) {
            this.boxes.get(i).split((HashMapList<BlockPos, LittleTileBox>)boxesMap);
        }
        for (Map.Entry entry : boxesMap.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            IBlockState state = world.func_180495_p(pos);
            if (!LittleActionBoxes.isAllowedToInteract(player, pos, false, EnumFacing.EAST)) {
                world.func_184138_a(pos, state, state, 3);
                continue;
            }
            placed = true;
            this.action(world, player, pos, state, (List)entry.getValue());
        }
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return placed;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.boxes.size());
        for (LittleTileBox box : this.boxes) {
            LittleActionBoxes.writeLittleBox(box, buf);
        }
    }

    public void readBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.boxes = new ArrayList<LittleTileBox>();
        for (int i = 0; i < size; ++i) {
            this.boxes.add(LittleActionBoxes.readLittleBox(buf));
        }
    }
}

