/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionColorBoxes
extends LittleActionBoxes {
    public int color;
    public boolean toVanilla;
    public HashMapList<Integer, LittleTileBox> revertList;

    public LittleActionColorBoxes(List<LittleTileBox> boxes, int color, boolean toVanilla) {
        super(boxes);
        this.color = color;
        this.toVanilla = toVanilla;
    }

    public LittleActionColorBoxes() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeInt(this.color);
        buf.writeBoolean(this.toVanilla);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.color = buf.readInt();
        this.toVanilla = buf.readBoolean();
    }

    public void addRevert(int color, List<LittleTileBox> boxes, LittleTileVec offset) {
        ArrayList<LittleTileBox> newBoxes = new ArrayList<LittleTileBox>();
        for (LittleTileBox box : boxes) {
            box = box.copy();
            box.addOffset(offset);
            newBoxes.add(box);
        }
        this.revertList.add((Object)color, newBoxes);
    }

    public ColorUnit action(TileEntityLittleTiles te, List<LittleTileBox> boxes, ColorUnit gained, boolean simulate) {
        LittleTileVec offset = new LittleTileVec((Vec3i)te.func_174877_v());
        double colorVolume = 0.0;
        for (LittleTile tile : te.getTiles()) {
            boolean intersects = false;
            for (int j = 0; j < boxes.size(); ++j) {
                if (!tile.intersectsWith(boxes.get(j))) continue;
                intersects = true;
                break;
            }
            if (!intersects || tile.getClass() != LittleTileBlock.class && !(tile instanceof LittleTileBlockColored) || tile.isStructureBlock && (!tile.isLoaded() || !tile.structure.hasLoaded())) continue;
            if (tile.canBeSplitted() && LittleTileBlockColored.needsToBeRecolored((LittleTileBlock)tile, this.color)) {
                LittleTile newTile;
                int i;
                if (simulate) {
                    double volume = 0.0;
                    ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                    tile.cutOut(boxes, cutout);
                    for (LittleTileBox box2 : cutout) {
                        colorVolume += box2.getPercentVolume();
                        volume += box2.getPercentVolume();
                    }
                    gained.addColorUnit(ColorUnit.getRequiredColors(tile.getPreviewTile(), volume));
                    continue;
                }
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes == null) continue;
                this.addRevert(LittleTileBlockColored.getColor((LittleTileBlock)tile), cutout, offset);
                LittleTile tempTile = tile.copy();
                LittleTile changedTile = LittleTileBlockColored.setColor((LittleTileBlock)tempTile, this.color);
                if (changedTile == null) {
                    changedTile = tempTile;
                }
                if (tile.isStructureBlock) {
                    tile.structure.removeTile(tile);
                }
                for (i = 0; i < newBoxes.size(); ++i) {
                    newTile = tile.copy();
                    newTile.box = newBoxes.get(i);
                    newTile.place();
                    if (!tile.isStructureBlock) continue;
                    tile.structure.addTile(newTile);
                }
                for (i = 0; i < cutout.size(); ++i) {
                    newTile = changedTile.copy();
                    newTile.box = (LittleTileBox)cutout.get(i);
                    newTile.place();
                    if (!tile.isStructureBlock) continue;
                    tile.structure.addTile(newTile);
                }
                if (tile.isMainBlock) {
                    tile.structure.selectMainTile();
                }
                if (tile.isStructureBlock) {
                    tile.structure.updateStructure();
                }
                tile.isStructureBlock = false;
                tile.destroy();
                continue;
            }
            if (simulate) {
                colorVolume += tile.getPercentVolume();
                gained.addColorUnit(ColorUnit.getRequiredColors(tile.getPreviewTile(), tile.getPercentVolume()));
                continue;
            }
            ArrayList<LittleTileBox> oldBoxes = new ArrayList<LittleTileBox>();
            oldBoxes.add(tile.box);
            this.addRevert(LittleTileBlockColored.getColor((LittleTileBlock)tile), oldBoxes, offset);
            LittleTileBlock changedTile = LittleTileBlockColored.setColor((LittleTileBlock)tile, this.color);
            if (changedTile == null) continue;
            ((LittleTile)changedTile).place();
            if (!tile.isStructureBlock) continue;
            changedTile.isStructureBlock = true;
            changedTile.structure.removeTile(tile);
            changedTile.structure.addTile(changedTile);
            if (tile.isStructureBlock) {
                tile.structure.updateStructure();
            }
            tile.isStructureBlock = false;
            tile.destroy();
            if (!tile.isMainBlock) continue;
            changedTile.structure.setMainTile(changedTile);
        }
        ColorUnit toDrain = ColorUnit.getRequiredColors(this.color);
        toDrain.scale(colorVolume);
        gained.drain(toDrain);
        return toDrain;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleTileBox> boxes) throws LittleActionException {
        TileEntityLittleTiles tileEntity = LittleActionColorBoxes.loadTe(world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = tileEntity;
            ArrayList entries = new ArrayList();
            te.preventUpdate = true;
            ColorUnit gained = new ColorUnit();
            ColorUnit toDrain = this.action(te, boxes, gained, true);
            if (LittleActionColorBoxes.addIngredients(player, null, gained, true)) {
                LittleActionColorBoxes.drainIngredients(player, null, toDrain);
                LittleActionColorBoxes.addIngredients(player, null, gained);
                this.action(te, boxes, gained, false);
            }
            te.preventUpdate = false;
            te.combineTiles();
            if (this.toVanilla) {
                te.convertBlockToVanilla();
            }
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.revertList = new HashMapList();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        LittleAction[] actions = new LittleAction[this.revertList.size()];
        int i = 0;
        for (Map.Entry entry : this.revertList.entrySet()) {
            actions[i] = new LittleActionColorBoxes((List)entry.getValue(), (Integer)entry.getKey(), true);
            ++i;
        }
        return new LittleActionCombined(actions);
    }
}

