/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.InventoryUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.items.ItemLittleWrench;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionDestroy
extends LittleActionInteract {
    public List<LittleTilePreview> destroyedTiles;
    public StructurePreview structurePreview;

    public LittleActionDestroy(BlockPos blockPos, EntityPlayer player) {
        super(blockPos, player);
    }

    public LittleActionDestroy() {
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        if (this.structurePreview != null) {
            return this.structurePreview.getPlaceAction();
        }
        return new LittleActionPlaceAbsolute(this.destroyedTiles, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (tile.isStructureBlock) {
            boolean loaded;
            boolean bl = loaded = tile.isLoaded() && tile.structure.hasLoaded();
            if (!loaded && !(player.func_184614_ca().func_77973_b() instanceof ItemLittleWrench)) throw new LittleActionException.StructureNotLoadedException();
            if (loaded) {
                this.structurePreview = new StructurePreview(tile.structure);
                ItemStack drop = tile.structure.getStructureDrop();
                if (LittleActionDestroy.needIngredients(player) && !InventoryUtils.addItemStackToInventory((IInventory)player.field_71071_by, (ItemStack)drop)) {
                    WorldUtils.dropItem((World)world, (ItemStack)drop, (BlockPos)pos);
                }
                tile.destroy();
            } else {
                tile.te.removeTile(tile);
            }
        } else {
            this.destroyedTiles = new ArrayList<LittleTilePreview>();
            if (BlockTile.selectEntireBlock(player, secondMode)) {
                ArrayList<LittleTile> remains = new ArrayList<LittleTile>();
                for (LittleTile toDestory : te.getTiles()) {
                    if (!toDestory.isStructureBlock) {
                        LittleTilePreview preview = toDestory.getPreviewTile();
                        preview.box.addOffset((Vec3i)toDestory.te.func_174877_v());
                        this.destroyedTiles.add(preview);
                        continue;
                    }
                    remains.add(toDestory);
                }
                LittleActionDestroy.addPreviewToInventory(player, this.destroyedTiles);
                te.getTiles().clear();
                te.getTiles().addAll(remains);
                te.updateTiles();
            } else {
                LittleTilePreview preview = tile.getPreviewTile();
                preview.box.addOffset((Vec3i)tile.te.func_174877_v());
                this.destroyedTiles.add(preview);
                LittleActionDestroy.addPreviewToInventory(player, this.destroyedTiles);
                tile.destroy();
            }
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    public static class StructurePreview {
        public List<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        public LittleStructure structure;

        public StructurePreview(LittleStructure structure) {
            Iterator<LittleTile> iterator = structure.getTiles();
            while (iterator.hasNext()) {
                LittleTile tile2 = iterator.next();
                LittleTilePreview preview = tile2.getPreviewTile();
                preview.box.addOffset((Vec3i)tile2.te.func_174877_v());
                this.previews.add(preview);
            }
            this.structure = structure;
        }

        public LittleAction getPlaceAction() {
            return new LittleActionPlaceAbsolute(this.previews, this.structure, false, true, false);
        }

        public int hashCode() {
            return this.structure.hashCode();
        }

        public boolean equals(Object paramObject) {
            if (paramObject instanceof StructurePreview) {
                return this.structure == ((StructurePreview)paramObject).structure;
            }
            if (paramObject instanceof LittleStructure) {
                return this.structure == paramObject;
            }
            return false;
        }
    }
}

