/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.InventoryUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.ingredients.CombinedIngredients;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionDestroyBoxes
extends LittleActionBoxes {
    public List<LittleActionDestroy.StructurePreview> destroyedStructures;
    public List<LittleTilePreview> previews;

    public LittleActionDestroyBoxes(List<LittleTileBox> boxes) {
        super(boxes);
    }

    public LittleActionDestroyBoxes() {
    }

    private boolean containsStructure(LittleStructure structure) {
        for (LittleActionDestroy.StructurePreview structurePreview : this.destroyedStructures) {
            if (structurePreview.structure != structure) continue;
            return true;
        }
        return false;
    }

    public CombinedIngredients action(EntityPlayer player, TileEntityLittleTiles te, List<LittleTileBox> boxes, boolean simulate) {
        LittleTileVec offset = new LittleTileVec((Vec3i)te.func_174877_v());
        CombinedIngredients ingredients = new CombinedIngredients();
        for (LittleTile tile : te.getTiles()) {
            boolean intersects = false;
            for (int j = 0; j < boxes.size(); ++j) {
                if (!tile.intersectsWith(boxes.get(j))) continue;
                intersects = true;
                break;
            }
            if (!intersects) continue;
            if (!tile.isStructureBlock && tile.canBeSplitted()) {
                double volume = 0.0;
                LittleTilePreview preview = tile.getPreviewTile();
                ArrayList<LittleTileBox> cutout = new ArrayList<LittleTileBox>();
                List<LittleTileBox> newBoxes = tile.cutOut(boxes, cutout);
                if (newBoxes != null) {
                    if (!simulate) {
                        for (int i = 0; i < newBoxes.size(); ++i) {
                            LittleTile newTile = tile.copy();
                            newTile.box = newBoxes.get(i);
                            newTile.place();
                        }
                        tile.destroy();
                    }
                    for (int l = 0; l < cutout.size(); ++l) {
                        volume += ((LittleTileBox)cutout.get(l)).getPercentVolume();
                        if (simulate) continue;
                        LittleTilePreview preview2 = preview.copy();
                        preview2.box = ((LittleTileBox)cutout.get(l)).copy();
                        preview2.box.addOffset(offset);
                        this.previews.add(preview2);
                    }
                }
                if (!(volume > 0.0)) continue;
                ingredients.addPreview(preview, volume);
                continue;
            }
            ingredients.addPreview(tile.getPreviewTile());
            if (simulate) continue;
            if (!this.containsStructure(tile.structure) && tile.isLoaded() && tile.structure.hasLoaded()) {
                this.destroyedStructures.add(new LittleActionDestroy.StructurePreview(tile.structure));
                ItemStack drop = tile.structure.getStructureDrop();
                if (LittleActionDestroyBoxes.needIngredients(player) && !InventoryUtils.addItemStackToInventory((IInventory)player.field_71071_by, (ItemStack)drop)) {
                    WorldUtils.dropItem((World)player.field_70170_p, (ItemStack)drop, (BlockPos)tile.te.func_174877_v());
                }
                tile.destroy();
                continue;
            }
            LittleTilePreview preview = tile.getPreviewTile();
            preview.box.addOffset(offset);
            this.previews.add(preview);
            tile.destroy();
        }
        return ingredients;
    }

    @Override
    public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state, List<LittleTileBox> boxes) throws LittleActionException {
        TileEntityLittleTiles tileEntity = LittleActionDestroyBoxes.loadTe(world, pos, true);
        if (tileEntity instanceof TileEntityLittleTiles && LittleActionDestroyBoxes.addIngredients(player, this.action(player, tileEntity, boxes, true))) {
            this.action(player, tileEntity, boxes, false);
        }
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        this.previews = new ArrayList<LittleTilePreview>();
        this.destroyedStructures = new ArrayList<LittleActionDestroy.StructurePreview>();
        return super.action(player);
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        boolean additionalPreviews = this.previews.size() > 0;
        LittleAction[] actions = new LittleAction[additionalPreviews ? 1 : 0 + this.destroyedStructures.size()];
        if (additionalPreviews) {
            actions[0] = new LittleActionPlaceAbsolute(this.previews, null, false, true, true);
        }
        for (int i = 0; i < this.destroyedStructures.size(); ++i) {
            actions[additionalPreviews ? 1 : 0 + i] = this.destroyedStructures.get(i).getPlaceAction();
        }
        return new LittleActionCombined(actions);
    }
}

